/*
 * Decompiled with CFR 0.152.
 */
package raytrace;

import framework.M3d;
import framework.M4x4;
import framework.Renderer;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import raytrace.GLTextureCanvas;
import raytrace.engine.Camera;
import raytrace.engine.Plane;
import raytrace.engine.RayTracer;
import raytrace.engine.Scene;
import raytrace.engine.Sphere;

public class RayTracerDemo
extends Renderer {
    Camera camera;
    Scene scene;
    GLTextureCanvas canvas = new GLTextureCanvas(512, 512);
    RayTracer raytracer;
    boolean autoResizeRequested = false;
    Sphere S;
    public static final int WIDTH = 512;
    public static final int HEIGHT = 512;

    @Override
    public String getTitle() {
        return "Ray Tracer";
    }

    public RayTracerDemo() {
        this.cameraDistance = 1.0f;
        this.showAxes = false;
        this.camera = new Camera(new M3d(4.0, 4.0, 10.0).times(4.0));
        this.scene = new Scene();
        this.scene.addLight(new M3d(20.0, 20.0, 0.0));
        Plane P = new Plane(new M3d(1.0, 1.0, 1.0));
        P.setLocalTransform(M4x4.translation(new M3d(0.0, -1.5, 0.0)));
        P.getMaterial().setLightingCoefficients(1.0, 0.4, 0.4, 5.0);
        this.scene.add(P);
        this.S = new Sphere(new M3d(0.2, 0.6, 0.8));
        this.S.getMaterial().setLightingCoefficients(0.2, 0.4, 0.4, 5.0);
        this.S.getMaterial().setReflectivity(0.0);
        this.S.getMaterial().setTransparency(0.5);
        this.S.getMaterial().setRefractiveIndex(1.5);
        this.S.setLocalTransform(M4x4.scale(new M3d(1.5, 1.5, 1.5)));
        this.scene.add(this.S);
        this.raytracer = new RayTracer(this.scene, this.canvas, this.camera);
    }

    public RayTracerDemo withAutoResizeRequested() {
        this.autoResizeRequested = true;
        return this;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            default: {
                super.keyPressed(e);
                break;
            }
            case 49: {
                this.cameraDistance = 1.0f;
                this.cameraTransform = new M4x4();
                break;
            }
            case 50: {
                this.cameraDistance = 2.0f;
                this.cameraTransform = M4x4.rotation(new M3d(0.0, 1.0, 0.0), -0.39269908169872414);
                this.cameraTransform.rotate(new M3d(1.0, 0.0, -1.0), 0.39269908169872414);
                this.cameraTransform.rotate(new M3d(0.0, 0.0, 1.0), 0.2454369260617026);
            }
            case 51: 
        }
    }

    @Override
    public void preDisplay(GLAutoDrawable glDrawable) {
        if (this.autoResizeRequested) {
            this.autoResizeRequested = false;
            Frame.getFrames()[0].setSize(512, 512);
        }
        super.preDisplay(glDrawable);
    }

    public void display(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        this.preDisplay(glDrawable);
        this.raytracer.renderSceneProgressively();
        this.canvas.render(gl);
        this.postDisplay(glDrawable);
    }
}

