/*
 * Decompiled with CFR 0.152.
 */
package blobby.engine;

import blobby.engine.Force;
import blobby.engine.OctTreeEdge;
import blobby.engine.Octree;
import framework.M3d;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ImplicitSurface {
    private double cutoff = 0.5;
    private boolean slowCheckForHoles = false;
    private int targetLevel = 4;
    private M3d min;
    private double scale;
    private int fx;
    private int fy;
    private int fz;
    private LinkedList<Force> forces = new LinkedList();
    private HashMap<M3d, Double> samples;
    private LinkedList<Octree> inProgress;
    private LinkedList<Octree> finished;
    private LinkedList<Octree> roots;
    private HashMap<M3d, HashMap<M3d, OctTreeEdge>> edgeMap;

    public ImplicitSurface(M3d min, M3d max, int targetLevel) {
        double dx = max.getX() - min.getX();
        double dy = max.getY() - min.getY();
        double dz = max.getZ() - min.getZ();
        this.min = min;
        this.targetLevel = targetLevel;
        this.scale = dx < dy && dx < dz ? dx : (dy < dx && dy < dz ? dy : dz);
        this.fx = (int)Math.ceil(dx / this.scale);
        this.fy = (int)Math.ceil(dy / this.scale);
        this.fz = (int)Math.ceil(dz / this.scale);
        this.reset();
    }

    public void reset() {
        int z;
        M3d[][][] coords = new M3d[this.fx + 1][this.fy + 1][this.fz + 1];
        LinkedList<M3d> targets = new LinkedList<M3d>();
        this.samples = new HashMap();
        this.inProgress = new LinkedList();
        this.finished = new LinkedList();
        this.roots = new LinkedList();
        this.edgeMap = new HashMap();
        for (Force f : this.forces) {
            if (!(f instanceof M3d)) continue;
            targets.add((M3d)((Object)f));
        }
        int x = 0;
        while (x <= this.fx) {
            int y = 0;
            while (y <= this.fy) {
                z = 0;
                while (z <= this.fz) {
                    coords[x][y][z] = new M3d(this.min.getX() + (double)x * this.scale, this.min.getY() + (double)y * this.scale, this.min.getZ() + (double)z * this.scale);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.fx) {
            int y = 0;
            while (y < this.fy) {
                z = 0;
                while (z < this.fz) {
                    this.inProgress.add(new Octree(this, 0, coords, x, y, z, targets));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.roots.addAll(this.inProgress);
    }

    private List<Octree> findContainer(M3d pt, Octree parent) {
        LinkedList<Octree> ret = new LinkedList<Octree>();
        boolean addedChild = false;
        Octree[][][] kids = parent.getChildOctrees();
        if (parent.encloses(pt)) {
            if (kids != null) {
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 2) {
                        int k = 0;
                        while (k < 2) {
                            List<Octree> containingKids;
                            if (kids[i][j][k] != null && !(containingKids = this.findContainer(pt, kids[i][j][k])).isEmpty()) {
                                ret.addAll(containingKids);
                                addedChild = true;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (!addedChild) {
                ret.add(parent);
            }
        }
        return ret;
    }

    private List<Octree> findContainer(M3d pt) {
        LinkedList<Octree> ret = new LinkedList<Octree>();
        for (Octree root : this.roots) {
            if (!root.encloses(pt)) continue;
            ret.addAll(this.findContainer(pt, root));
        }
        return ret;
    }

    private Octree findUniqueContainer(M3d pt) {
        List<Octree> containers = this.findContainer(pt);
        if (containers.size() == 1) {
            return containers.get(0);
        }
        return null;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
    }

    public int getTargetLevel() {
        return this.targetLevel;
    }

    public void setTargetLevel(int targetLevel) {
        this.targetLevel = targetLevel;
        this.reset();
    }

    public LinkedList<Octree> getInProgress() {
        return this.inProgress;
    }

    public LinkedList<Octree> getFinished() {
        return this.finished;
    }

    double sumForces(M3d v) {
        double sum = 0.0;
        if (!this.samples.containsKey(v)) {
            for (Force f : this.forces) {
                sum += f.F(v);
            }
            this.samples.put(v, sum);
        } else {
            sum = this.samples.get(v);
        }
        return sum;
    }

    boolean isHot(M3d v) {
        return this.sumForces(v) > this.cutoff;
    }

    public void addForce(Force f) {
        this.forces.add(f);
    }

    public boolean addInterpolants(OctTreeEdge edge) {
        M3d a = edge.getEndPt(0);
        M3d b = edge.getEndPt(1);
        double ta = this.sumForces(a);
        double tb = this.sumForces(b);
        if (ta <= this.cutoff && tb > this.cutoff) {
            double t = (this.cutoff - ta) / (tb - ta);
            edge.setCrossingData(new M3d(a.plus(b.minus(a).times(t))), a.minus(b).normalized());
            return true;
        }
        if (tb <= this.cutoff && ta > this.cutoff) {
            double t = (this.cutoff - tb) / (ta - tb);
            edge.setCrossingData(new M3d(b.plus(a.minus(b).times(t))), b.minus(a).normalized());
            return true;
        }
        return false;
    }

    public OctTreeEdge getEdge(M3d a, M3d b) {
        if (this.edgeMap.containsKey(a) && this.edgeMap.get(a).containsKey(b)) {
            return this.edgeMap.get(a).get(b);
        }
        return null;
    }

    public void setEdge(M3d a, M3d b, OctTreeEdge edge) {
        if (this.edgeMap.containsKey(a) && this.edgeMap.get(a).containsKey(b)) {
            throw new RuntimeException("edgeMap already contains a-->b");
        }
        if (this.edgeMap.containsKey(b) && this.edgeMap.get(b).containsKey(a)) {
            throw new RuntimeException("edgeMap already contains b-->a");
        }
        if (!this.edgeMap.containsKey(a)) {
            this.edgeMap.put(a, new HashMap());
        }
        if (!this.edgeMap.containsKey(b)) {
            this.edgeMap.put(b, new HashMap());
        }
        this.edgeMap.get(a).put(b, edge);
        this.edgeMap.get(b).put(a, edge);
    }

    public OctTreeEdge requireEdge(M3d a, M3d b, M3d precomputedMidPt) {
        OctTreeEdge edge = this.getEdge(a, b);
        if (edge == null) {
            edge = new OctTreeEdge(null, a, b, precomputedMidPt);
            this.setEdge(a, b, edge);
            this.addInterpolants(edge);
        }
        return edge;
    }

    public M3d subdivideEdge(M3d a, M3d b, M3d precomputedMidPt) {
        OctTreeEdge edge = this.requireEdge(a, b, precomputedMidPt);
        int i = 0;
        while (i < 2) {
            if (edge.getChild(i) == null) {
                edge.setChild(i, this.requireEdge(edge.getEndPt(i), edge.getMidPt(), null));
            }
            ++i;
        }
        return edge.getMidPt();
    }

    public M3d subdivideFace(M3d a, M3d b, M3d alpha, M3d beta) {
        return this.subdivideEdge(alpha, beta, this.subdivideEdge(a, b, null));
    }

    public M3d subdivideCube(M3d a, M3d b, M3d alpha, M3d beta, M3d alef, M3d bet) {
        return this.subdivideEdge(alef, bet, this.subdivideEdge(alpha, beta, this.subdivideEdge(a, b, null)));
    }

    public void refine() {
        int n = 0;
        while (!this.inProgress.isEmpty() && this.inProgress.peek().getLevel() < this.targetLevel) {
            Octree T = this.inProgress.pop();
            T.refine();
            Octree[][][] children = T.getChildOctrees();
            if (children != null) {
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 2) {
                        int k = 0;
                        while (k < 2) {
                            Octree t = children[i][j][k];
                            if (t != null) {
                                if (t.getLevel() < this.targetLevel) {
                                    this.inProgress.addLast(t);
                                } else if (!t.isEmpty()) {
                                    this.finished.add(t);
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            ++n;
        }
        if (this.slowCheckForHoles) {
            for (Octree o : this.finished) {
                int i = 0;
                while (i < 6) {
                    if (o.hasInterestingFace(i) && o.getNeighbor(i) == null) {
                        M3d pt = o.getPointJustBeyondFace(i);
                        Octree op = this.findUniqueContainer(pt);
                        if (op.getLevel() < this.targetLevel) {
                            op.addTarget(pt);
                            this.inProgress.addLast(op);
                        } else {
                            o.setNeighbor(i, op);
                            op.setNeighbor(5 - i, o);
                        }
                    }
                    ++i;
                }
            }
            if (!this.inProgress.isEmpty()) {
                this.refine();
            }
        }
    }
}

