/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

import delaunay.ArraySet;
import delaunay.Pnt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

class Triangle
extends ArraySet<Pnt> {
    private int idNumber = idGenerator++;
    private Pnt circumcenter = null;
    private static int idGenerator = 0;
    public static boolean moreInfo = false;

    public Triangle(Pnt ... vertices) {
        this((Collection<? extends Pnt>)Arrays.asList(vertices));
    }

    public Triangle(Collection<? extends Pnt> collection) {
        super(collection);
        if (this.size() != 3) {
            throw new IllegalArgumentException("Triangle must have 3 vertices");
        }
    }

    @Override
    public String toString() {
        if (!moreInfo) {
            return "Triangle" + this.idNumber;
        }
        return "Triangle" + this.idNumber + super.toString();
    }

    public Pnt getVertexButNot(Pnt ... badVertices) {
        Collection bad = Arrays.asList(badVertices);
        for (Pnt v : this) {
            if (bad.contains(v)) continue;
            return v;
        }
        throw new NoSuchElementException("No vertex found");
    }

    public boolean isNeighbor(Triangle triangle) {
        int count = 0;
        for (Pnt vertex : this) {
            if (triangle.contains(vertex)) continue;
            ++count;
        }
        return count == 1;
    }

    public ArraySet<Pnt> facetOpposite(Pnt vertex) {
        ArraySet<Pnt> facet = new ArraySet<Pnt>(this);
        if (!facet.remove(vertex)) {
            throw new IllegalArgumentException("Vertex not in triangle");
        }
        return facet;
    }

    public Pnt getCircumcenter() {
        if (this.circumcenter == null) {
            this.circumcenter = Pnt.circumcenter(this.toArray(new Pnt[0]));
        }
        return this.circumcenter;
    }

    @Override
    public boolean add(Pnt vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Pnt> iterator() {
        return new Iterator<Pnt>(){
            private Iterator<Pnt> it;
            {
                this.it = Triangle.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Pnt next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int hashCode() {
        return this.idNumber ^ this.idNumber >>> 32;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }
}

