/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

import delaunay.DelaunayAp;
import delaunay.Pnt;
import delaunay.Triangle;
import delaunay.Triangulation;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.JPanel;

class DelaunayPanel
extends JPanel {
    public static Color voronoiColor = Color.magenta;
    public static Color delaunayColor = Color.green;
    public static int pointRadius = 3;
    private DelaunayAp controller;
    private Triangulation dt;
    private Map<Object, Color> colorTable;
    private Triangle initialTriangle;
    private static int initialSize = 10000;
    private Graphics g;
    private Random random = new Random();

    public DelaunayPanel(DelaunayAp controller) {
        this.controller = controller;
        this.initialTriangle = new Triangle(new Pnt(-initialSize, -initialSize), new Pnt(initialSize, -initialSize), new Pnt(0.0, initialSize));
        this.dt = new Triangulation(this.initialTriangle);
        this.colorTable = new HashMap<Object, Color>();
    }

    public void addSite(Pnt point) {
        this.dt.delaunayPlace(point);
    }

    public void clear() {
        this.dt = new Triangulation(this.initialTriangle);
    }

    private Color getColor(Object item) {
        if (this.colorTable.containsKey(item)) {
            return this.colorTable.get(item);
        }
        Color color = new Color(Color.HSBtoRGB(this.random.nextFloat(), 1.0f, 1.0f));
        this.colorTable.put(item, color);
        return color;
    }

    public void draw(Pnt point) {
        int r = pointRadius;
        int x = (int)point.coord(0);
        int y = (int)point.coord(1);
        this.g.fillOval(x - r, y - r, r + r, r + r);
    }

    public void draw(Pnt center, double radius, Color fillColor) {
        int x = (int)center.coord(0);
        int y = (int)center.coord(1);
        int r = (int)radius;
        if (fillColor != null) {
            Color temp = this.g.getColor();
            this.g.setColor(fillColor);
            this.g.fillOval(x - r, y - r, r + r, r + r);
            this.g.setColor(temp);
        }
        this.g.drawOval(x - r, y - r, r + r, r + r);
    }

    public void draw(Pnt[] polygon, Color fillColor) {
        int[] x = new int[polygon.length];
        int[] y = new int[polygon.length];
        int i = 0;
        while (i < polygon.length) {
            x[i] = (int)polygon[i].coord(0);
            y[i] = (int)polygon[i].coord(1);
            ++i;
        }
        if (fillColor != null) {
            Color temp = this.g.getColor();
            this.g.setColor(fillColor);
            this.g.fillPolygon(x, y, polygon.length);
            this.g.setColor(temp);
        }
        this.g.drawPolygon(x, y, polygon.length);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.g = g;
        Color temp = g.getColor();
        if (!this.controller.isVoronoi()) {
            g.setColor(delaunayColor);
        } else if (this.dt.contains(this.initialTriangle)) {
            g.setColor(this.getBackground());
        } else {
            g.setColor(voronoiColor);
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(temp);
        if (!this.controller.isColorful()) {
            this.colorTable.clear();
        }
        if (this.controller.isVoronoi()) {
            this.drawAllVoronoi(this.controller.isColorful(), true);
        } else {
            this.drawAllDelaunay(this.controller.isColorful());
        }
        temp = g.getColor();
        g.setColor(Color.white);
        if (this.controller.showingCircles()) {
            this.drawAllCircles();
        }
        if (this.controller.showingDelaunay()) {
            this.drawAllDelaunay(false);
        }
        if (this.controller.showingVoronoi()) {
            this.drawAllVoronoi(false, false);
        }
        g.setColor(temp);
    }

    public void drawAllDelaunay(boolean withFill) {
        for (Triangle triangle : this.dt) {
            Pnt[] vertices = triangle.toArray(new Pnt[0]);
            this.draw(vertices, withFill ? this.getColor(triangle) : null);
        }
    }

    public void drawAllVoronoi(boolean withFill, boolean withSites) {
        HashSet<Pnt> done = new HashSet<Pnt>(this.initialTriangle);
        for (Triangle triangle : this.dt) {
            for (Pnt site : triangle) {
                if (done.contains(site)) continue;
                done.add(site);
                List<Triangle> list = this.dt.surroundingTriangles(site, triangle);
                Pnt[] vertices = new Pnt[list.size()];
                int i = 0;
                for (Triangle tri : list) {
                    vertices[i++] = tri.getCircumcenter();
                }
                this.draw(vertices, withFill ? this.getColor(site) : null);
                if (!withSites) continue;
                this.draw(site);
            }
        }
    }

    public void drawAllCircles() {
        for (Triangle triangle : this.dt) {
            if (triangle.containsAny(this.initialTriangle)) continue;
            Pnt c = triangle.getCircumcenter();
            double radius = c.subtract((Pnt)triangle.get(0)).magnitude();
            this.draw(c, radius, null);
        }
    }
}

