/*
 *	tinetd.c
 *	--------
 *
 * $Id$
 *
 * Copyright (c) 1995, University of Cambridge Computer Laboratory,
 * Copyright (c) 1995, Richard Black, All Rights Reserved.
 *
 *
 */

/* This is a program for testing inetd type services. It waits for a
 * single connection on a given port, and then execs the given command
 * with the accepted socket on zero.
 */

#include <sys/types.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <errno.h>
#include <unistd.h>
#include <ctype.h>
#include <netdb.h>
#include <string.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

static char *prog_name;

static void usage(void)
{
    fprintf(stderr, "usage: %s <port> <command>\n",
	    prog_name);
    fprintf(stderr, "This program (%s) pretends to be an inet daemon\n\n",
	    prog_name);
    exit(1);
}

static void fault(char *format, ...)
{
    va_list		ap;

    va_start(ap, format);
    fprintf(stderr, "%s: ", prog_name);
    vfprintf(stderr, format, ap);
    fflush(stderr);
    va_end(ap);
    exit(1);
}

static int getservice(char *name, unsigned short *port)
{
    struct servent		*se;

    if (!name) return -1;

    if (isdigit(name[0]))
	*port = atoi(name);
    else
    {
	if (!(se = getservbyname(name, "tcp")))
	    return -1;
	*port = ntohs(se->s_port);
    }
    return 0;
}

/*
 * open a tcp socket and start listening for connections on it
 */
static int startlistening(unsigned short port)
{
    int			fd;
    struct sockaddr_in	sin;

    if ((fd = socket (AF_INET, SOCK_STREAM, 0)) < 0)
	fault("socket");
    
    memset(&sin, 0, sizeof(sin));
    sin.sin_family      = AF_INET;
    sin.sin_port        = htons (port);
    sin.sin_addr.s_addr = INADDR_ANY;
    if (bind(fd, &sin, sizeof(sin)) < 0)
	fault("bind: %u: %s\n", port, strerror(errno));
    
    if (listen(fd, 1) < 0)
	fault("listen: %s\n", strerror(errno));
    
    return fd;
}


/*
 * ------------------------------------------------------------
 */
void main(int argc, char **argv)
{
    struct sockaddr_in		from;
    unsigned short		port;
    int				fromlen;
    int				lis, acc;
    
    prog_name = argv[0];

    if (argc < 3)
	usage();
    
    if (getservice(argv[1], &port) < 0)
	fault("bad service: %s: %s\n", argv[1], strerror(errno));
    
    lis = startlistening(port);
    
    fromlen = sizeof(from);
    if ((acc = accept(lis, &from, &fromlen)) < 0)
	fault("accept: %s\n", strerror(errno));
    
    if ((fromlen != sizeof(from)) || (from.sin_family != AF_INET))
	fault("not an inet socket (family=%d)\n", from.sin_family);
    
    printf("peer is %s:%u\n", inet_ntoa(from.sin_addr), ntohs(from.sin_port));
    
    /* O.K. Lets do it */

    if (dup2(acc, 0) < 0)
	fault("fdup: %s\n", strerror(errno));
    if (dup2(acc, 1) < 0)
	fault("fdup: %s\n", strerror(errno));
    
    execvp(argv[2], &argv[2]);
    
    fault("execvp: %s: %s\n", argv[2], strerror(errno));
}

/* End of $Id$ */
