/*  -*- Mode: C;  -*-
 * File: getroute.c
 * Author: James Hall (jch1003@cl.cam.ac.uk)
 * Copyright (C) University of Cambridge Computer Laboratory, 1998
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ** PACKAGE:
 **
 ** FUNCTION:
 **
 ** HISTORY:
 ** Created: Tue Aug 11 16:48:14 1998 (jch1003)
 ** Last Edited: Tue Oct 27 17:05:43 1998 By James Hall
 **
    $Log: getroute.c,v $
    Revision 1.15  2001/10/24 13:59:30  iap10
    *** empty log message ***

    Revision 1.14  1999/01/06 17:07:13  iap10
    *** empty log message ***

    Revision 1.13  1998/11/11 13:50:28  iap10
    *** empty log message ***

    Revision 1.12  1998/11/11 12:52:52  jch1003
    *** empty log message ***

    Revision 1.11  1998/10/27 10:54:27  iap10
    *** empty log message ***

    Revision 1.10  1998/10/21 21:09:41  iap10
    part of ICMP support

    Revision 1.9  1998/10/20 22:30:40  iap10
    *** empty log message ***

    Revision 1.7  1998/10/12 10:30:42  iap10
    *** empty log message ***

    Revision 1.6  1998/10/09 14:38:21  iap10
    *** empty log message ***

    Revision 1.5  1998/10/09 12:11:27  jch1003
    *** empty log message ***

    Revision 1.4  1998/09/01 15:38:42  iap10
    *** empty log message ***

    Revision 1.3  1998/08/14 11:46:32  jch1003
    *** empty log message ***

 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */


#ifdef linux
#include "linux-tweaks.h"
#endif

#ifdef __osf__
#include <kern/macro_help.h>
#define MAX_IPOPTLEN     40
#endif

#include <pthread.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#include <sys/socket.h>
#include <sys/time.h>

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <errno.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <memory.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "list.h"
#include "jroute.h"
#include "jroute_threads.h"

struct timeval start;
int giveup  = 0;  /* use the reachability test by default */
int maxrate = 0;  /* if non-zero max rate at which to generate traffic Kb/s */

rcontext_t con_def = {TTL_MIN_DEF, TTL_MAX_DEF, {0U, 0U}};


#define TRCX(x) 

/*
 * Bottom  PORT_GET_SHIFTS bits of port give our seq no - hence allowing 
 * probes*ttl < (2**PORT_GET_SHIFTS - #ports already in use)
 * Top bit keeps us out of the "likely" range, bits  
 * PORT_GET_SHIFTS - 14 give port no. space for each of up to 64 threads.
 * If earlier choices are unavailable try one higher up until sequence space 
 * is exhausted.
 */
void 
port_and_bind(int me, int *seqp, struct sockaddr_in *from, int tsock)
{
  int i;
  int seq = (*seqp) + 1;
  u_short port = (me<<PORT_GET_SHIFTS) | 0x8000;

  for (; seq < MAX_SEQ; seq++)
    {
      port+= seq;
      from->sin_port = htons(port);
      if (bind(tsock, (struct sockaddr *)from, sizeof(*from)) == 0)
	{
	  *seqp = seq;
	  return;
	}
      else if (errno == EADDRINUSE)
	{
	  TRC(fprintf(stderr, "#%d: port %hu in use\n", me, port);)
	  continue;
	}
      else
	{
	  thread_error(me, "probe port bind", "");
	}
    }
  fprintf(stderr, "%s: #%d sequence space exhausted\n",
	  prog, me);
  pthread_exit ((pthread_addr_t)1);
}

void 
set_lsrr(int me, int s, src_route_t * route, struct sockaddr_in *to)
{
  struct protoent *pe;
  uint32 dummy[MAX_IPOPTLEN/sizeof(uint32)];
  u_char *optlist = (char *)&dummy;
  char *cp = "ip";

  if ((pe = getprotobyname(cp)) == NULL) 
    thread_error(me, "set_lsrr", "getprotobyname");

  {int i;
fprintf(stderr,"Route num=%d\n",route->num);
for(i=0;i<route->num;i++) fprintf(stderr,"%x:",route->rt[i]);
fprintf(stderr,"\n");
  }

  /* force 4 byte alignment */
  optlist[0] = IPOPT_NOP;
  /* loose source route option */
  optlist[1] = IPOPT_LSRR;
  optlist[2] = 4 + (4*route->num) + 3 ;
  /* Pointer to LSRR addresses */
  optlist[3] = IPOPT_MINOFF;
  memcpy(optlist + 4, route->rt, sizeof(uint32) * route->num);
  memcpy(optlist + 4 + (4*route->num), &to->sin_addr.s_addr, sizeof(uint32));
      
  if ((setsockopt(s, pe->p_proto, IP_OPTIONS, optlist,
		  8 + (route->num*sizeof(uint32))  )) < 0)
    thread_error(me, "set_lsrr", "setsockopt");

  {int i;
for(i=0;i<8 + (route->num*sizeof(uint32));i++) fprintf(stderr,"%02x:",optlist[i]);
fprintf(stderr,"\n");
  }
        
return;
}

#if 0
/*
 * in_cksum --
 *	Checksum routine for Internet Protocol family headers (C Version)
 */
static int
in_cksum(u_short *addr, int len)
{
    register int nleft = len;
    register u_short *w = addr;
    register int sum = 0;
    u_short answer = 0;
    
    /*
     * Our algorithm is simple, using a 32 bit accumulator (sum), we add
     * sequential 16 bit words to it, and at the end, fold back all the
     * carry bits from the top 16 bits into the lower 16 bits.
     */
    while (nleft > 1)  {
	sum += *w++;
	nleft -= 2;
    }
    
    /* mop up an odd byte, if necessary */
    if (nleft == 1) {
	*(u_char *)(&answer) = *(u_char *)w ;
	sum += answer;
    }
    
    /* add back carry outs from top 16 bits to low 16 bits */
    sum = (sum >> 16) + (sum & 0xffff);	/* add hi 16 to low 16 */
    sum += (sum >> 16);			/* add carry */
    answer = ~sum;				/* truncate to 16 bits */
    return(answer);
}

int icmp_probe(int me, int *seqp, int ttl, struct sockaddr_in *to,
	       struct sockaddr_in *from, src_route_t *route)
{
    struct icmp *icp;
    int cc;
    int i;
    int seq = (*seqp) + 1; 
    int datalen = 0;
    u_char outpack[256];

    int foo =33; int s;  struct protoent *pe;

    icp = (struct icmp *) &outpack;
    icp->icmp_type = ICMP_ECHO;
    icp->icmp_code = 0;
    icp->icmp_cksum = 0;
    icp->icmp_seq = ( (me<<PORT_GET_SHIFTS) | 0x8000 ) + seq;
    icp->icmp_id = main_pid;	
    
    
    cc = datalen + 8;			/* skips ICMP portion */
    
    /* compute ICMP checksum here */
    icp->icmp_cksum = in_cksum((u_short *)icp, cc);
    




    /* get icmp socket */
    if ((pe = getprotobyname("icmp")) == NULL)
	error("icmp protocol unknown!");

    if ((s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
	error("probe socket");

/* XXXX Will Need locking XXXXXXXXXX */
    if (bind(s, (struct sockaddr *)from, sizeof(*from)) < 0)
	thread_error(me, "bind", "");

    if (connect(s, to, sizeof(struct sockaddr)) < 0) 
	thread_error(me, "connect", "");

    /* set ttl on socket */
    if (setsockopt(s, IPPROTO_IP, IP_TTL,
		   (char *) &foo, sizeof(int) ) < 0)
	thread_error(me, "probe ttl opt", "");

    /* loose source route if appropriate */
    if (route->num)
	set_lsrr(me, s, route, to);

    i = sendto(s, (char *)outpack, cc, 0, to, sizeof(struct sockaddr) );

/* XXXX Need locking XXXXXXXXXX */

    if (i < 0 || i != cc)  {
	if (i < 0)
	    perror("ping: sendto");
    }

}



int icmp_probeXX(int me, int *seqp, int ttl, struct sockaddr_in *to,
	       struct sockaddr_in *from, src_route_t *route)
{
    struct icmp *icp;
    int i;
    int optsize, hdr_tot;
    int icmp_dsize, icmp_tot, total;
    int seq = (*seqp) + 1; 
    int datalen = 0;
    u_char outpack[256];
    u_char *op;
    struct ip * ip;
//    int foo =33; int s;  struct protoent *pe;
    int s;

/*
15:23:13.847145 argos.cl.cam.ac.uk > valiant.cl.cam.ac.uk: icmp: echo request (ttl 255, id 42530)
                         4500 0054 a622 0000 ff01 0ecb 80e8 0125
                         80e8 03c6 0800 c1d9 801f 0000 51ee 2d36
                         3fdf 0c00 0809 0a0b 0c0d 0e0f 1011 1213
                         1415 1617 1819
 */
    /* ALL in words */
    optsize    = (route->num)?(2+route->num) : 0;                         
    hdr_tot    = 5 + optsize;  

    icmp_dsize = 1;
    icmp_tot   = icmp_dsize + 2;             /* incl deadbeef */

    total      = hdr_tot + icmp_tot;

    ip = (struct ip *) &outpack;

    ip->ip_hl  = hdr_tot;              /* header length */
    ip->ip_v   = 4;             /* version */
    ip->ip_tos = 0;             /* type of service */
    ip->ip_len = (total)*4 ;             /* total length */
    ip->ip_id  = 0;                                /* identification */
    ip->ip_off = 0;             /* fragment offset field */
    ip->ip_ttl = ttl;             /* time to live */
    ip->ip_p   = IPPROTO_ICMP;               /* protocol */
    ip->ip_sum = 0;             /* checksum */
    ip->ip_src = from->sin_addr;             /* source address */
    ip->ip_dst = to->sin_addr;             /* dest address */


    if (route->num)
    {
	op = (u_char*)(ip+1) ;
	/* force 4 byte alignment */
	op[0] = IPOPT_NOP;
	/* loose source route option */
	op[1] = IPOPT_LSRR;
	op[2] = 4 + (4*route->num) + 3;
	/* Pointer to LSRR addresses */
	op[3] = IPOPT_MINOFF;
	memcpy(op + 4, route->rt, sizeof(uint32) * route->num);
	memcpy(op + 4 + (4*route->num), &to->sin_addr.s_addr, sizeof(uint32));
    }

//    ip->ip_sum = in_cksum((u_short *)ip, ip_tot*4);

    icp = (struct icmp *) &outpack[hdr_tot * 4];
    icp->icmp_type = ICMP_ECHO;
    icp->icmp_code = 0;
    icp->icmp_cksum = 0;
    icp->icmp_seq = ( (me<<PORT_GET_SHIFTS) | 0x8000 ) + seq;
    icp->icmp_id = main_pid;	
    
    *( ((int *)icp) + 2)   = 0xdeadbeef;
    
    /* compute ICMP checksum here */
    icp->icmp_cksum = in_cksum((u_short *)icp, icmp_tot*4);

/* XXXX Will Need locking XXXXXXXXXX */

    if ((s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
	error("probe socket");



    if (setsockopt(s, IPPROTO_IP, IP_HDRINCL,
		   (char *)outpack, 20 ) < 0)
	thread_error(me, "IP_HDRINCL", "");


    /* loose source route if appropriate */
//    if (route->num)
//	set_lsrr(me, s, route, to);

    if( route->num )
	if ((setsockopt(s, IPPROTO_IP, IP_OPTIONS, op,
			8 + (route->num*sizeof(uint32))  )) < 0)
	    thread_error(me, "set_lsrr", "setsockopt");

ip->ip_hl  = 8;
   ip->ip_ttl = 0x12;

printf("Datagram size is 0x%x, header 0x%x\n", total*4, hdr_tot*4);

    i = sendto(s, (char *)ip, total*4, 
	       0, to, sizeof(struct sockaddr) );

/* XXXX Need locking XXXXXXXXXX */

    if (i < 0 || i != total*4)  {
	if (i < 0)
	    perror("ping: sendto");
    }

}

#endif
int
tcp_probe(int me, int *seqp, int ttl, struct sockaddr_in *to, 
	  struct sockaddr_in *from, src_route_t *route)
{
  int on = 1;
  int tsock;
  int sockerr, optlen;

  /* get socket */
  if ((tsock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    thread_error(me, "probe socket", "");
#if 0
fprintf(stderr, "#%d sock %d\n", me, tsock);
#endif  
  /* find port no. incorporating seq no. and bind to it */
  port_and_bind(me, seqp, from, tsock);

  /* set ttl on socket */
  if (setsockopt(tsock, IPPROTO_IP, IP_TTL,
		 (char *)&ttl, sizeof(int)) < 0)
    thread_error(me, "probe ttl opt", "");

  /* make socket non_blocking */
  if (ioctl(tsock, FIONBIO, (char*)&on) < 0)
    thread_error(me, "probe FIONBIO IOCTL", "");

  /* loose source route if appropriate */
  if (route->num)
    set_lsrr(me, tsock, route, to);

  /* and finally send probe by initiating a connect */
  if (connect(tsock, (struct sockaddr *)to, sizeof(*to)) < 0) 
    {
      if (errno != EINPROGRESS)
	thread_error(me, "probe connect", "");
    }
  return tsock;
}

void 
set_unreach_status(int code, probe_res_t *resp)
{
  
  switch (code) 
    {
    case ICMP_UNREACH_PORT:
      resp->status |= PORT_UNREACH;
      resp->status |= GOT_THERE;    /* major status */
      break;
    case ICMP_UNREACH_NET:
      resp->status |= NET_UNREACH;
      resp->status |= UNREACHABLE;  /* major status */
      break;
    case ICMP_UNREACH_HOST:
      resp->status |= HOST_UNREACH;
      resp->status |= UNREACHABLE;  /* major status */
      break;
    case ICMP_UNREACH_PROTOCOL:
      resp->status |= PROT_UNREACH;
      resp->status |= GOT_THERE;    /* major status */
      break;
    case ICMP_UNREACH_NEEDFRAG:
      resp->status |= NEEDFRAG_UNREACH;
      resp->status |= UNREACHABLE;    /* major status */
      break;
    case ICMP_UNREACH_SRCFAIL:
      resp->status |= SRCFAIL_UNREACH;
      resp->status |= UNREACHABLE;    /* major status */
      break;
      
      /* rfc1716 */
#ifndef ICMP_UNREACH_FILTER_PROHIB
#define ICMP_UNREACH_FILTER_PROHIB	13	/* admin prohibited filter */
#endif
    case ICMP_UNREACH_FILTER_PROHIB:
      resp->status |= PROHIB_UNREACH;
      resp->status |= UNREACHABLE;  /* major status */       
      break;  
    default:
      resp->status |= OTHER_UNREACH;
      break;
    }
  return;
}

probe_res_t *
poll_probes(ttl_res_t *ttr)
{
  int i;
  int j;
  int agreements = 0;

  for (i = 0; i < ttr->nprobes; i++)
    {
      probe_res_t *r = &ttr->probe[i];
      for (j = 0; j < ttr->nprobes; j++)
	{
	  if (r->status == ttr->probe[j].status 
	      && r->addr.addrint == ttr->probe[j].addr.addrint)
	    if (++agreements == NPROBES_AGREE)
	      {
		r->status |= AGREEMENT;
		return r;
	      }
	}
    }

  return NULL;
}

/*
 * Is given socket tcp connected? - return PROBE_TCP_CONNECTED if so, 
 * otherwise PROBE_TIMED_OUT
 */

int 
tcp_connected(int me, int s)
{
  fd_set fds;
  struct timeval tv = {0, 0};

  FD_ZERO(&fds);
  FD_SET(s, &fds);

  if (select(s+1, NULL, &fds, NULL, &tv) < 0)
    thread_error(me, "select", "tcp_connected");

  return FD_ISSET(s, &fds) ? PROBE_TCP_CONNECTED : PROBE_TIMED_OUT;
}


void 
getroute(int me, addr_train_t *train, 
	 threadata_t *tdata)
{
  int probe;
  int ttl, send_ttl, max_ttl = train->con.ttl_max;
  int ttl_last_success = 0;
  int reachability = 0, known_reachable = 0;
  int double_test = 0, done_double_test = 0;
  int seq = 0;
  int sndsock;			/* tcp probe socket */
  struct sockaddr_in whereto;
  int printed = 0;
  int *sentp = &train->sent;
#if 0
fprintf(stderr, "#%d get\n", me);
return;
#endif
  tdata->whereto.sin_addr = train->dest.addrin;
  tdata->whereto.sin_port = htons(train->port);
  tdata->whereto.sin_family = AF_INET;
  train->status = 0U;
  train->sent = 0;
  train->srsent = 0;
  train->srcd = 0;
  train->iphlen = sizeof(struct ip);
  if (train->con.route.num)
    {
      train->iphlen += 4*(train->con.route.num+2);
      sentp = &train->srsent;
      train->route_oif.num = 0;
    }
  if (verbose)
    fprintf(stderr, "#%d probing %s:%hu\n", 
	    me, inet_ntoa(train->dest.addrin), train->port);
  

  for (ttl = train->con.ttl_min; ttl <= max_ttl; ++ttl) 
    {
      
      struct sockaddr_in repfrom;/* Source of ICMP reply */
      addr_un_t lastaddr;
      struct ip *ip;
      int code;
      int i;
      ttl_res_t ttl_res;
      probe_res_t *tres;
      timespec_t abs, delta; 

      delta.tv_sec = 0;
      delta.tv_nsec = 0L;
      
      lastaddr.addrint = 0U;
      ttl_res.nprobes = 0;
      train->nhops = ttl;
      
      send_ttl = ttl;
      if (reachability) send_ttl = TTL_REACHABLE;
      if (double_test)  send_ttl = double_test;

      if (verbose > 0)
	fprintf(stderr, "#%2d: %2d ", me, send_ttl);
      if (simple_output && !reachability)
	fprintf(stderr, "%2d ", send_ttl);
      for (probe = 0; probe < NPROBES_MAX; ++probe) 
	{
	  probe_res_t *pres = &ttl_res.probe[probe];
	  pres->status = 0U;
	  delta.tv_sec = (delta.tv_sec == 0 ? 	
			  TIMEOUT_BASE_SEC_DEF : delta.tv_sec * 2); 

	  ttl_res.nprobes++;

	  /* inform ithread */
	  mlock(&icmpm, "getroute icmpm inform");
	  responses_outstanding++;
	  if (ithread_waiting)
	    condsig(&icmpc, "getroute icmpc");
	  munlock(&icmpm, "getroute icmpm");
	  
	  mlock(&tdata->dm, "getroute dm");
	  tdata->valid = PROBE_INVALID;
	  /* send probe */
	  
	  switch (probe_type)
	  {
	  case PROBE_TCP:
	      sndsock = tcp_probe(me, &seq, send_ttl, &tdata->whereto, 
				  &tdata->wherefrom, &train->con.route);
	      break;
#if 0
	  case PROBE_ICMP:
	      sndsock = icmp_probe(me, &seq, send_ttl, &tdata->whereto, 
				  &tdata->wherefrom, &train->con.route);
	      break;
#endif
	  }	    

	  (*sentp)++;
	  TRC(fprintf(stderr, "%d->\n", me);)
	  /* wait on response (or timeout) */
	  get_exptm(&delta, &abs, "getroute");
	  cond_timedwait(&tdata->dc, &tdata->dm, &abs, "getroute");

	  if (!tdata->valid)	/* timed out or got tcp ACK/SYN */
	    {
	      tdata->valid = tcp_connected(me, sndsock);
	      munlock(&tdata->dm, "getroute dm");
	      mlock(&icmpm, "getroute icmpm timed out");
	      responses_outstanding--;
	      munlock(&icmpm, "getroute icmpm timed out");
	    }
	  else
	    {
//fprintf(stderr,"XX%dXXXX ",tdata->valid);

              train->tcplen = tdata->tcplen;
	      if (tdata->valid < (PROBE_TEST_RELAXED + UNREACH_CODE_MAX))
		{

		  pres->status |= RELAXED;
		  tdata->valid -= PROBE_TEST_RELAXED;
		}
	      munlock(&tdata->dm, "getroute dm");
	      if (tdata->icmp_from.addrint == 0U)
		pres->status |= BOGUS_ADDR;
	    }
	  
	  pres->addr = tdata->icmp_from;
	  pres->ret_ttl = tdata->ret_ttl;
	  
	  switch (tdata->valid)
	    {
	    case PROBE_TCP_CONNECTED:
	      if (reachability)
		{
		  known_reachable++;
		  if (verbose || simple_output)
		    fprintf(stderr, "#%d reachability ok\n", me);
		}
	      else
		{
		  pres->status |= GOT_THERE;
		}
	      pres->addr.addrin = tdata->whereto.sin_addr;
	      train->srcd++;
	      break;
	    case PROBE_TTL_EXCEEDED:
	      ttl_last_success = ttl;
	      pres->status |= TTL_EXCEEDED;
	      break;
	    case PROBE_TIMED_OUT:
	      pres->status |= TIMED_OUT;
	      pres->addr.addrint = 0U;
	      if (verbose > 0)
		fprintf(stderr, " #%2d *", me);
	      if (simple_output)
		fprintf(stderr, " *");
#if 0
	      reachability++;
	      bias = 1+(TTL_REACHABLE - ttl);
#endif
	      break;
	    default:
	      set_unreach_status(tdata->valid - 1, pres);
	      break;
	    }

	  if (verbose > 0 || simple_output)
	    {
	      if (pres->addr.addrint != lastaddr.addrint) 
		{
		  int i;
		  if (verbose)
		    {
		      fprintf(stderr, " #%2d %-15s", 
			    me, intoa(pres->addr.addrint));

		      if (tdata->valid != PROBE_TCP_CONNECTED)
			fprintf(stderr, " (%d) ", pres->ret_ttl);
		    }
		  else if (!reachability)
		    {
		      fprintf(stderr, " %-15s (%s)\n", 
			    get_hname((char *)&pres->addr.addrint), 
			     intoa(pres->addr.addrint));
		    }
  
		  lastaddr.addrin = pres->addr.addrin;

		  for (i=0; i< tdata->icmp_src_route.num; i++)
		  {
		      fprintf(stderr, "%c", 
			      (i == tdata->icmp_src_route.ptr)? '*':'+' );

		      fprintf(stderr, "%s", 
			      intoa(tdata->icmp_src_route.rt[i].addrint));
		  }
		  fprintf(stderr, " ");
		}
	    }

	  /* shut down other end */
	  if (close(sndsock) != 0)
	    thread_error(me, "got there close", "");
	  
	  if (NPROBES_MAX > NPROBES_AGREE)
	    {
	      if (ttl_res.nprobes >=  NPROBES_AGREE 
		  && (tres = poll_probes(&ttl_res)))
		break;
	    }
	  else
	    {
	      tres = pres;
	      if (!(tres->status & TIMED_OUT))
		break;
	    }
	} /* end probes */ 

      if (tres)			/* got an agreement for this ttl */
	{
	  if (verbose > 1)
	    print_probe_status(stderr, me, tres, ttl_res.nprobes);
	  else if (verbose)
	    fprintf(stderr, "\n");
	  train->hops[ttl-1] = tres->addr;
	  train->status |= tres->status;
	}
      else
	{
	  if (verbose)
	    fprintf(stderr, "\n");
	  train->status = NO_AGREEMENT;
	  break;
	}

      if (train->status & TIMED_OUT)
	{
	  train->status |= TIME_OUTS;
	  train->status &= ~TIMED_OUT;

	  if (giveup) /* none of the reachability/double stuff enabled */
	  {
	      if (ttl >= ttl_last_success + giveup)
	      {  /* time to giveup */
		  train->status |= GIVEUP; /* major status */
		  train->nhops = ttl;
	      }
	  }
	  else
	  {
	      if (reachability)
	      {
		  train->status |= UNREACHABLE; /* major status */
		  /* 1 for reachability probe + 1 for t.o. */
		  train->nhops = ttl - 2;
		  if (verbose || simple_output)
		      fprintf(stderr, "#%d reachability failed\n", me);
	      }
	      else if ( !known_reachable )
	      {  
		  reachability++;
		  if (verbose || simple_output)
		      fprintf(stderr, "# %d testing reachability\n", me);
	      }
	      else
	      {
		  
		  if( double_test )
		  {
		      double_test++; 
		  }
		  else
		      if( !done_double_test && ttl > ttl_last_success + 2 )
		      {
			  if (verbose)
			      fprintf(stderr, "# %d suspect double TTL problem\n", me);
			  double_test = (ttl_last_success * 2) -1;
			  train->status |= POSSIBLE_DOUBLE;
			  done_double_test = ttl;
		      }
	      }
	  }
	}
      else /* else got some sort of response */
	{
	  int i, dups;
	  uint32 this = train->hops[ttl-1].addrint;

	  
	  for(i=ttl-2;i>=0 && this;i--)
	      if( train->hops[i].addrint != this ) break;

	  dups  = ttl-2 - i;
	  if( this && dups )
	  {
	    if (verbose)
	      fprintf(stderr, "# %d Duplicated router!\n", me);
	    train->status |= DUP_HOPS_SUBST;	      
	    
	    if ( train->status & HOST_UNREACH )
	      {
		/* last hop got a host unreachable.
		   strip off any duplicate occurences of this host */
		fprintf(stderr, "# %d Strip off duplicates\n", me);
		
		train->nhops = i+2; /* leave on first occurrence */		  
		train->status |= DUP_HOPS_STRIP;
	      }
	    else
	      {
		if ( dups > 2 )
		  {
		    /* Hmm, routing loop with one router ? */
		    /* XXX should probably test reachability here... */
		    train->status |= ERROR; /*major status routing error */
		  }
	      }
	  }
	  
	  for(;i>=0 && this;i--)
	      if( train->hops[i].addrint == this ) break;

	  if( this && i>=0 )
	  {
	      /* we've got a loop! */
	      
	      fprintf(stderr, "# %d Loop!\n", me); 
	      /* not just a duplicate, a real loop */
	      train->status |= LOOP;
	      train->status |= ERROR; /*major status routing error */
	      
	  }

	  if (reachability)
	    {
	      reachability = 0;
	      if (train->status & TTL_EXCEEDED )
		{
		/* Almost certain routing loop doing reachability test.
		   Let's just let the TTL go up to find it in the normal way.. 
		*/
		ttl-=1;
		}
	      else
	        ttl-=2;
	    }

	  if (double_test)
	    {
		if( double_test < ((ttl_last_success+1)*2)-1 )
		  { /* response before expected (-1 due to dest host often not
		     decrementing TTL) [compund bugs ;-( ] */
		     fprintf(stderr, "# %d couldn't have been a double TTL prob (%d)\n", me, double_test);
		     double_test = 0;
		     ttl = done_double_test;
		     train->status &=~GOT_THERE;
		  }
		else		    
		  {
		    if (verbose)
		      fprintf(stderr, "# %d Double TTL problem likely! (%d)\n", me, double_test);
		    train->hops[((1+double_test)/2)-1] = tres->addr;
		    train->status |= INFERRED_DOUBLE;
		    /* 1 for reachability probe + 1 for t.o. */
		    train->nhops = (double_test+1)/2;
		  }
	      }
	}
      
      
      
      (void)fflush(stderr);  
      if (train->status & GOT_THERE || train->status & NO_AGREEMENT || 
	  train->status & UNREACHABLE || train->status & ERROR ||
	  train->status & GIVEUP )
	break;
    } /* end ttl's */

  if ( ttl > max_ttl ) train->status |= EXPIRED;

  train->route_oif = tdata->icmp_src_route;

  update_globals(me, train);
  if (verbose)
    fprintf(stderr, "#%d completed\n", me);
  
  if ( (train->status & DUP_HOPS_SUBST) && !(train->status & ERROR) ) 
    resolve_duplicates(train);

  if (verbose > 1 && sort)
    {
      fprintf(stderr, "\n");
      print_train(stderr, me, train, LOCK);
    }
  
  if (!sort)
    {
      print_train(ofile, me, train, LOCK);      
    }
 
  return;
}




void 
getsingle(int me, addr_train_t *train, 
	 threadata_t *tdata)
{
    int probe;
    int send_ttl = train->con.ttl_max;
    int seq = 0;
    int sndsock;			/* tcp probe socket */
    struct sockaddr_in whereto;
    int i;
    timespec_t abs, delta;       
    int *sentp = &train->sent;
    int relaxed = 0;    
#if 0
    fprintf(stderr, "#%d get\n", me);
    return;
#endif

    tdata->whereto.sin_addr = train->dest.addrin;
    tdata->whereto.sin_port = htons(train->port);
    tdata->whereto.sin_family = AF_INET;
    train->status = 0U;
    train->sent = 0;
    train->srsent = 0;
    train->srcd = 0;
    train->iphlen = sizeof(struct ip);
    train->nhops = send_ttl;
    
    if (train->con.route.num)
    {
	train->iphlen += 4*(train->con.route.num+2);
	sentp = &train->srsent;
	train->route_oif.num = 0;
    }
    
    if (verbose)
	fprintf(stderr, "#%d probing %s:%hu\n", 
		me, inet_ntoa(train->dest.addrin), train->port);
    
    
    delta.tv_sec = 0;
    delta.tv_nsec = 0L;


      


    if (verbose > 1)
	fprintf(stderr, "#%2d: %2d ", me, send_ttl);
    for (probe = 0; probe < NPROBES_MAX; ++probe) 
    {

	delta.tv_sec = (delta.tv_sec == 0 ? 	
			TIMEOUT_BASE_SEC_DEF : delta.tv_sec * 2); 
	
	
	/* inform ithread */
	mlock(&icmpm, "getroute icmpm inform");
	responses_outstanding++;
	if (ithread_waiting)
	    condsig(&icmpc, "getroute icmpc");
	munlock(&icmpm, "getroute icmpm");
	
	mlock(&tdata->dm, "getroute dm");
	
	tdata->valid = PROBE_INVALID;
	tdata->icmp_from.addrint = 0U; /* incase we don't get an ICMP */
	tdata->icmp_src_route.num = 0; /* incase we don't get an ICMP */
	/* send probe */
	
	switch (probe_type)
	{
	case PROBE_TCP:
	    sndsock = tcp_probe(me, &seq, send_ttl, &tdata->whereto, 
				&tdata->wherefrom, &train->con.route);
	    break;
#if 0
	case PROBE_ICMP:
	    sndsock = icmp_probe(me, &seq, send_ttl, &tdata->whereto, 
				 &tdata->wherefrom, &train->con.route);
	    break;
#endif
	}	    
	
	(*sentp)++;
	TRC(fprintf(stderr, "%d->\n", me);)
	    /* wait on response (or timeout) */
TRCX(fprintf(stderr, "WAIT %d\n",tdata->valid);)
	    get_exptm(&delta, &abs, "getroute");
	    cond_timedwait(&tdata->dc, &tdata->dm, &abs, "getroute");
TRCX(fprintf(stderr, "RETURN %d\n",tdata->valid);)    
	    if (tdata->valid == PROBE_INVALID)	/* timed out or got tcp ACK/SYN */
	    {
TRCX(fprintf(stderr,"L - no response or connect\n");)
		tdata->valid = tcp_connected(me, sndsock);
		
		if( tdata->valid == PROBE_TCP_CONNECTED )
		    train->srcd++;    /* packet stats */
		
		munlock(&tdata->dm, "getroute dm");
		mlock(&icmpm, "getroute icmpm timed out");
		responses_outstanding--;
		munlock(&icmpm, "getroute icmpm timed out");
	    }
	    else  /* got a ICMP (ttl_exp or unreach) */
	    {
TRCX(fprintf(stderr,"L - got an ICMP %d\n",tdata->valid);)
		train->tcplen = tdata->tcplen;
		if (tdata->valid < (PROBE_TEST_RELAXED + UNREACH_CODE_MAX))
		{
		    
		    relaxed = 1;
		    tdata->valid -= PROBE_TEST_RELAXED;
		}
		munlock(&tdata->dm, "getroute dm");
TRCX(fprintf(stderr,"M - got an ICMP %d\n",tdata->valid);)
	    }
	    
	    /* shut down other end */
	    if (close(sndsock) != 0)
		thread_error(me, "got there close", "");
	    
	    
	    if( tdata->valid != PROBE_TIMED_OUT )
		break; /* don't go round loop again if got response */
	    
#if 0
	    if (verbose > 1)
	    {
		if (pres->addr.addrint != lastaddr.addrint) 
		{
		    int i;
		    fprintf(stderr, " #%2d %-15s", 
			    me, inet_ntoa(pres->addr.addrin));
		    if (tdata->valid != PROBE_TCP_CONNECTED)
			fprintf(stderr, " (%d) ", pres->ret_ttl);  
		    lastaddr.addrin = pres->addr.addrin;
		    
		    for (i=0; i< tdata->icmp_src_route.num; i++)
		    {
			fprintf(stderr, "%c", 
				(i == tdata->icmp_src_route.ptr)? '*':'+' );
			
			fprintf(stderr, "%s", 
				inet_ntoa( *((struct in_addr *) 
					     (&tdata->icmp_src_route.rt[i]))) );
		    }
		    fprintf(stderr, " ");
		}
	    }
#endif
	    
    } /* end probes */ 
    
    if (LOCK) write_lock(me);

    fprintf(ofile,"%s (", inet_ntoa(tdata->icmp_from.addrin));
    
    for (i=0; i< tdata->icmp_src_route.num; i++)
    {
	fprintf(ofile, "%c", 
		(i == tdata->icmp_src_route.ptr)? '*':'+' );
	
	fprintf(ofile, "%s", 
		inet_ntoa( *((struct in_addr *) 
			     (&tdata->icmp_src_route.rt[i]))) );
    }
    fprintf(ofile, ") =%d $%s #", send_ttl, 
	    strlen(train->label) ? train->label : "");
    
    switch (tdata->valid)
    {
    case PROBE_TCP_CONNECTED:
	fprintf(ofile, "tcp_connect ");
	break;
    case PROBE_TTL_EXCEEDED:
	fprintf(ofile, "exp ");
	break;
    case PROBE_TIMED_OUT:
	fprintf(ofile, "*** ");      
	break;
    default: /* was a kind of Unreachable */
	fprintf(ofile, "unreachable %d ",tdata->valid);      
	break;
    }
    
    
    if (relaxed) fprintf(ofile, "relaxed ");
    
    fprintf(ofile, "\n");
    
    if (LOCK) write_unlock(me);;
    
    update_globals(me, train);      
    
#if 0 /* 0 */
    if (tres)			/* got an agreement for this ttl */
    {
	if (verbose > 1)
	    print_probe_status(stderr, me, tres, ttl_res.nprobes);
	train->hops[ttl-1] = tres->addr;
	train->status |= tres->status;
    }
    else
    {
	if (verbose > 1)
	    fprintf(stderr, "\n");
	train->status = NO_AGREEMENT;
	break;
    }
    
    if (train->status & TIMED_OUT)
    {
	train->status |= TIME_OUTS;
	train->status &= ~TIMED_OUT;
	
	train->status |= GIVEUP; /* major status */
	train->nhops = ttl;
    }
    
    
    train->route_oif = tdata->icmp_src_route;
    
    
    
    print_train(ofile, me, train, LOCK);    /* modify XXXX */
#endif   /* 0 */
    
    return;
}

