/*  -*- Mode: C;  -*-
 * File: context.c
 * Author: James Hall (jch1003@cl.cam.ac.uk)
 * Copyright (C) University of Cambridge Computer Laboratory, 1998
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ** PACKAGE: jroute
 **
 ** FUNCTION: route context
 **
 ** HISTORY:
 ** Created: Tue Oct 20 15:36:00 1998 (jch1003)
 ** Last Edited: Tue Oct 20 17:27:14 1998 By James Hall
 **
    $Log: context.c,v $
    Revision 1.1  1998/10/20 22:30:40  iap10
    Initial revision

 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <errno.h>  
#include <netinet/in.h>
#include <arpa/inet.h>

#include "list.h"
#include "jroute.h"

list_t clist[N_CONTEXTS];

void 
clist_init(list_t *l)
{
  int i;

  for (i = 0; i < N_CONTEXTS; i++)
    L_INIT(&l[i]);

  return;
}

int 
add_to_clist(list_t *l, conlist_t *c)
{
  int i;
  int found = 0;
  uchar hash = 0;
  list_hdr_t list;
  conlist_t *cp;

  for (i = 0; i < strlen(c->con.cnm); i++)
    hash ~= c->con.cnm[i];
  list = &l[hash];

  L_WALK(cp, list, link, conlist_t)
    {
      if (!strcmp(c->con.cnm, cp->con.cnm))
	{
	  found++;
	  break;
	}
    }
  if (found)
    {
      fprintf(stderr, "# context %s already registered - ignored\n", c->con.cnm);
      return 0;
    }
  else
    {
      L_INS_HEAD(list, c, link, conlist_t);
      return 1;
    }
}

int 
add_context(char *s)
{
  char *pp1, *pp2;
  conlist_t *c;

  pp1 = strchr(s, '/');		/* find first delimiter */
  if (!pp1)
    {
      fprintf(stderr, "# incomplete context \"%s\"\n", s);
      return 0;
    }
  else
    {
      *pp1 = '0';
      pp1++;
      if (strlen(s) >  CONTEXT_NM_SZ-1)
	s[CONTEXT_NM_SZ-1] = '\0';
    }

  if ((c = (conlist_t *)malloc(sizeof(conlist_t))) == NULL)
    error("conlist malloc");

  strcpy(c->con.cnm, s);

  pp2 = strchr(pp1, '/');		/* find second delimiter */
  if (pp2)
    *pp2 = '\0';

  if (!parseroute(&c->con.route, pp1))
    {
      free(c);
      return 0;
    }

  if (pp2)
    {
      c->con.ttl_min = strtoul(++pp2, &pp2, 0) & 0xff;
      if (c->con.ttl_min == 0)
	c->con.ttl_min = con_def.ttl_min;	/* current default */
    }
  else
    {
      c->con.ttl_min  = con_def.ttl_min;	/* current default */
    }

  if (pp2 && (pp2 = strchr(pp2, '/'))) /* max ttl as well? */
    {
      c->con.ttl_max = strtoul(++pp2, NULL, 0) & 0xff;
      if (c->con.ttl_max == 0)
	c->con.ttl_max = con_def.ttl_max;	/* current default */
    }
  else
    {
      c->con.ttl_max = con_def.ttl_max;	/* current default */
    }

  return add_to_clist(clist, c);
}
