/*  -*- Mode: C;  -*-
 * File: jroute_threads.h
 * Author: James Hall (jch1003@cl.cam.ac.uk)
 * Copyright (C) University of Cambridge Computer Laboratory, 1998
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ** PACKAGE:
 **
 ** FUNCTION:
 **
 ** HISTORY:
 ** Created: Tue Aug 11 16:04:23 1998 (jch1003)
 ** Last Edited: Wed Oct 28 10:59:48 1998 By James Hall
 **
    $Log: jroute_threads.h,v $
    Revision 1.8  1998/11/11 13:50:28  iap10
    *** empty log message ***

    Revision 1.7  1998/11/11 12:52:52  jch1003
    *** empty log message ***

    Revision 1.6  1998/10/19 20:26:07  jch1003
    *** empty log message ***

    Revision 1.5  1998/10/12 10:31:05  iap10
    *** empty log message ***

    Revision 1.4  1998/10/09 12:11:27  jch1003
    *** empty log message ***

    Revision 1.3  1998/08/14 11:46:32  jch1003
    *** empty log message ***

 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */


#define TRC(x) 

#define N_THREADS_DEF 64
#define N_THREADS_MAX 64	/* MAX 64 - limited by port space */

#define mlock(m, msg)                              \
  MACRO_BEGIN                                      \
   if (pthread_mutex_lock((m)) == -1)              \
     thread_error(me, "mutex lock", msg);          \
  MACRO_END

#define munlock(m, msg)                              \
  MACRO_BEGIN                                      \
   if (pthread_mutex_unlock((m)) == -1)              \
     thread_error(me, "mutex unlock", msg);          \
  MACRO_END

#define condsig(c, msg)                            \
  MACRO_BEGIN                                      \
   if (pthread_cond_signal((c)) == -1)              \
     thread_error(me, "cond signal", msg);          \
  MACRO_END

#define condbroad(c, msg)                            \
  MACRO_BEGIN                                      \
   if (pthread_cond_broadcast((c)) == -1)              \
     thread_error(me, "cond broadcast", msg);          \
  MACRO_END

#define condwait(c, m, msg)                            \
  MACRO_BEGIN                                      \
   if (pthread_cond_wait((c), (m)) == -1)              \
     thread_error(me, "cond wait", msg);          \
  MACRO_END

#define tjoin(t, valp, msg)                            \
  MACRO_BEGIN                                      \
   if (pthread_join((t), (pthread_addr_t)(valp)) == -1)              \
     thread_error(me, "cond broadcast", msg);          \
  MACRO_END

#define mutinit(m, attr, msg)                            \
  MACRO_BEGIN                                      \
   if (pthread_mutex_init((m), (attr)) == -1)              \
     error2("mutex_init", msg);          \
  MACRO_END

#define condinit(c, attr, msg)                            \
  MACRO_BEGIN                                      \
   if (pthread_cond_init((c), (attr)) == -1)              \
     error2("cond_init", msg);          \
  MACRO_END


#ifdef linux
#define get_exptm(delta, abs, msg)                            \
  MACRO_BEGIN                                      \
   gettimeofday((struct timeval *)abs, NULL );    \
   (abs)->tv_sec+=(delta)->tv_sec;                      \
   (abs)->tv_nsec*=1000;                          \
  MACRO_END

#else

#define get_exptm(delta, abs, msg)                            \
  MACRO_BEGIN                                      \
   if (pthread_get_expiration_np((delta), (abs)) == -1)              \
     thread_error(me, "get_expiration", msg);          \
  MACRO_END

#endif

#define cond_timedwait(c, m, abs, msg)                            \
  MACRO_BEGIN                                      \
   if (pthread_cond_timedwait((c), (m), (abs)) == -1 && errno != EAGAIN)  \
     thread_error(me, "cond_timedwait", msg);          \
  MACRO_END


/* 
 * codes for thread probe status 
 */

/* 1-6 and 13 = icmp unreach status code +1 */
#define UNREACH_CODE_MAX 15
#define PROBE_INVALID 0U
#define PROBE_TTL_EXCEEDED -1
#define PROBE_TIMED_OUT -2
#define PROBE_TCP_CONNECTED -3
#define PROBE_TEST_RELAXED -200


typedef struct threadarg
{
  /* guarded by dm mutex */
  struct sockaddr_in *wherefrom;
  /**/
  int me;
  FILE *inf;			/* file if rthreads getting own addrs. */
} threadarg_t;

typedef struct threadata 
{
  threadarg_t args;
  pthread_t thread;
  /* guarded by dm mutex */
  int valid;			/* icmp data valid */
  addr_un_t icmp_from;		/* where icmp msg came from */
  uchar ret_ttl;
  int tcplen;	   /*  length of tcp part of probe inferred from icmp return*/
  struct sockaddr_in whereto;		/* where currently probing */
  struct sockaddr_in wherefrom;		/* our address and *current* port */
  /**/
  pthread_mutex_t dm;		/* housekeeping guard */
  pthread_cond_t dc;		/* associated cv */
  src_route_t  icmp_src_route;  /* magic returned in ICMP message */
} threadata_t;

/*
 * control output lock
 */

#define NOLOCK 0
#define LOCK 1

/*
 * jroute_threads.c 
 */

extern addr_train_t *all_addrs;
extern int train_bufsz;
extern int addr_indx;
extern int responses_outstanding;
extern int ithread_waiting;
extern pthread_mutex_t icmpm;
extern pthread_cond_t icmpc;

extern int nreached;
extern int nunreachable;
extern int nprohibited;
extern int nttlexpired;
extern int nnotagreed;
extern int *nhop_dist;	

extern int res_sent;
extern long res_sentb;

extern pthread_mutex_t globem;

void thread_error(int me, char *what, char *msg);
void thread_error2(int me, char *msg1, char *msg2);
void threads_init(struct sockaddr_in *wherefrom, int nthreads, FILE *inf);
void rthread_inform();
int add_addr(char *astring, uint line);
int rthread(pthread_addr_t arg);
int ithread(pthread_addr_t arg);
void threads_finish(int nthreads);
void write_lock(int me);
void write_unlock(int me);
void rthread_wait(int me);
void update_globals(int me, addr_train_t *t);
void report(struct timeval *start, struct timeval *finish);

/*
 * getroute.c
 */
void getroute(int thread, addr_train_t *train, threadata_t *tdata);
