/*
 *
 * (C) 2001 Mixerton Flash BIOS for H8S
 * www.mixerton.com
 * DJ Greaves
 */ 

#ifndef MIXFLASH_H
#define MIXFLASH_H

#define MAXLINE (132)
#define HISTORY (4)

#define IHEX_MAX_LENGTH 64

#ifndef uchar
#define uchar unsigned char
#endif

#define MAXARG (16)
extern char *argv[MAXARG];
extern char *inpoi;
extern char ihex_buffer[IHEX_MAX_LENGTH];
extern uchar errorf;
extern uchar *ihex_offset;

void ihex_write(char *dest, char *src, short int len);
extern short int flash_erase(long int);
extern char LOAD_POINT[];
extern char linebuffer[MAXLINE+1];
extern char lines[HISTORY][MAXLINE+1];
extern short int histline, pointer, lineidx;

/*
 *  We support 96 kbytes of loadable code from Code base to Code End
 */
#define CODE_FLAG       0x1234
#define CODE_FLAG_PLACE 0x01FFF0
#define CODE_BASE 0x8000
#define CODE_END  0x1FFFF

#define MEM_CODE_REGION  0xFFF000  /* The second kilobyte plus of onchip RAM */


#endif
/* eof */




