        ;  mixbug.S
	; Lowmon.S		; 
 	; (C) 2001 Mixerton.ST  www.mixerton.com

;/*
; *     This file is a minimal machine code monitor for the H8S
; *     processor.  
; * Date:
; *
; * (C) 2001 Mixerton Technology ST
; * (C) 1998 Tenison Technology Ltd
; *
; * No responsibility can be taken for loss or consquential loss.
; * 
; */

	.h8300h			; 
	.section	.text
												
	;; System Control Register
	.set syscr,0xffff39
	
	;; Port 1
	.set p1ddr,0xfffeb0
	.set p1dr,0xffff60

	;; Port 3
	.set p3ddr,0xfffeb2
	.set p3dr,0xffff62
	
	;; Port 5
	.set p5ddr,0xfffeb4
	.set p5dr,0xffff64
	
 	;; Serial port 0 is PIC control
	.set scr0,0xffff7a		; serial control reg
	.set rdr0,0xffff7d
	.set ssr0,0xffff7c		;  rate
 	.set brr0,0xffff79		;  
	.set smr0,0xffff78		;
	.set tdr0,0xffff7b	;  transmit data reg

 	;; Serial port 1 is ops and maintenance port
	.set scr1,0xffff82		; serial control reg
	.set rdr1,0xffff85
	.set ssr1,0xffff84		;  rate
 	.set brr1,0xffff81		;  16 for 19200
	.set smr1,0xffff80		;
	.set tdr1,0xffff83	;  transmit data reg

	;; Port G
	.set pgddr,0xfffebf	;  Needed for the CSn outputs
	.set mstp,0xffff3c	;  module stop register
	;;

	
	.set wcrl,0xfffed3
	.set wcrh,0xfffed2
	
	;;
	;; Initialise sufficient hardware resources to run the monitor
	;; 
micro_init:		
	mov.b	#0x1e,r0l	;  Turn on all 4 CSn outputs
	mov.b	r0l,@pgddr

	mov.w	#0x7080,r0	;  Enable SCI 0-1 and ADC, turn off SCI1, DTC and timers
	mov.b	r0h,@mstp
	mov.b	r0l,@(mstp+1)

	;; 	mov.b	#0xff,r0l
	;;  	mov.b	r0l,@_craftchar 
	
	mov.w	#0,r1				
msdel:				;  Delay loop while recover from mstp write.
	add.w	#1,r1
	bne	msdel

	sub.w	r0,r0
	mov.b	r0l,@wcrl	;  Zero the wait state generators for fast operation
		
	;;  Dont need to set port 3 low two bits as outputs for RS232 output
	;; 		mov.b	#3,r0l
	;; 		mov.b	r0l,@p3ddr
	
	mov.b	#(32*4),r0l	; Set BTT1 to 32*4 for 4800 baud	(page 411 of manual)
	mov.b	r0l,@brr0
	
	mov.b	#32,r0l		; Set BTT1 to 32 for 19200 baud	(page 411 of manual)
	mov.b	r0l,@brr1
	mov.b	#0,r0l		;  Set SMR1 to zero
	mov.b	r0l,@smr0
	mov.b	r0l,@smr1

	mov.w	#0,r1				
podel:				;  Power up delay loop and uart settling delay
	add.w	#1,r1
	bne	podel
	
	mov.b	#0x30,r0l	;  SCR1 to 0x30 to turn on the serial ports
	mov.b	r0l,@scr0
	mov.b	r0l,@scr1

	mov.b	#'L',r0l	;  Issue letter L out of both serial ports
	bsr	craft_wrch:16	;  as power up loading indicator.

	mov.b	#'L',r0l
	bsr	protocol_wrch:16

	rts

;---------------------------------------------------------------
bug_escape:
	jmp	0x82		; Warm start to mymon and flash loader

_exit:	
	orc.b	#0x80,ccr	; Ints off
	jmp	monitor_main

;---------------------------------------------------------------
monitor_main:
	mov.b	#'M',r0l
	jsr 	craft_wrch
	
	mov.b	#'I',r0l
	jsr 	craft_wrch

	mov.b	#'X',r0l
	jsr 	craft_wrch
	

	mov.b	#'B',r0l
	jsr 	craft_wrch

	mov.b	#'U',r0l
	jsr 	craft_wrch
	
	mov.b	#'G',r0l
	jsr 	craft_wrch

	mov.b	#'+',r0l
	jsr 	craft_wrch
	
	jsr 	crlf

bugcmd:
	mov.b	#'>',r0l
	jsr 	craft_wrch
	
	jsr	sa_rdch_3s
	jsr	craft_wrch

	cmp.b	#13,r0l
	beq	bugcmd
	cmp.b	#10,r0l
	beq	bugcmd

	cmp.b	#27,r0l
	beq	bug_escape

	bsr	toupper
	cmp.b	#'D',r0l
	beq	lbug_display_byte
	cmp.b	#'W',r0l
	beq	lbug_display_word

	cmp.b	#'R',r0l
	beq	bug_readloop
	cmp.b	#'G',r0l
	beq	bug_execute
	cmp.b	#'M',r0l
	beq	bug_modify

	cmp.b	#'P',r0l
	beq	lbug_poke
	
bugerror:
	jsr	crlf
	mov.b	#'E',r0l
	jsr	craft_wrch
	mov.b	#'R',r0l
	jsr	craft_wrch
	jsr	crlf
	bra	bugcmd


lbug_poke:		jmp	bug_poke
lbug_display_word:	jmp	bug_display_word
lbug_display_byte:	jmp	bug_display_byte
;-----------------------------
toupper:	
	cmp.b	#'a',r0l
	blt	toupper_00
	cmp.b	#'z',r0l
	bgt	toupper_00
	add.b	#(256-32),r0l
toupper_00:
	rts

;-----------------------------
_crlf:
crlf:	mov.b	#10,r0l
	jsr 	craft_wrch
	mov.b	#13,r0l
	jmp 	craft_wrch

;-----------------------------
bug_execute:
	jsr	sa_gethex6
	mov.l	er0,er4
	jsr	_sa_hex6
	jmp	@er4
;-----------------------------
bug_readloop:
	jsr	sa_gethex6
	mov.l	er0,er4
	jsr	_sa_hex6
readloop_poll:
	mov.w	@er4,r0
	nop
	nop
	nop
	nop
	bra	readloop_poll
;-----------------------------
	;; modify reads 4 hex digits and stores them to memory words.
	;; Word stores are used.
	;; 
	
	bug_modify:			;
	
	jsr	sa_gethex6	; Read address
	mov.l	er0,er4		; R4 is a pointer

bug_modify1:
	jsr	sa_rdch_3s
	jsr	craft_wrch
	cmp.b	#'.',r0l
	beq	bug_modify2
	jsr	sa_gethex2_prime
	mov.w	r0,r2
	jsr	sa_gethex2
	mov.b	r2l,r0h
	mov.w	r0,@er4
	add.l	#2,er4
	bra	bug_modify1	; Get next word

bug_modify2:
	jsr	crlf
	jmp	bugcmd
;-----------------------------
; Poke stores bytes and does not advance the address.
bug_poke:
	jsr	sa_gethex6	; Read address
	mov.l	er0,er4		; R4 is a pointer
	jsr	_sa_hex6
	mov.b	#' ',r0l	
	jsr 	craft_wrch
bug_poke1:
	mov.b	#' ',r0l	
	jsr 	craft_wrch


	jsr	sa_rdch_3s
	jsr	craft_wrch
	cmp.b	#'.', r0l
	beq	bug_poke2
	jsr	sa_gethex2_prime
	mov.b	r0l,@er4		; Poke stores bytes and does not advance
	bra	bug_poke1	; Get next byte 

bug_poke2:
	jsr	crlf
	jmp	bugcmd
;-----------------------------
bug_display_byte:
	bsr	sa_gethex6
	mov.l	er0,er4
	jsr	crlf
	
	mov.l	er4,er0
	jsr	_sa_hex6
	mov.b	#':',r0l
	jsr	craft_wrch
	mov.b	#' ',r0l
	jsr	craft_wrch
	mov.b	#16,r3l	; bytes to display per line
bug_disp1:
	mov.b	@er4,r0l
	add.l	#1,er4
	jsr	sa_hex2_space

	add.b	#(256-1),r3l
	bne	bug_disp1
	jsr	crlf
	jmp	bugcmd
;-----------------------------
bug_display_word:
	bsr	sa_gethex6
	mov.l	er0,er4
	jsr	crlf
	
	mov.l	er4,er0
	jsr	_sa_hex6
	mov.b	#':',r0l
	jsr	craft_wrch

	mov.b	#' ',r0l 
	jsr	craft_wrch
	mov.b	#8,r3l	; bytes to display per line
bug_dispw1:
	mov.w	@er4,r0
	add.l	#2,er4
	jsr	_sa_hex6
	mov.b	#' ',r0l 	
	jsr	craft_wrch

	add.b	#(256-1),r3l
	bne	bug_dispw1
	jsr	crlf
	jmp	bugcmd

;-------------------------------------------
sa_gethex6:
	bsr	sa_gethex2
	sub.b	r0h,r0h
	mov.w	r0,e3
	bsr	sa_gethex2
	mov.b	r0l,r3h
	bsr	sa_gethex2
	mov.b	r0l,r3l
	mov.l	er3,er0
	rts

sa_gethex2_prime:		; Routine to read two hex chars when first is in r0
	bsr	sa_gethex1_prime
	bra	sa_gethex2_cont
sa_gethex2:
	bsr	sa_gethex1
sa_gethex2_cont:
	mov.w	r0,r1
	bsr	sa_gethex1
	shal	r1l
	shal	r1l
	shal	r1l
	shal	r1l
	or.b	r1l,r0l
	rts

sa_gethex1:	
	jsr	sa_rdch_3s
	jsr	craft_wrch
sa_gethex1_prime:
	cmp.b	#' ',r0l
	beq	sa_gethex1
	and.b	#255,r0l
	cmp.b	#'0',r0l
	blt	sa_gethex1_02
	cmp.b	#'9',r0l
	bgt	sa_gethex1_02
	add.b	#(256-'0'),r0l
	rts

sa_gethex1_02:
	cmp.b	#'a',r0l
	blt	sa_gethex1_03
	cmp.b	#'f',r0l
	bgt	sa_gethex1_03
	add.b	#(256-0x57),r0l
	rts

sa_gethex1_03:
	cmp.b	#'A',r0l
	blt	sa_gethex1_04
	cmp.b	#'F',r0l
	bgt	sa_gethex1_04
	add.b	#(256-0x37),r0l
	rts

sa_gethex1_04:	
	mov.b	#'E',r0l
	jmp	craft_wrch

;------------------------------------------------

_craft_testch:	
	btst	#5,@(ssr1)
	beq	craft_testchV
	bclr	#5,@(ssr1)	;  Clear the overrun signals if set.
	bra	_craft_testch	

craft_testchV:		
		;; 	mov.b	@_craftchar,r0l
		;; 	cmp.b	#0xFF,r0l
		;; 	bne	craft_testch001
	btst	#6,@ssr1
	beq	craft_testch00
		;; 	mov.b	@(rdr1),r0l
		;; 	bclr	#6,@ssr1
		;;  	mov.b	r0l,@_craftchar
craft_testch001:	
	mov.w	#1,r0
	rts

craft_testch00:
	mov.w	#0,r0
	rts

sa_rdch_prefetched:	
	mov.b	#0xff,r1l
;; 	mov.b	r1l,@_craftchar
	rts	

_craft_sa_rdch:
	;;  	mov.b	@_craftchar,r0l 
	;; 	cmp.b	#0xff,r0l
	;; 	bne	sa_rdch_prefetched
	btst	#6,@(ssr1)
	bne	sa_rdch_3s01
	bra 	_craft_sa_rdch
	
sa_rdch_3s:	
	jsr	_service_wdt
	btst	#6,@(ssr1)
	bne	sa_rdch_3s01
	btst	#6,@(ssr0)
	bne	sa_rdch_3s00
	bra	sa_rdch_3s	

sa_rdch_3s00:		
	mov.b	@(rdr0),r0l
	bclr	#6,@ssr0
	bra	sa_rdch_3s000
	
sa_rdch_3s01:		
	mov.b	@(rdr1),r0l
	bclr	#6,@ssr1
	
sa_rdch_3s000:		
;	cmp.b	#3,r0l		; If control C;
;	jmp	cc_eq,0		; then cold start
	rts
	;
	;
_polled_sa_rdch:
	jsr	_service_wdt
	btst	#6,@ssr1
	bne	rdch1
	btst	#6,@ssr0
	bne	rdch0
	bra	_polled_sa_rdch

	
rdch0:	mov.b	@rdr0,r0l 
	bclr	#6,@ssr0
	rts

	
rdch1:	mov.b	@rdr1,r0l 
	bclr	#6,@ssr1
	rts

; See if a char is there to read.  Return 1 if so.
_polled_sa_testch:
	jsr	_service_wdt
	mov.w	#1,r0
	btst	#6,@ssr1
	bne	sa_testch00
	btst	#6,@ssr0
	bne	sa_testch00
	mov.w	#0,r0
sa_testch00:	
	rts



sa_hex2_space:	bsr	sa_hex2
sspace:	
	mov.b	#' ',r0l
	jmp	craft_wrch


_sa_hex4_space:	bsr	sa_hex4
		bra	sspace
_sa_hex2_space:	bsr	sa_hex2
		bra	sspace
_sa_hex6_space:	bsr _sa_hex6
		bra	sspace

_sa_hex6:	
	mov.l	er0,er2
	mov.w	e0,r0
	bsr	sa_hex2	; Give top byte
	mov.l	er2,er0
; Fall in to sa_hex4

sa_hex4:	
	mov.w	r0,r2
	mov.b	r0h,r0l
	bsr	sa_hex2	; Give high byte
	mov.w	r2,r0
; Fall in to sa_hex2
_sa_hex2:
sa_hex2:		mov.b	r0l,r1l	; Save in R1
		shar	r0l
		shar	r0l
		shar	r0l
		shar	r0l
		bsr	sa_hex1
		mov.b	r1l,r0l	; Get back from R1
; Fall into hex1


sa_hex1:	
	and.b	#15,r0l
	cmp.b	#10,r0l
	blt	sa_hex09
	add.b	#7,r0l
sa_hex09:	
	add.b	#'0',r0l
; 
; Fall into sa_wrch - actually these sa_routines are now craft routines.
; 
; 
_craft_wrch:
craft_wrch:		
craft_wrch_1:	
	btst	#7,@(ssr1)	; Bit 7 is a one if we can send
	beq	craft_wrch_1	; the next char.
	mov.b	r0l,@(tdr1)
	bclr	#7,@ssr1
	rts

;; -------------------------
;; Write to craft then fall into protocol_wrch
_both_wrch:
sa_wrch_1:	
	btst	#7,@(ssr1)	; Bit 7 is a one if we can send
	beq	sa_wrch_1	; the next char.
	mov.b	r0l,@(tdr1)
	bclr	#7,@ssr1

_protocol_wrch:
protocol_wrch:		
sa_wrch_0:	
	btst	#7,@(ssr0)	; Bit 7 is a one if we can send
	beq	sa_wrch_0	; the next char.
	mov.b	r0l,@(tdr0)
	bclr	#7,@ssr0
	rts
	
;; --------------------------
_clear_overrun0:
	bclr	#5,@(ssr0)	;  Clear the overrun signals if set.
	bclr	#5,@(ssr1)	;  Clear the overrun signals if set.
	rts
;; --------------------------

	
_service_wdt:
	rts

;--------------------------------------------------------------
	;; EOF

	




