 /*
 *  prlibc.c
 *
 * Software Excellence from Tenison Technology.
 *
 * (C) 1995 Tenison Technology.
 * (C) 1995 DJ Greaves.
 *
 */

#include  "prstdio.h"


#define TRC(X)
#define SKIP(X)

extern int errno;  /* provided as part of stdio library */
extern char deb;

int _crt0()
{
  errno = 0;
  return main(0, 0);
}
#ifdef UDP_CONSOLE
extern OutputDevice output_device;
extern void udp_telnet_flush(void);
#endif

#ifndef putchar
void putchar(char c)
{
  switch (output_device)
    {
    case Serial:
      _sa_wrch(c);
      break;
#ifdef UDP_CONSOLE
    case UDPIP:
      _sa_wrch(c);
      udp_telnet_flush();
      break;
#endif
    }
}
#endif

void exit(int c)
{
  while (1);
}

int strlen(const char *s)
{
  int r = 0;
  while(*(s++)) r++;
  return r;
}

char *strstr(char *targ, char *pat)
{
  while(*targ)
  {
    char *p = pat;
    char *q = targ;
    while (*p && *p == *q) { p++; q++; };
    if (*p == (char) 0) return targ;
    targ++;
  }
  return NULL;
}

char *strcpy(char *dest, const char *src)
{
  while (*src)
  { *(dest++) = *(src++);
  }
  *dest = (char) 0;
  return dest;
}

char *strncpy(char *dest, char *src, int n)
{
  while (n-- > 0)
    {
      *(dest++) = *(src++);
    }
  return dest;
}

#if 0
void memcpy(char *b2, char *b1, int length)
{
  while(--length >= 0) *(b2++) = *(b1++);
}
#endif

void bcopy(char *src, char *dest, int length)
{
  while(--length >= 0) *(dest++) = *(src++);
}

int bcmp(char *b1, char *b2, int length)
{
  while(--length >= 0) if ( *(b1++) != *(b2++)) return 1;
  return 0;
}

void bzero(char *b1, int length)
{
  while(--length >= 0) *(b1++) = (char) 0;
}

char *strcat(char *dest, char *src)
{
  while (*dest) dest++;
  while (*src) { *(dest++) = *(src++); }
  *dest = (char) 0;
  return dest;
}


extern char *spf;
#define pfputc(X) if (spf) { *spf++ = ((char)(X)); } else putchar(X)


void printf(s, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r)
     char *s;
{
  spf = NULL;
  dof(s, &a);
}


void sprintf(string, s, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) 
     char *string;
     char *s;
{
  spf = string;
  dof(s, &a);
  *spf = (char) 0;
}

/*
 * This is for the ARM calling convention.
 */
#define UPDATEPOI(X) { argsused += 1; if (argsused <3) poi-=1; else if \
    (argsused==3) poi = poi+8; else poi += 1; }

dof(char *s, int *poi)
{
  int i = 0;
  int zeropad = 0;
  char c = s[0];
  int argsused = 0;
  int prefield;
  int field;
  while (c)
   { 
     if (c !='%')
     {
       pfputc(c);
       c = s[++i];
       continue;
     }
     field = 0;
     prefield = -1;
 sol:
     {
       uchar t1, t; 
       int tc;
       t = s[++i];
       if (t >= 'a') t = t - 32;
       if (t == 'L') goto sol;

       if (t == '%')
	 {
	   pfputc('%');
	 }
       else
	 {switch(t)
	    { 
	    case 'C': tc = *poi; pfputc(tc);
	      break;
	    case 'S': prstring(*poi, prefield, field);
	      break;
	    case 'X': printx(*poi, field);
	      break;
	      
	    case '*': field = *poi; UPDATEPOI(poi); goto sol;
	      
	    case 'I':
	    case 'D':
	      printi(*poi);
	      break;
	    case 'U':
	      printu(*poi);
	      break;
	      
	    case '0':
	      if (field==0) zeropad = 1;
	    case '1': case '2': case '3': case '4':
	    case '5': case '6': case '7': case '8': case '9':
	      field = field*10 + t - '0';
	      goto sol;
	      
	    case '.': prefield = field; field = 0; goto sol;
	       
	    default: printf("Bad printf selector '%c' \n", t);
	      
	    }
	  c = s[++i];
	  UPDATEPOI(poi);
	}
     }
   }
}

prstring(char *s, int prefield, int field)
{
  if (prefield >= 0)  /* prefield positive implies field is MAX length */
  {
    while(*s && field>0) 
    { 
      pfputc(*s++);
      field--; 
      prefield--; 
    }
    while(prefield>0)
    {
      pfputc(' '); prefield--; 
    }
  }
  else
  {
    while(*s)
    {
      pfputc(*s++); field--;
    }
    while(field>0) 
    {
      pfputc(' '); field--;
    }
  }
}

extern char printi_zeroflag;

printi(int x)
{
  if (x < 0)
  {
     pfputc('-');
     if (x == 0x80000000) 
     { 
       prstring("2147483648", 0, 100);
       return;
     }
     x = -x;
  }
  printu(x);
}
  
printu(int x)
{
  if (x == 0)
    { 
      pfputc('0');
      return;
    }
   printi_zeroflag = 0;

   shi(&x, 1000000000);
   shi(&x, 100000000);
   shi(&x, 10000000);
   shi(&x, 1000000);
   shi(&x, 100000);
   shi(&x, 10000);
   shi(&x, 1000);
   shi(&x, 100);
   shi(&x, 10);
   shi(&x, 1);
 }

shi(unsigned int *p, unsigned int d)
{ 
  char r = 0;
  while (*p >= d)
    { r ++;
      *p = *p - d;
    }
   if (r) printi_zeroflag = 1;
   if (printi_zeroflag) pfputc(r + '0');
}

printx(unsigned int x, int field)
{
  int i;
  unsigned int r = x >> 8;
#if 0
  if (field > 10)
    {
      debhex8(field);
      pfputc('^');
      field = 8;
    }
#endif
  if (r) printx(r, field-2);
  else for (i=2; i<field; i++) pfputc('0');
  hex2(x);
}

debhex8(int x)
{
  if (deb) return;
  hex2(x >> 24);
  hex2(x >> 16);
  hex2(x >> 8);
  hex2(x >> 0);
  pfputc(' ');
}

hex2(int x)
{
  x = x & 255;
  hex1(x >> 4);
  hex1(x);
}

hex1(int x)
{
  x = x & 15;
  pfputc( x>9 ? x+('A'-10): x+'0');
}


int isupper (char c)
{
  if ((c >='A') && (c <= 'Z')) return 1;
  return 0;
}

int isdigit (char c)
{
  if ((c >='0') && (c <= '9')) return 1;
  return 0;
}

int isprint (char c)
{
  if ((c >=' ') && (c <= 126)) return 1;
  return 0;
}



int strcmp(const char *a, const char *b)
{ 
  while(*a == *b)
  {
    if (*a == 0) return 0;
    a++; b++;
  }
  return *a - *b;
}


int strncmp(char *a, char *b, int n)
{ 
  while(*a == *b && n > 0)
  {
    if (*a == 0) return 0;
    a++; b++; n--;
  }
  if (n==0) return 0;
  return *a - *b;
}

int strncasecmp(char *a, char *b, int n)
{
  while((((*a) & 0xdf) == ((*b) & 0xdf)) && (n > 0))
    {
      if (*a == 0)
        return 0;
      a++;
      b++;
      n--;
    }
  if (n==0)
    return 0;
  return *a - *b;
}


char tolower (char c)
 { if ((c >='A') && (c <= 'Z')) return c+32;
   return c;
 }

uchar toupper (char c)
{
  if ((c >='a') && (c <= 'z')) return c-32;
   return c;
}

int islower(char c)
 { if ((c >= 'a') && (c <= 'z')) return 1;
   return 0;
 }

int isalnum(char c)
{
   if (c >= 'a' && c <= 'z') return 1;
   if (c >= 'A' && c <= 'Z') return 1;
   if (c >= '0' && c <= '9') return 1; 
   return 0;
}

int isalpha(char c)
{
   if (c >= 'a' && c <= 'z') return 1;
   if (c >= 'A' && c <= 'Z') return 1;
   return 0;
}

int atoi(char *s)
{
  int r = 0;
  int base = 10;
  if (s == NULL) return 0;
  while (*s == ' ' || *s == 0) s++;  /* Skip leading whities */
  while (1)
   { char c = *(s++);
     if (c >= '0' && c <= '9')
      { r = r*base + c - '0';
        continue;
      }
     if (c >= 'a') c = c - 32;
     if (c =='X')
      { base = 16;
        continue;
      }
     if (base >= 10 && c >= 'A' && c <= 'F')
      {
	r = r*base + c - 55;
        continue;
      }
     break;
   }
  return r;
}


#ifdef NOT_USED
int write(int fd, char *buf, int len)
{
  TRC(_sa_wrch(*buf));
  while (len >0)
    {
      _sa_wrch(*buf++);
      len -= 1;
    }
  return 0;
}
#endif


int sa_write(char *buf, int len)
{
  unsigned char checksum='O';
  TRC(_sa_wrch(*buf));
  while (len >0)
    {
      char c=*buf++;
      if (c == '\n')
	{
	  _sa_wrch(13);
	}
      _sa_wrch(c);
      len -= 1;
    }
#ifdef UDP_CONSOLE
  if (output_device==UDPIP)
    udp_telnet_flush();
#endif
  
  return 0;
}


#ifdef NOT_USED
int read(int f, char *buf, int len)
{
  char c = _polled_sa_rdch();
  *buf = c;
  return 1;
}
#endif


char getchar()
{
  return _sa_rdch(0);
}

/* end of cbg prlibc.c */


