/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.remotehrd.protocol;

import java.io.ObjectOutputStream;

public class RLE {
    
    private int curbufnum;
    private int offsetincurbuf;
    private byte[] curbuf;
    public final byte[][] buf;
    private int byteBufSize;
    
    public RLE(int byteBufSize, int maxByteBufs) {
        assert byteBufSize % 8 == 0;
        this.byteBufSize = byteBufSize;
        this.buf = new byte[maxByteBufs][];
        this.curbufnum = 0;
        this.buf[this.curbufnum] = new byte[byteBufSize]; 
        this.curbuf=buf[this.curbufnum];
        this.offsetincurbuf = 0;        
    }
    
    private void writeInt(int i) {
        if(offsetincurbuf+4>byteBufSize) {
            this.curbufnum++;
            this.buf[this.curbufnum] = new byte[byteBufSize]; 
            this.curbuf=buf[this.curbufnum]; 
            this.offsetincurbuf = 0;        
        } else {
            // fine
        }
        putInt(this.curbuf, this.offsetincurbuf, i);
        this.offsetincurbuf +=4;
        
    }
    
    static void putInt(byte[] b, int off, int val) {
        b[off + 3] = (byte) (val >>> 0);
        b[off + 2] = (byte) (val >>> 8);
        b[off + 1] = (byte) (val >>> 16);
        b[off + 0] = (byte) (val >>> 24);
    }
    
    static int getInt(byte[] b, int off) {
    return ((b[off + 3] & 0xFF) << 0) +
           ((b[off + 2] & 0xFF) << 8) +
           ((b[off + 1] & 0xFF) << 16) +
           ((b[off + 0]) << 24);
    }
    
    public int encode(int[] uia) {
        // returns length of finished article
        assert uia.length>=1;
        
        int last = uia[0];
        int lastCount = 1;
         
        for(int i=1; i<uia.length; i++) {
            int cur = uia[i];
            if(cur==last) {
                lastCount++;
            } else {
                writeInt(last);
                writeInt(lastCount);
                last = cur;
                lastCount=1;
            }
        }
        writeInt(last);
        writeInt(lastCount);
        return this.byteBufSize*this.curbufnum+this.offsetincurbuf;
    }
    
    public static int decode(byte[][] eba, int totallength, int[] uia) {
        final int buflength = eba[0].length;
        assert buflength % 8 == 0 : buflength;
        final int wholebufstoread = totallength / buflength;
        int curOffsetInUia = 0;
        for(int curbufnum=0; curbufnum<wholebufstoread; curbufnum++) {
            byte[] curbuf = eba[curbufnum];
            for(int i=0; i<buflength; i+=8) {
                int curInt = getInt(curbuf, i);
                int curCount = getInt(curbuf, i+4);
                for(int j =0; j<curCount; j++) {
                    uia[curOffsetInUia] = curInt;
                    curOffsetInUia++;
                }                
            }
        }
        int bytesRemaining = totallength % buflength;
        if(bytesRemaining>0) {
            int curbufnum = totallength/buflength;
            byte[] curbuf = eba[curbufnum];
            for(int i=0; i<bytesRemaining; i+=8) {
                int curInt = getInt(curbuf, i);
                int curCount = getInt(curbuf, i+4);
                for(int j =0; j<curCount; j++) {
                    uia[curOffsetInUia] = curInt;
                    curOffsetInUia++;
                }                
            }
        }
        return curOffsetInUia;
    }
    
    public static void main(String[] args) {
        int[] toEnc = new int[] { 1, 2, 3, 4, 4, 4, 4, 4, 2, 3, 1 };
        RLE r = new RLE(16, 500);
        int l = r.encode(toEnc);
        int[] unEnc = new int[toEnc.length];
        RLE.decode(r.buf, l, unEnc);
        System.out.println("DOne.");
        
    }
}
