/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.remotehrd.protocol;


import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

import javax.imageio.ImageIO;

import t3.hrd.state.JOGLHelper;


public class OpUpdateTileContents implements Serializable {
	/**
     * 
     */
    private static final long serialVersionUID = -3324376593979675376L;
    public static final int COMPRESS_UNCOMPRESSED = 0;
    public static final int COMPRESS_PNG = 1;
    public static final int COMPRESS_RLE = 2;
    public final int elId;
	public final Rectangle r;
    public final boolean usedUSHORT565RGBnotINTARGB;
    
	public int[] uncompr_intBuffer; // may be null
	public short[] uncompr_shortBuffer; // may be null
    public final int compressionHint;
    
	public byte[] compr_png_byteBuffer; // may be null
    public byte[][] compr_rle_byteBuffers; // may be null
    public int compr_rle_clength;
    public int compr_rle_ulength;
	public int compressionState;
	
	
    public OpUpdateTileContents(int tileId, int x, int y, BufferedImage img, int compressionHint) {
        assert 
        img.getType()==BufferedImage.TYPE_INT_ARGB 
        || img.getType()==BufferedImage.TYPE_USHORT_565_RGB;
        
        this.usedUSHORT565RGBnotINTARGB = img.getType()==BufferedImage.TYPE_USHORT_565_RGB;
        if(img.getType()==BufferedImage.TYPE_INT_ARGB) {
            this.uncompr_intBuffer = JOGLHelper.bufferedImageToIntArrayForTextureWithoutCopyIfPossible(img);
            this.uncompr_shortBuffer = null;
        } else {
            this. uncompr_intBuffer = null;
            this.uncompr_shortBuffer = JOGLHelper.bufferedImageToShortArrayForTextureWithoutCopyIfPossible(img);
        }
        this.r = new Rectangle(x,y,img.getWidth(),img.getHeight());
        this.compressionHint = compressionHint;
        this.compressionState = COMPRESS_UNCOMPRESSED;
        this.compr_png_byteBuffer=null; 
        this.compr_rle_byteBuffers=null; 
        this.elId = tileId;
    }
            
	
	public synchronized void compressIfRequired() {
        if(this.compressionHint!=this.compressionState) {
            if(this.compressionHint == COMPRESS_PNG) {
                /*ByteArrayOutputStream b = new ByteArrayOutputStream();
                try {
                    boolean ok = ImageIO.write(img,"png",b);
                    assert ok;
                } catch(IOException e) {
                    throw new RuntimeException(e);
                }
                byteBuffer = b.toByteArray();
                intBuffer = null;
                shortBuffer = null;               */
                assert false;
            } else if(this.compressionHint == COMPRESS_RLE) {
                assert !this.usedUSHORT565RGBnotINTARGB;
                int bufsize = r.width + (8 - (r.width % 8));
                RLE rle = new RLE(bufsize, r.width*r.height*4*2/bufsize);
                long t1 = System.currentTimeMillis();
                this.compr_rle_clength = rle.encode(this.uncompr_intBuffer);
                this.compr_rle_ulength = this.uncompr_intBuffer.length;
                this.compr_rle_byteBuffers = rle.buf;
                this.uncompr_intBuffer = null;
                rle =  null;
                //System.out.println("Compression took: "+(System.currentTimeMillis()-t1));
            } else {
                assert false;
            }
            this.compressionState = this.compressionHint;
        } else {
            // do nothing
        }
    }
            
         
	
	public BufferedImage reconstructBufferedImage() {
		int desiredImageType = 
			this.usedUSHORT565RGBnotINTARGB 
			? BufferedImage.TYPE_USHORT_565_RGB 
			: BufferedImage.TYPE_INT_ARGB;
		if(this.compressionState == COMPRESS_UNCOMPRESSED) {
            BufferedImage b = new BufferedImage(
                    JOGLHelper.createNewColorModelForTexture(this.usedUSHORT565RGBnotINTARGB),
                    this.usedUSHORT565RGBnotINTARGB 
                        ? JOGLHelper.shortArrayToWritableRasterForTextureWithoutCopy(this.uncompr_shortBuffer, this.r.width, this.r.height)
                        : JOGLHelper.intArrayToWritableRasterForTextureWithoutCopy(this.uncompr_intBuffer, this.r.width, this.r.height),
                    false,
                    null
                );
                assert b.getType() == desiredImageType;
                return b;            
        } else if(this.compressionState == COMPRESS_PNG) {
			ByteArrayInputStream b = new ByteArrayInputStream(this.compr_png_byteBuffer);			
			try {
				/*
				 * It can be very time consuming to compress because
				 * Not only do we have to compress and decompress, but also
				 * it decompresses into the wrong image format so we then 
				 * have to convert it into the correct format image.
				 */
				BufferedImage img = ImageIO.read(b);
				assert img != null : "Couldn't decode image";
				img = JOGLHelper.convertBufferedImageToNewTypeIfNecessary(img, desiredImageType);
				assert img.getType() == desiredImageType;
				return img;
			} catch(IOException e) {
				throw new RuntimeException(e);
			}
        } else if(this.compressionState == COMPRESS_RLE) {
            assert !this.usedUSHORT565RGBnotINTARGB;
            this.uncompr_intBuffer = new int[this.compr_rle_ulength];
            int l = RLE.decode(this.compr_rle_byteBuffers, this.compr_rle_clength, this.uncompr_intBuffer);
            assert l==this.uncompr_intBuffer.length;
            this.compressionState = COMPRESS_UNCOMPRESSED;
            this.compr_rle_byteBuffers = null;
            this.compr_rle_clength = 0;
            this.compr_rle_ulength = 0;
            BufferedImage b = new BufferedImage(
                    JOGLHelper.createNewColorModelForTexture(this.usedUSHORT565RGBnotINTARGB),
                    this.usedUSHORT565RGBnotINTARGB 
                        ? JOGLHelper.shortArrayToWritableRasterForTextureWithoutCopy(this.uncompr_shortBuffer, this.r.width, this.r.height)
                        : JOGLHelper.intArrayToWritableRasterForTextureWithoutCopy(this.uncompr_intBuffer, this.r.width, this.r.height),
                    false,
                    null
                );
            assert b.getType() == desiredImageType;
            return b;
        } else {
            assert false;
            return null;
        }
	}
	
	public String toString() {
		int size = ((this.compr_png_byteBuffer!=null) ? this.compr_png_byteBuffer.length : 0)
			+ ((this.uncompr_intBuffer!=null) ? this.uncompr_intBuffer.length : 0)
			+ ((this.uncompr_shortBuffer!=null) ? this.uncompr_shortBuffer.length : 0)
            + ((this.compr_rle_byteBuffers!=null) ? this.compr_rle_clength : 0);
		return super.toString()+" size="+size;
	}
	

	
}