/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios;

/**
 * Implementors of this interface provide behaviour that can be applied to many portfolios,
 * such as dragging or rotateNtranslate. See PortfolioServer for more information on the event model.
 * 
 * @author pjt40
 *
 */
public interface PortfolioCommonBehaviour {

	/**
	 * Implement this method to receive events. 
	 * See PortfolioServer for more information on the event model.
	 * @param e			Event
	 * @param bubbled	True iff the event did not occur on this portfolio's tile but has been bubbled from one of its children.
	 * @return			True iff the event should not be passed to the portfolio.
	 */
	public boolean customProcessEventForThisPortfolioNotChildren(Portfolio p, PortfolioEvent e, boolean bubbled);
	
	/**
	 * Implement this method to receive FDOP mode events. 
	 * See PortfolioServer for more information on the event model.
	 * @param e		Event
	 * @param PORTxWhenEnteredFDOPmode	PORT space coordinate of the PID when it entered FDOP mode.
	 * @param PORTyWhenEnteredFDOPmode	PORT space coordinate of the PID when it entered FDOP mode.
	 * @return			True iff the event should not be passed to the portfolio.
	 */	
	public boolean customProcessFDOPevent(Portfolio p, PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode);
	
	/**
	 * Implement this method to be notified when a PID stops being in FDOP mode. 
	 * See PortfolioServer for more information on the event model.
	 * @param pid
	 * @param button
	 * @return			True iff the event should not be passed to the portfolio.
	 */
	public boolean customProcessEndOfFDOPmode(Portfolio p, PointInputDevice pid, int button);
}
