/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios;

/**
 * Represents a set of 0 to 3 PointInputDeviceTypeAndButton's.
 * No more elements may be added once the set is instantiated.
 * Null elements are valid. 
 * @author pjt40
 *
 */
public class PointInputDeviceTypeAndButtonSet {
	
	public final PointInputDeviceTypeAndButton pidTypeAndButton1, pidTypeAndButton2, pidTypeAndButton3;

	public PointInputDeviceTypeAndButtonSet(PointInputDeviceTypeAndButton pidTypeAndButton1) {
		this(pidTypeAndButton1, null, null);
	}
	
	public PointInputDeviceTypeAndButtonSet(
		PointInputDeviceTypeAndButton pidTypeAndButton1, 
		PointInputDeviceTypeAndButton pidTypeAndButton2, 
		PointInputDeviceTypeAndButton pidTypeAndButton3
	) {
		// TODO Auto-generated constructor stub
		this.pidTypeAndButton1 = pidTypeAndButton1;
		this.pidTypeAndButton2 = pidTypeAndButton2;
		this.pidTypeAndButton3 = pidTypeAndButton3;
	}
	
	public boolean contains(PointInputDeviceTypeAndButton pidTypeAndButton) {
		assert pidTypeAndButton!=null;
		return 
			(this.pidTypeAndButton1!=null && this.pidTypeAndButton1.equals(pidTypeAndButton))
			|| (this.pidTypeAndButton2!=null && this.pidTypeAndButton2.equals(pidTypeAndButton))
			|| (this.pidTypeAndButton3!=null && this.pidTypeAndButton3.equals(pidTypeAndButton));
	}
	
	
}
