/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios;


/**
 * A data structure class representing a single person. Two instances with
 * identical field data will return true when compared using the .equals() method.
 * 
 * @author pjt40
 *
 */

public class Person {
	public final int clientId;
	public final int personId;
	public Person(int clientId, int personId) {
		this.clientId = clientId;
		this.personId = personId;
	}
	public boolean equals(Object o) {
		return o instanceof Person
		&& ((Person) o).clientId==this.clientId
		&& ((Person) o).personId==this.personId;
	}
	public int hashCode() {
		// toopt
        // brackets are necessary here!
		return (this.clientId<<8)+this.personId;
	}
	public String toString() {
		return super.toString() + "clientId="+this.clientId+" person="+this.personId;
	}
}
