/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.state;


import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;

import t3.hrd.state.Cursor.CursorShapePolygons;

/*
 * Calls are only made through StateManager, Cursor and Tile
 * so as long as you make sure
 * your calls to those are synchronized on StateManager then
 * this class doesn't need any locking 
 */
public interface StateListener {
	public void callback_createdUnwarpedRect(Tile tile,UnwarpedRect r);
	//public void callback_destroyedUnwarpedRect(Tile tile,Rectangle r);
	public void callback_destroyedUnwarpedRectsIntersecting(Tile tile,Rectangle r);
	public void callback_updatedTileAff(Tile t, double DESKcentreX, double DESKcentreY, double DESKwidth, double DESKheight, double thetaClockwise) ;
	public void callback_updatedTileVisibility(Tile tile, boolean v);
	public void callback_updatedTileContents(Tile tile, int x, int y, BufferedImage update, int compressionHint);
	public void callback_updatedTileContentsByCopyingFromOtherTile(Tile tile, int sx, int sy, int dx, int dy, int w, int h, Tile source);
	public void callback_repaintUnbackedTile(Tile tile, Rectangle r, BufferedImage update, Graphics2D g);
	public void callback_createdTile(Tile tile, int w, int h, int flags);
	public void callback_destroyedTile(Tile tile);
	public void callback_changedTilesAndLinksOrder(List<OrderedElement> tilesAndLinksInOrder);
	public void callback_cursorPos(Cursor c, double DESKx, double DESKy, boolean visible);
	public void callback_cursorShape(Cursor c, CursorShapePolygons polygonsForShapeCursor);
	public void callback_updatedCursorOptions(Cursor c);
	public void callback_createdCursor(Cursor c);
	public void callback_destroyedCursor(Cursor c);
	public void callback_createdLink(Link l, int displayType, Color c, ScaRotTraTransformImmutable tUniformRectToDESKrectA, ScaRotTraTransformImmutable tUniformRectToDESKrectB);
	public void callback_updatedLinkAff(Link l, ScaRotTraTransformImmutable tUniformRectToDESKrectA, ScaRotTraTransformImmutable tUniformRectToDESKrectB);
	public void callback_destroyedLink(Link l);
    public void callback_opLogMessage(String message);
}
