/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.state;

import java.util.logging.Logger;

import Jama.Matrix;

class ScaRotTraRectangleBasic {
    private static final Logger logger = Logger.getLogger("t3.hrd.state");
    
    private Matrix mh2ScaRotTraIfComputed;    
    private boolean paramsKnown;
    private double width, height, thetaClockwise, tx, ty;
    
    public ScaRotTraRectangleBasic(Matrix mh2ScaRotTra) {
        setScaRotTra(mh2ScaRotTra);
    }
    
    public ScaRotTraRectangleBasic(double width, double height, double thetaClockwise, double tx, double ty) {
        setScaRotTra(width, height, thetaClockwise, tx, ty);
    }
    
    public void setScaRotTra(Matrix mh2ScaRotTra) {
        this.paramsKnown = false;
        this.mh2ScaRotTraIfComputed = mh2ScaRotTra;
    }
    
    public void setScaRotTra(double width, double height, double thetaClockwise, double tx, double ty) {
        this.width = width;
        this.height = height;
        this.thetaClockwise = thetaClockwise;
        this.tx = tx;
        this.ty = ty;
        this.paramsKnown = true;
        this.mh2ScaRotTraIfComputed = null;
    }
    
    
    public void translate(double dx, double dy) {
        if(this.mh2ScaRotTraIfComputed!=null) {
            this.mh2ScaRotTraIfComputed = JOGLHelper.get2hmTranslation(dx,dy).times(this.mh2ScaRotTraIfComputed);
        }
        if(this.paramsKnown) {
            this.tx+=dx; 
            this.ty+=dy;
        }
        
    }
    
    public boolean isJustTranslation(double width, double height, double thetaClockwise) {
        return paramsKnown && this.width==width && this.height==height && this.thetaClockwise==thetaClockwise;
    }

    public Matrix getMh2ScaRotTra() {
        if(this.mh2ScaRotTraIfComputed==null) {
            // todo
        }
        return mh2ScaRotTraIfComputed;
    }

    public boolean isParamsKnown() {
        return paramsKnown;
    }

    public double getThetaClockwise() {
        checkParamsKnown();
        return thetaClockwise;
    }

    public double getTx() {
        checkParamsKnown();
        return tx;
    }

    public double getTy() {
        checkParamsKnown();        
        return ty;
    }

    public double getWidth() {
        checkParamsKnown();
        return width;
    }

    public double getHeight() {
        checkParamsKnown();
        return height;
    }

    private void checkParamsKnown() {
        if(!this.paramsKnown) {
            throw new IllegalStateException("Parameters (width, height, etc) are not known.");
        }
    }
    
    
    
}
