/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.input;

import java.io.Serializable;
import java.text.DecimalFormat;

/**
 * Data structure to store the state of a point input device.
 * 
 * @author pjt40
 *
 */
public class PointInputDeviceState implements Serializable, Cloneable {
	
	/**
     * 
     */
    private static final long serialVersionUID = 325640659871214324L;


    /**
	 * Device type
	 */
	public final int pointInputDeviceType;
	

	/**
	 * Client id
	 */
	public final int clientId;
	
	/**
	 * Person id
	 */
	public final int personId;
	
	
	/**
	 * True iff the position of the device and its button state are currently known.
	 */
	public boolean positionAndButtonsKnown;
	
	
	/**
	 * Integer where each bit represents a button. LSB is button 0.
	 */
	public int buttons;
	
	/**
	 * Location of the device in DESK space.
	 */
	public double DESKx;
	
	/**
	 * Location of the device in DESK space.
	 */
	public double DESKy;
    
    public Serializable extra = null;
	
	public PointInputDeviceState(int clientId, int pointInputType, int personId) {
		this.pointInputDeviceType = pointInputType;
		this.personId = personId;
		this.clientId = clientId;
	}
	public PointInputDeviceState(int clientId, int pointInputType, int personId, boolean positionAndButtonsKnown, double DESKx, double DESKy, int buttons, Serializable extra ) {
		this.pointInputDeviceType = pointInputType;
		this.personId = personId;
		this.clientId = clientId;
		this.positionAndButtonsKnown = positionAndButtonsKnown;
		this.DESKx = DESKx;
		this.DESKy = DESKy;
		this.buttons = buttons;
        this.extra = null;
	}
	public String toString() {
		DecimalFormat nf = (DecimalFormat) DecimalFormat.getInstance();
		nf.setMaximumFractionDigits(1);
		nf.setMinimumFractionDigits(1);
		nf.setMinimumIntegerDigits(3);
		nf.setPositivePrefix("+");
		return "PIDS pIT="+pointInputDeviceType
		+" cId="+clientId
		+" pId="+personId
		+" pABK="+positionAndButtonsKnown
		+" DESKx="+nf.format(DESKx)
		+" DESKy="+nf.format(DESKy)
		+" b="+buttons;
	}
	
	public PointInputDeviceState clone() {
		try {
			return (PointInputDeviceState) super.clone();
		} catch(CloneNotSupportedException e) {
			throw new RuntimeException(e); 
		}
	}
	

}
