/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3ptests;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.ServerSocket;

import t3.hrd.state.JOGLHelper;
import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.hrd.util.FPSLimiter;
import t3.hrd.util.FPSTimer;
import t3.portfolios.PointInputDevice;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.AnimatorThread;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.remotehrd.protocol.OpUpdateTileContents;


public class ForcedMoveNoTransfer extends AbstractPTest {
    public ForcedMoveNoTransfer() {}
    
    private PlainPortfForTest pts[][];

    AnimatorThread pat;
    
    public void setupPTest() throws Throwable {
        final double thetaIncrement = 0.25*2*Math.PI/pto.targetfps;
        
        final int nRows = (int)Math.ceil(Math.sqrt(pto.ntiles)*TABLEH/TABLEW);
        final int nCols = (int)Math.ceil(pto.ntiles/(double)nRows);
        
        pts = new PlainPortfForTest[nRows][nCols];
        int n=0;
        for(int i=0; i<nRows; i++) {
            for(int j=0; j<nCols; j++) {
                if(n>=pto.ntiles) { 
                    break; 
                }
                n++;
                PlainPortfForTest port = new PlainPortfForTest(ps.rootPortfolio);
                port.setPORTtoDESK( 
                        new ScaRotTraTransformImmutableUniformScale(
                                1.0,
                                0.0,
                                j*TABLEW/nCols,
                                i*TABLEH/nRows
                                ) 
                                );
                pts[i][j] = port;
            }
        }
        
        pat = new AnimatorThread(getTargetMSBetweenFrames(), ps) {
            double a = 0;
            public void runOnEachLoop() {
                a+=thetaIncrement;
                fpst.oneFrame();
                if(a>2.0*Math.PI) {
                    a-=2.0*Math.PI;
                }
                for(int i=0; i<pts.length; i++) {
                    for(int j=0; j<pts[i].length; j++) {
                        if(pts[i][j]!=null) {
                        pts[i][j].setPORTtoDESK(
                            new ScaRotTraTransformImmutableUniformScale(
                                    1.0,
                                    a,
                                    j*TABLEW/nCols+Math.sin(a)*0.0,
                                    i*TABLEH/nRows+Math.cos(a)*0.0                                     
                                    )                        
                        );
                        }
                    }
                }
            }
            @Override
            public void runOnComplete() {
                while(ps.rootPortfolio.childrenTopToBottomReadOnly.size()>0) {
                    ps.rootPortfolio.childrenTopToBottomReadOnly.get(0).setVisibleWhenParentVisible(false);
                    ps.rootPortfolio.childrenTopToBottomReadOnly.get(0).destroyThisAndAllDescendants();
                    
                }
            }
            
        };
        pat.start();
    }
    
    public void finishPTest() throws Throwable {
        pat.reqToComplete();
    }

	
	
    	 

	
}
