/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3ptests;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.hrd.util.FPSTimer;
import t3.portfolios.PlainPortfolio;
import t3.portfolios.PointInputDevice;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.remotehrd.protocol.OpUpdateTileContents;

public abstract class AbstractPTest {
    static final double TABLEW=1200.0, TABLEH=600.0;
    PortfolioServer ps;
    PTestOptions pto;
    FPSTimer fpst = new FPSTimer("Animator fps=", "", 1000000, 0.3, 2000, 8000);
    static PortfolioCommonBehaviour c = 
        new RotateNTranslateWithTranslateOnlyRegion(
                new PointInputDeviceTypeAndButtonSet(
                    new PointInputDeviceTypeAndButton(0,1)
                ), 
                0.3
            );
    
    
    public final void setupGeneric(PTestOptions pto, PortfolioServer ps) {
        this.ps = ps;
        this.pto = pto;
    }
    public abstract void setupPTest() throws Throwable;
    public abstract void finishPTest() throws Throwable;
    
    public final void setPortSizePosnVisAndCHints(Portfolio p) {
        double projw=450.0,projh=350.0;        
        double deskcentrex, deskcentrey;
        if(pto.spanning==1) {
            deskcentrex=projw/2;
            deskcentrey=projh/2;
        } else if(pto.spanning==2) {
            deskcentrex=projw/2;
            deskcentrey=projh;
        } else if(pto.spanning==4) {
                deskcentrex=projw;
                deskcentrey=projh;   
        } else {
            throw new IllegalArgumentException("bad spanning");
        }
        p.setPORTtoDESK( new ScaRotTraTransformImmutableUniformScale(1.0,0.0,deskcentrex, deskcentrey) );
        p.setTileWidthAndHeightInPORT(pto.deskw, pto.deskh);
        p.setVisibleWhenParentVisible(true);
        p.tileUpdateCompressionHints = pto.rle ? OpUpdateTileContents.COMPRESS_RLE : 0;
    }
    
    public final void paintTestTile(Graphics g, int xparam, int yparam) {     
        g.setColor(new Color(128,128,128));
        g.fillRect(0,0,pto.tilew,pto.tileh);
        g.setColor(new Color(128,0,128));
        g.fillRect(0,0,xparam,yparam);
        g.setColor(new Color(0,0,0));
        String s = "Performance test";
        for(int x=0; x<pto.tilew; x+=200) {
            for(int y=0; y<pto.tileh; y+=50) {
                g.drawChars(s.toCharArray(),0,s.length(),x,y);
            }
        }
    }
    
    public final void createBgTile() {
        PlainPortfolio bg = new PlainPortfolio(ps, ps.rootPortfolio, new CannotDragWRTParent(), new Color(0,100,128),0/*Tile.FLAG_BI_USHORT555RGB_NOT_INTARGB*/);
        bg.setTileWidthAndHeightInPORT(1200.0,900.0);
        bg.setPORTtoPPORT(
            new ScaRotTraTransformImmutableUniformScale(
                1.0,
                0.0,
                500.0,
                300.0
            ));
        bg.setVisibleWhenParentVisible(true);
        bg.triggerRepaintEntireTile();
    }
    
    public long getTargetMSBetweenFrames() {
        return Math.round(1000/pto.targetfps);
    }

    
    public class PlainPortfForTest extends Portfolio {
        public PlainPortfForTest(Portfolio parent) {
            super(false, ps, parent, c, true, pto.tilew, pto.tileh, pto.tflags, pto.pflags);
            setPortSizePosnVisAndCHints(this);
            this.triggerRepaintEntireTile();
        }
        
        public PlainPortfForTest(Portfolio parent, PortfolioCommonBehaviour d) {
            super(false, ps, parent, d, true, pto.tilew, pto.tileh, pto.tflags, pto.pflags);
            setPortSizePosnVisAndCHints(this);
            this.triggerRepaintEntireTile();
        }

        // we never enter fdop mode so this should never be called
        protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
            assert false;           
        }

        protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
            return false;
        }

        // we never enter fdop mode so this should never be called
        protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
            assert false;           
        }

        // painting our tile is very basic
        public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
            int squaresize=3;
            int border=10;
           
            g.setColor(new Color(128,0,128));
            g.fillRect(0,0,this.getTileWidthInTILE(),this.getTileHeightInTILE());
            for(int x=border; x<this.getTileWidthInTILE()-border; x+=squaresize) {
                for(int y=border; y<this.getTileHeightInTILE()-border; y+=squaresize) {
                    g.setColor(getRandomLightColor(64,128));
                    g.fillRect(x,y,squaresize,squaresize);
                }
            }
            g.setColor(Color.BLACK);
            String s = "Testing!!!";
            g.drawChars(s.toCharArray(),0,s.length(),(int)(Math.random()*this.getTileWidthInTILE()/2),(int)(Math.random()*this.getTileHeightInTILE()/2));
        }
        
        
        
    }
    
    public static Color getRandomLightColor(int a, int b) {
        return new Color(0,(int)(a+(b-a)*Math.random()),(int)(a+(b-a)*Math.random()));
    }
    
    

     

    
}
