/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.impl.NativeLibLoader;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.media.opengl.GLDrawableFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JOGLAppletLauncher
extends Applet {
    private static final NativeLibInfo[] allNativeLibInfo;
    private NativeLibInfo nativeLibInfo;
    private String[] nativeLibNames;
    private boolean driHackPresent;
    private Applet subApplet;
    private String subAppletClassName;
    private String subAppletDisplayName;
    private String subAppletImageName;
    private String installDirectory;
    private JPanel loaderPanel = new JPanel(new BorderLayout());
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private boolean isInitOk = false;
    private boolean firstStart = true;
    private boolean joglStarted = false;

    public void init() {
        this.subAppletClassName = this.getParameter("subapplet.classname");
        if (this.subAppletClassName == null) {
            this.displayError("Init failed : Missing subapplet.classname argument");
            return;
        }
        this.subAppletDisplayName = this.getParameter("subapplet.displayname");
        if (this.subAppletDisplayName == null) {
            this.subAppletDisplayName = "Applet";
        }
        this.subAppletImageName = this.getParameter("subapplet.image");
        this.initLoaderLayout();
        this.validate();
        String string = this.getCodeBase().toExternalForm().substring(7);
        this.installDirectory = string.replace(':', '_').replace('.', '_').replace('/', '_').replace('~', '_');
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.arch").toLowerCase();
        if (this.checkOSAndArch(string2, string3)) {
            this.isInitOk = true;
        } else {
            this.displayError("Init failed : Unsupported os / arch ( " + string2 + " / " + string3 + " )");
        }
    }

    private void displayMessage(String string) {
        this.progressBar.setString(string);
    }

    private void displayError(String string) {
        this.progressBar.setString("Error : " + string);
    }

    private void initLoaderLayout() {
        this.setLayout(new BorderLayout());
        this.progressBar.setBorderPainted(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Loading...");
        boolean bl = false;
        ImageIcon imageIcon = null;
        if (this.subAppletImageName != null) {
            try {
                imageIcon = new ImageIcon(new URL(this.subAppletImageName));
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        if (bl) {
            this.add((Component)this.loaderPanel, "South");
            this.loaderPanel.add((Component)new JLabel(imageIcon), "Center");
            this.loaderPanel.add((Component)this.progressBar, "South");
        } else {
            this.add((Component)this.loaderPanel, "South");
            this.loaderPanel.add((Component)this.progressBar, "Center");
        }
    }

    public void start() {
        if (this.isInitOk) {
            if (this.firstStart) {
                this.firstStart = false;
                String string = System.getProperty("user.home");
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    classLoader.loadClass("javax.media.opengl.GL");
                    Package package_ = Package.getPackage("javax.media.opengl");
                    String string2 = string + File.separator + ".jogl_ext" + File.separator + this.installDirectory + File.separator + package_.getImplementationVersion().replace(':', '_');
                    final File file = new File(string2);
                    Thread thread = new Thread(){

                        public void run() {
                            JOGLAppletLauncher.this.refreshJOGL(file);
                        }
                    };
                    thread.setPriority(4);
                    thread.start();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Unable to load javax.media.opengl package");
                    System.exit(0);
                }
            } else if (this.joglStarted) {
                this.subApplet.start();
            }
        }
    }

    public void stop() {
        if (this.subApplet != null) {
            this.subApplet.stop();
        }
    }

    public void destroy() {
        if (this.subApplet != null) {
            this.subApplet.destroy();
        }
    }

    public Applet getSubApplet() {
        return this.subApplet;
    }

    private boolean checkOSAndArch(String string, String string2) {
        for (int i = 0; i < allNativeLibInfo.length; ++i) {
            NativeLibInfo nativeLibInfo = allNativeLibInfo[i];
            if (!nativeLibInfo.matchesOSAndArch(string, string2)) continue;
            this.nativeLibInfo = nativeLibInfo;
            return true;
        }
        return false;
    }

    private void refreshJOGL(File file) {
        block18: {
            URLConnection uRLConnection;
            Object object;
            try {
                object = Class.forName(this.subAppletClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.displayError("Start failed : class not found : " + this.subAppletClassName);
                return;
            }
            if (!file.exists() && !file.mkdirs()) {
                this.displayError("Unable to create directories for target: " + file);
                return;
            }
            object = this.nativeLibInfo.getNativeJarName();
            String string = this.getCodeBase().toExternalForm() + (String)object;
            try {
                URL uRL = new URL(string);
                uRLConnection = uRL.openConnection();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.displayError("Couldn't access the native lib URL : " + string);
                return;
            }
            long l = this.getTimestamp(file, uRLConnection.getLastModified());
            if (l != uRLConnection.getLastModified()) {
                this.displayMessage("Updating local version of the native libraries");
                File file2 = new File(file, (String)object);
                try {
                    this.saveNativesJarLocally(file2, uRLConnection);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.displayError("Unable to install the native file locally");
                    return;
                }
                try {
                    int n;
                    JarFile jarFile = new JarFile(file2);
                    if (!this.findNativeEntries(jarFile)) {
                        this.displayError("native libraries not found in jar file");
                        return;
                    }
                    byte[] byArray = new byte[8192];
                    for (n = 0; n < this.nativeLibNames.length; ++n) {
                        JarEntry jarEntry = jarFile.getJarEntry(this.nativeLibNames[n]);
                        if (jarEntry == null) {
                            this.displayError("error looking up jar entry " + this.nativeLibNames[n]);
                            return;
                        }
                        if (this.checkNativeCertificates(jarFile, jarEntry, byArray)) continue;
                        this.displayError("Native library " + this.nativeLibNames[n] + " isn't properly signed or has other errors");
                        return;
                    }
                    this.progressBar.setValue(0);
                    for (n = 0; n < this.nativeLibNames.length; ++n) {
                        this.displayMessage("Installing native files");
                        if (!this.installFile(file, jarFile, this.nativeLibNames[n], byArray)) {
                            return;
                        }
                        int n2 = 100 * (n + 1) / this.nativeLibNames.length;
                        this.progressBar.setValue(n2);
                    }
                    jarFile.close();
                    file2.delete();
                    try {
                        File file3 = new File(file, "timestamp");
                        file3.delete();
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
                        bufferedWriter.write("" + uRLConnection.getLastModified());
                        bufferedWriter.flush();
                        bufferedWriter.close();
                        break block18;
                    }
                    catch (Exception exception) {
                        this.displayError("Error writing time stamp for native libraries");
                        return;
                    }
                }
                catch (Exception exception) {
                    this.displayError("Error opening jar file " + file2.getName() + " for reading");
                    return;
                }
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].getName().indexOf("jogl_drihack") < 0) continue;
                this.driHackPresent = true;
            }
        }
        this.loadNativesAndStart(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTimestamp(File file, long l) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(file, "timestamp")));
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.resetSyntax();
                streamTokenizer.wordChars(48, 57);
                streamTokenizer.wordChars(45, 45);
                streamTokenizer.nextToken();
                String string = streamTokenizer.sval;
                if (string != null) {
                    long l2 = Long.parseLong(string);
                    return l2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l != 0L) return 0L;
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNativesJarLocally(File file, URLConnection uRLConnection) throws IOException {
        IOException iOException3;
        InputStream inputStream;
        block12: {
            BufferedOutputStream bufferedOutputStream = null;
            inputStream = null;
            this.displayMessage("Downloading native library");
            this.progressBar.setValue(0);
            try {
                int n;
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n2 = uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[1024];
                int n3 = 0;
                while ((n = inputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                    int n4 = 100 * (n3 += n) / n2;
                    this.progressBar.setValue(n4);
                }
                bufferedOutputStream.close();
                inputStream.close();
                Object var11_10 = null;
                if (bufferedOutputStream == null) break block12;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var11_11 = null;
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                bufferedOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {}
        }
    }

    private boolean findNativeEntries(JarFile jarFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!this.nativeLibInfo.matchesNativeLib(jarEntry.getName())) continue;
            arrayList.add(jarEntry.getName());
            if (jarEntry.getName().indexOf("jogl_drihack") < 0) continue;
            this.driHackPresent = true;
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        this.nativeLibNames = arrayList.toArray(new String[0]);
        return true;
    }

    private boolean checkNativeCertificates(JarFile jarFile, JarEntry jarEntry, byte[] byArray) {
        try {
            int n;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n2 = (int)jarEntry.getSize();
            while ((n = inputStream.read(byArray)) > 0) {
            }
            inputStream.close();
            Certificate[] certificateArray = jarEntry.getCertificates();
            Certificate[] certificateArray2 = GLDrawableFactory.class.getProtectionDomain().getCodeSource().getCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                return false;
            }
            int n3 = 0;
            block3: for (int i = 0; i < certificateArray2.length; ++i) {
                for (int j = 0; j < certificateArray.length; ++j) {
                    if (!certificateArray[j].equals(certificateArray2[i])) continue;
                    ++n3;
                    continue block3;
                }
            }
            return n3 == certificateArray2.length;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean installFile(File file, JarFile jarFile, String string, byte[] byArray) {
        try {
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) {
                this.displayError("Error finding native library " + string);
                return false;
            }
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n = (int)jarEntry.getSize();
            BufferedOutputStream bufferedOutputStream = null;
            File file2 = new File(file, string);
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            }
            catch (Exception exception) {
                this.displayError("Error opening file " + string + " for writing");
                return false;
            }
            try {
                int n2;
                while ((n2 = inputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                this.displayError("Error writing file " + string + " to disk");
                iOException.printStackTrace();
                file2.delete();
                return false;
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayError("Error writing file " + string + " to disk");
            return false;
        }
    }

    private void loadNativesAndStart(final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block9: {
                    JOGLAppletLauncher.this.displayMessage("Loading native libraries");
                    NativeLibLoader.disableLoading();
                    Class<?> clazz = null;
                    if (JOGLAppletLauncher.this.driHackPresent) {
                        JOGLAppletLauncher.this.loadLibrary(file, "jogl_drihack");
                        try {
                            clazz = Class.forName("com.sun.opengl.impl.x11.DRIHack");
                            clazz.getMethod("begin", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    JOGLAppletLauncher.this.loadLibrary(file, "jogl");
                    if (JOGLAppletLauncher.this.driHackPresent) {
                        try {
                            clazz.getMethod("end", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (!JOGLAppletLauncher.this.nativeLibInfo.isMacOS()) {
                        try {
                            System.loadLibrary("jawt");
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            if (unsatisfiedLinkError.getMessage().indexOf("already loaded") != -1) break block9;
                            JOGLAppletLauncher.this.displayError("Unable to load JAWT");
                            throw unsatisfiedLinkError;
                        }
                    }
                }
                JOGLAppletLauncher.this.loadLibrary(file, "jogl_awt");
                JOGLAppletLauncher.this.displayMessage("Starting applet " + JOGLAppletLauncher.this.subAppletDisplayName);
                JOGLAppletLauncher.this.startSubApplet();
            }
        });
    }

    private void loadLibrary(File file, String string) {
        block2: {
            String string2 = this.nativeLibInfo.getNativeLibName(string);
            try {
                System.load(new File(file, string2).getPath());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (unsatisfiedLinkError.getMessage().indexOf("already loaded") != -1) break block2;
                this.displayError("Unable to load " + string2);
                throw unsatisfiedLinkError;
            }
        }
    }

    private void startSubApplet() {
        try {
            this.subApplet = (Applet)Class.forName(this.subAppletClassName).newInstance();
            this.subApplet.setStub(new AppletStubProxy());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            this.displayError("Class not found (" + this.subAppletClassName + ")");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayError("Unable to start " + this.subAppletDisplayName);
            return;
        }
        this.add((Component)this.subApplet, "Center");
        try {
            this.subApplet.init();
            this.remove(this.loaderPanel);
            this.validate();
            this.subApplet.start();
            this.joglStarted = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        allNativeLibInfo = new NativeLibInfo[]{new NativeLibInfo("win", "x86", "jogl-natives-windows-i586.jar", "", ".dll"), new NativeLibInfo("mac", "ppc", "jogl-natives-macosx-ppc.jar", "lib", ".jnilib"), new NativeLibInfo("mac", "i386", "jogl-natives-macosx-universal.jar", "lib", ".jnilib"), new NativeLibInfo("linux", "i386", "jogl-natives-linux-i586.jar", "lib", ".so"), new NativeLibInfo("linux", "x86", "jogl-natives-linux-i586.jar", "lib", ".so"), new NativeLibInfo("sunos", "sparc", "jogl-natives-solaris-sparc.jar", "lib", ".so"), new NativeLibInfo("sunos", "x86", "jogl-natives-solaris-i586.jar", "lib", ".so")};
    }

    class AppletStubProxy
    implements AppletStub {
        AppletStubProxy() {
        }

        public boolean isActive() {
            return JOGLAppletLauncher.this.isActive();
        }

        public URL getDocumentBase() {
            return JOGLAppletLauncher.this.getDocumentBase();
        }

        public URL getCodeBase() {
            return JOGLAppletLauncher.this.getCodeBase();
        }

        public String getParameter(String string) {
            return JOGLAppletLauncher.this.getParameter(string);
        }

        public AppletContext getAppletContext() {
            return JOGLAppletLauncher.this.getAppletContext();
        }

        public void appletResize(int n, int n2) {
            JOGLAppletLauncher.this.resize(n, n2);
        }
    }

    private static class NativeLibInfo {
        private String osName;
        private String osArch;
        private String nativeJar;
        private String nativePrefix;
        private String nativeSuffix;

        public NativeLibInfo(String string, String string2, String string3, String string4, String string5) {
            this.osName = string;
            this.osArch = string2;
            this.nativeJar = string3;
            this.nativePrefix = string4;
            this.nativeSuffix = string5;
        }

        public boolean matchesOSAndArch(String string, String string2) {
            return string.startsWith(this.osName) && (this.osArch == null || string2.startsWith(this.osArch));
        }

        public boolean matchesNativeLib(String string) {
            return string.toLowerCase().endsWith(this.nativeSuffix);
        }

        public String getNativeJarName() {
            return this.nativeJar;
        }

        public String getNativeLibName(String string) {
            return this.nativePrefix + string + this.nativeSuffix;
        }

        public boolean isMacOS() {
            return this.osName.equals("mac");
        }
    }
}

