/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef DUALMESHBUILDER_H
#define DUALMESHBUILDER_H

#include "meshbuilder.h"
#include "types.h"

namespace snurbs {

/**
 * Used to build a dual Mesh (i.e.\ one with even @link Mesh::degree degree
 * @endlink)
 *
 * @ingroup Support
 */
class DualMeshBuilder : public MeshBuilder
{
public:
    /**
     * DualMeshBuilder constructor
     * @param mesh The mesh to build.
     */
    DualMeshBuilder(Mesh &mesh) : MeshBuilder(mesh) {};

    void addVertex(VertexPrecision x,
                   VertexPrecision y,
                   VertexPrecision z,
                   VertexPrecision w);
    void finishVertices(void);
    void startFace(unsigned int numEdges);
    void addToFace(unsigned int vertNum);
    void closeFace(void);
    void finishFaces(void);
    /**
     * Specify the knot interval along the strip of edges which includes
     * the edge specified by vertex1-vertex2.
     */
    void addKnotInterval(unsigned int vertex1,
                         unsigned int vertex2,
                         KnotPrecision interval);
    void finishKnotIntervals(void);
};

}

#endif
