/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ABSTRACTUNARYPATCHTREE_H
#define ABSTRACTUNARYPATCHTREE_H

#include "patchtree.h"

namespace snurbs {

class PatchTreeLeaf;

/**
 * A PatchTree node with only one child. Necessary for two reasons:
 * - as a base class for PatchTreeRoot
 * - so that the tree can have a uniform depth for a uniform subdivision level,
 *   even when two crossing knot intervals are not subdivided.
 * @ingroup Mesh
 */
class AbstractUnaryPatchTree : public PatchTree
{
public:
    /**
     * AbstractUnaryPatchTree constructor.
     * @param patchTreeLeaf An AbstractUnaryPatchTree is always initialized
     * with a PatchTreeLeaf as the #child PatchTree. Subsequent subdivision
     * may replace this child with a BinaryPatchTree or a QuadPatchTree.
     */
    AbstractUnaryPatchTree(PatchTreeLeaf *patchTreeLeaf);

    /** AbstractUnaryPatchTree destructor. */
    virtual ~AbstractUnaryPatchTree(void);

    bool isLeaf(void) const;

    bool isRoot(void) const;

    bool splits(Orientation orientation) const;

    Direction childDir(const PatchTree *findChild) const;

    /**
     * @name Getter functions
     * @{
     */
    PatchTree *&getChild(Direction dir);
    /** @} */

    void stream(std::ostream &os, unsigned char level) const;

protected:
    /**
     * The sole child PatchTree, which has a parent pointer to this
     * AbstractUnaryPatchTree.
     */
    PatchTree *child;
};

inline bool AbstractUnaryPatchTree::isLeaf(void) const
{
    return false;
}

inline bool AbstractUnaryPatchTree::isRoot(void) const
{
    return false;
}

inline bool AbstractUnaryPatchTree::splits(Orientation /* orientation */) const
{
    return false;
}

}

#endif
