﻿// $Id: SimpleMaximizer.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Finds the lowest cost disparity level in a float-sized cost space.
	/// </summary>
	class SimpleMaximizer : MaximizerStereoNode
	{
		public SimpleMaximizer() : base() { }
		public SimpleMaximizer(ExecutionStream stream) : base(stream) { }

		public override void FindSolution(CostSpace costGrid, DepthMap depthMap)
		{
			ManagedMaximizers.RunMaxKernel(costGrid, 1.0f / (float)costGrid.GetDepth(), depthMap, stream);
		}
	}

	class SimpleMaximizerFactory : StereoNodeFactory<MaximizerStereoNode>
	{
		public override MaximizerStereoNode Create(ExecutionStream stream)
		{
			return new SimpleMaximizer(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = (gridType == CostSpaceType.Single);
		}

		public override string Name
		{
			get { return "Winner-take-all"; }
		}

		public override string SortKey { get { return "_1_" + Name; } } // put this first
	}
}
