﻿// $Id: GreyToFloatNode.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib;
using VideoLib.Frames;
using System.Drawing.Imaging;
using System.Drawing;

namespace CrossChecker
{
	public class GreyToFloatNode : Node
	{
		public float ScaleFactor { get; set; }

		public GreyToFloatNode()
			: base()
		{
			ScaleFactor = 1.0f;

			AddInputPin("in");
			AddOutputPin("out");
		}

		public override void Process()
		{
			// get input bitmap
			Frame frame = GetInputFrame("in");
			if (PassOnEndOfStreamFrame(frame)) return;
			BitmapFrame inputFrame = CastFrameTo<BitmapFrame>(frame);

			// check pixel format
			if (inputFrame.Format != VideoLib.Frames.PixelFormat.RGB24)
				throw new FrameNotSupportedException(inputFrame);

			// convert to array of floats
			BitmapFrame outputFrame = new BitmapFrame(inputFrame.Width, inputFrame.Height, VideoLib.Frames.PixelFormat.Float) { SequenceNumber = inputFrame.SequenceNumber };
			unsafe
			{
				fixed(byte* pIn = inputFrame.Data, pOutByte = outputFrame.Data)
				{
					float* pOut = (float*)pOutByte;
					for (int y = 0; y < inputFrame.Height; y++)
					{
						for (int x = 0; x < inputFrame.Width; x++)
						{
							pOut[y * inputFrame.Width + x] = ScaleFactor * pIn[y * inputFrame.Stride + 3 * x];
						}
					}
				}
			}

			PushFrame(outputFrame);
		}
	}
}
