﻿// $Id: ConverterProgram.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib.Sources;
using VideoLib;
using VideoLib.Scheduling;
using CrossChecker;
using VideoLib.LibAv;
using VideoLib.Frames;
using VideoLib.Sinks;

namespace Converter
{
	public class ConverterProgram
	{
		public static void Main(string[] args)
		{
			if (args.Length < 2)
			{
				Console.WriteLine("Usage: Converter input_map output_map");
				return;
			}

			// inputs
			string inputMap = args[0];
			string outputMap = args[1];

			// set up topology and scheduler ------------------------------------------------------
			Topology topology = Topology.MainInstance;
			Scheduler scheduler = new SimpleDequeScheduler(topology);

			// convert to float map and back to image
			topology.Connect(
				new ImageSequenceSource(inputMap) { LastNumber = 0 },
				new LibAvConvert(PixelFormat.RGB24),
				//new GreyToFloatNode() { ScaleFactor = 1.0f / dispScale },
				new GreyToFloatNode(),
				//new FloatToGreyNode() { ScaleFactor = 255 },
				new FloatToGreyNode(),
				new ImageSequenceSink(outputMap)
			);

			// start the scheduler ----------------------------------------------------------------
			scheduler.Setup();
			scheduler.StartWorkers(1);
			scheduler.Join();
		}
	}
}
