﻿// $Id: ImageVideoSource.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib.LibAv;
using VideoLib.Filters;
using VideoLib.Frames;
using System.Windows.Forms;
using VideoLib.Sources;
using System.Diagnostics;
using System.Drawing;

namespace RealTimeStereoTestViewer
{
    public class ImageVideoSource : VideoSourceBase
	{
		public override string Name { get; set; }
        public string LeftFilename { get; set; }
        public string RightFilename { get; set; }
        public override string StatusText { get { return (LeftFilename != "" && RightFilename != "" ? "Ready" : "Select input images."); } }
		public override VideoSize PreferredSize
		{
			get
			{
				if (LeftFilename != "")
				{
					using(var bitmap = new Bitmap(String.Format(LeftFilename, 1)))
					{
						return new VideoSize() { TargetSize = bitmap.Size };
					}
				}
				return base.PreferredSize;
			}
		}

        public ImageVideoSource()
        {
            LeftFilename = "";
            RightFilename = "";
        }

        public override void SelectSource()
        {
            if (LeftFilename == "")
            {
                OpenFileDialog fileDialog = new OpenFileDialog() { Title = "Select the left image" };
                if (fileDialog.ShowDialog() == DialogResult.OK)
                {
                    LeftFilename = fileDialog.FileName;
                }
            }

            if(RightFilename == "")
            {
                OpenFileDialog fileDialog = new OpenFileDialog() { Title = "Select the right image" };
                if (fileDialog.ShowDialog() == DialogResult.OK)
                {
                    RightFilename = fileDialog.FileName;
                }
            }
        }

        public override bool EnableStartButton()
        {
            return (LeftFilename != "" && RightFilename != "");
        }

        public override void SetupSource(VideoLib.Topology topology, out VideoLib.OutputPin left, out VideoLib.OutputPin right)
        {
            Debug.Assert(LeftFilename != "" && RightFilename != "", "Need valid filenames.");
            ImageSequenceSource sourceL = new ImageSequenceSource(LeftFilename) { FPS = 20, FirstNumber = 1, Loop = true };
			ImageSequenceSource sourceR = new ImageSequenceSource(RightFilename) { FPS = 20, FirstNumber = 1, Loop = true };
            var convertL = new LibAvConvert(PixelFormat.RGB32);
            var convertR = new LibAvConvert(PixelFormat.RGB32);
            topology.Connect(sourceL, convertL);
            topology.Connect(sourceR, convertR);
            left = convertL.OutputPins["out"];
            right = convertR.OutputPins["out"];
        }
    }
}
