﻿// $Id: FileVideoSource.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib.LibAv;
using VideoLib.Filters;
using VideoLib.Frames;
using System.Windows.Forms;

namespace RealTimeStereoTestViewer
{
    public class FileVideoSource : VideoSourceBase
	{
		public override string Name { get; set; }
        public string Filename { get; set; }
        public override string StatusText { get { return Filename; } }

        public FileVideoSource()
        {
            Filename = "";
        }

        public override void SelectSource()
        {
            if (Filename == "")
            {
                OpenFileDialog fileDialog = new OpenFileDialog() { Title = "Open a stereo video" };
                if (fileDialog.ShowDialog() == DialogResult.OK)
                {
                    Filename = fileDialog.FileName;
                }
            }
        }

        public override bool EnableStartButton()
        {
            return Filename != "";
        }

        public override void SetupSource(VideoLib.Topology topology, out VideoLib.OutputPin left, out VideoLib.OutputPin right)
        {
            LibAvSource stereoVideo = new LibAvSource(Filename) { FPS = 25, Format = PixelFormat.RGB32 };
            StereoSplitter splitter = new StereoSplitter();
            topology.Connect(stereoVideo, splitter);
            left = splitter.OutputPins["outL"];
            right = splitter.OutputPins["outR"];
        }
    }
}
