#include "UnmanagedCodeException.h"
#include "CudaException.h"
#include <cuda_runtime_api.h>

using namespace System;
using namespace System::Text;
using namespace Stereo::GpGpuLib;

CudaException^ CreateCudaException(cudaError error, String^ message);

#pragma region A load of overloads for throwing simple exceptions

void ThrowException(const char* message)
{
	throw gcnew Exception(gcnew String(message));
}
void ThrowException(const char* message1, const char* message2)
{
	throw gcnew Exception(String::Concat(gcnew String(message1), gcnew String(message2)));
}
void ThrowException(const char* message1, const char* message2, const char* message3)
{
	throw gcnew Exception(String::Concat(gcnew String(message1), gcnew String(message2), gcnew String(message3)));
}
void ThrowException(const char* message1, const char* message2, const char* message3, const char* message4)
{
	throw gcnew Exception(String::Concat(gcnew String(message1), gcnew String(message2), gcnew String(message3), gcnew String(message4)));
}
void ThrowException(const char* message1, const char* message2, const char* message3, const char* message4, const char* message5)
{
	StringBuilder^ sb = gcnew StringBuilder(gcnew String(message1));
	sb->Append(gcnew String(message2));
	sb->Append(gcnew String(message3));
	sb->Append(gcnew String(message4));
	sb->Append(gcnew String(message5));

	throw gcnew Exception(sb->ToString());
}
void ThrowException(const char* message1, const char* message2, const char* message3, const char* message4, const char* message5, const char* message6)
{
	StringBuilder^ sb = gcnew StringBuilder(gcnew String(message1));
	sb->Append(gcnew String(message2));
	sb->Append(gcnew String(message3));
	sb->Append(gcnew String(message4));
	sb->Append(gcnew String(message5));
	sb->Append(gcnew String(message6));

	throw gcnew Exception(sb->ToString());
}
void ThrowException(const char* message1, const char* message2, const char* message3, const char* message4, const char* message5, const char* message6,
					const char* message7)
{
	StringBuilder^ sb = gcnew StringBuilder(gcnew String(message1));
	sb->Append(gcnew String(message2));
	sb->Append(gcnew String(message3));
	sb->Append(gcnew String(message4));
	sb->Append(gcnew String(message5));
	sb->Append(gcnew String(message6));
	sb->Append(gcnew String(message7));

	throw gcnew Exception(sb->ToString());
}
void ThrowException(const char* message1, const char* message2, const char* message3, const char* message4, const char* message5, const char* message6,
					const char* message7, const char* message8)
{
	StringBuilder^ sb = gcnew StringBuilder(gcnew String(message1));
	sb->Append(gcnew String(message2));
	sb->Append(gcnew String(message3));
	sb->Append(gcnew String(message4));
	sb->Append(gcnew String(message5));
	sb->Append(gcnew String(message6));
	sb->Append(gcnew String(message7));
	sb->Append(gcnew String(message8));

	throw gcnew Exception(sb->ToString());
}
void ThrowException(const char* message1, const char* message2, const char* message3, const char* message4, const char* message5, const char* message6,
					const char* message7, const char* message8, const char* message9)
{
	StringBuilder^ sb = gcnew StringBuilder(gcnew String(message1));
	sb->Append(gcnew String(message2));
	sb->Append(gcnew String(message3));
	sb->Append(gcnew String(message4));
	sb->Append(gcnew String(message5));
	sb->Append(gcnew String(message6));
	sb->Append(gcnew String(message7));
	sb->Append(gcnew String(message8));
	sb->Append(gcnew String(message9));

	throw gcnew Exception(sb->ToString());
}

#pragma endregion

void ThrowCudaException(cudaError error, const char* message)
{
	throw CreateCudaException(error, gcnew String(message));
}

void ThrowCudaException(cudaError error, const char* functionName, const char* surroundingFunction, const char* file, int line)
{
	CudaException^ exception = CreateCudaException(error, gcnew String(functionName));

	exception->InFunction = gcnew String(surroundingFunction);
	exception->InFile = gcnew String(file);
	exception->AtLine = line;

	throw exception;
}

CudaException^ CreateCudaException(cudaError error, String^ message)
{
	switch(error)
	{
	case cudaErrorInvalidConfiguration:
		return gcnew CudaConfigurationException(gcnew String(cudaGetErrorString(error)), message);

	case cudaErrorInvalidHostPointer:  //fall-through
	case cudaErrorInvalidDevicePointer:
		return gcnew CudaInvalidPointerException(gcnew String(cudaGetErrorString(error)), message);

	case cudaErrorLaunchTimeout:
		return gcnew CudaLaunchTimeoutException(gcnew String(cudaGetErrorString(error)), message);

	case cudaErrorMemoryAllocation:
		return gcnew CudaOutOfMemoryException(gcnew String(cudaGetErrorString(error)), message);

	default:
		return gcnew CudaException(gcnew String(cudaGetErrorString(error)), message);
	}

}