#pragma once

#include "CostAggregateStereoNode.h"
#include "StereoNodeFactory.h"

// A basic wta solver implementation
class ShiftAggStereoNode : public CostAggregateStereoNode
{
protected:
	CostSpaceGrid interGrid;

public:
	ShiftAggStereoNode(cudaStream_t* stream) : CostAggregateStereoNode(stream) { }
	virtual ~ShiftAggStereoNode() { }

	virtual void AggregateCosts(RgbImage & leftIm, RgbImage & rightIm, CostSpaceGrid & costGrid);
	
#pragma region Parameters
private:
	// Parameters
	int boxFilterHalfSize;
	int minFilterHalfSize;
public:
	// Parameter setters
	void SetBoxFilterHalfSize(void* pn) { boxFilterHalfSize = *(int*)pn; }
	void SetMinFilterHalfSize(void* pn) { minFilterHalfSize = *(int*)pn; }
#pragma endregion
};

// Creates instances of WtaStereoNode
class ShiftAggStereoNodeFactory : public StereoNodeFactory<CostAggregateStereoNode>
{
public:
	// This aggregator only works for single-float cost spaces (not half-float ones)
	virtual void CheckValid(RgbImageType imageType, CostSpaceGridType gridType, DepthMapType mapType) 
	{ 
		isValid = (gridType == COST_SPACE_GRID_TYPE_ANY || gridType == COST_SPACE_GRID_TYPE_SINGLE); 
	}

	virtual CostAggregateStereoNode* Create(cudaStream_t* stream) const { return new ShiftAggStereoNode(stream); }
	virtual const char* GetName() const { return "Shiftable aggregation"; }
};