// $Id: ManagedUpsamplers.cpp 65 2010-03-18 17:06:22Z cr333 $
#include <assert.h>
#include "UnmanagedAggregators.h"
#include "UnmanagedUpsamplers.h"
#include "ManagedUpsamplers.h"

using namespace System::Drawing;
using namespace Stereo::GpGpuLib;

void ManagedUpsamplers::NnUpsample(DepthMap^ input, InputImage^ refImage, DepthMap^ output)
{
	GpuDepthMap* gpuIn = input->Get();
	GpuImage* gpuImg = refImage->Get();
	GpuDepthMap* gpuOut = output->Get();

	if(gpuImg->GetWidth() / gpuIn->GetWidth() != gpuImg->GetHeight() / gpuIn->GetHeight())
		throw gcnew Exception("The width and height do not match up for the same sampling factor");

	// Ensure that the output memory is of the correct size
	gpuOut->Create(gpuIn->GetType(), gpuImg->GetWidth(), gpuImg->GetHeight());

	RunNnKernel(gpuIn->Get(), gpuIn->GetPitch() / sizeof(unsigned int), gpuIn->GetWidth(), gpuIn->GetHeight(), gpuImg->GetWidth(), gpuImg->GetHeight(), 
		gpuImg->GetWidth() / gpuIn->GetWidth(), gpuOut->Get(), gpuOut->GetPitch() / sizeof(float));
}

void ManagedUpsamplers::JbUpsample(DepthMap^ input, InputImage^ refImage, float sigmaS, float sigmaC, DepthMap^ output)
{
	GpuDepthMap* gpuIn = input->Get();
	GpuImage* gpuImg = refImage->Get();
	GpuDepthMap* gpuOut = output->Get();

	// Ensure that the output memory is of the correct size
	gpuOut->Create(gpuIn->GetType(), gpuImg->GetWidth(), gpuImg->GetHeight());

	RunJbuKernel(gpuIn->Get(), gpuIn->GetPitch() / sizeof(float), gpuIn->GetWidth(), gpuIn->GetHeight(), 
		gpuImg->Get(), gpuImg->GetPitch() / sizeof(unsigned int), gpuImg->GetWidth(), gpuImg->GetHeight(), 
		sigmaS, sigmaC, gpuOut->Get(), gpuOut->GetPitch() / sizeof(float));
}

void ManagedUpsamplers::DcbUpsample(
    DepthMap^ input, int inputDisparities,
    InputImage^ leftImage, InputImage^ rightImage, CostSpace^ costSpace, InputImage^ tempGrid,
    DepthMap^ output, int outputDisparities,
    const float clipCosts, const float sigmaS, const float sigmaC, const unsigned int numInterations)
{
	GpuDepthMap*  gpuIn    = input->Get();
	GpuImage*     gpuImgL  = leftImage->Get();
	GpuImage*     gpuImgR  = rightImage->Get();
	GpuCostSpace* gpuCosts = costSpace->Get();
	GpuImage*     gpuGrid  = tempGrid->Get();
	GpuDepthMap*  gpuOut   = output->Get();

    assert(gpuIn != NULL && gpuImgL != NULL && gpuImgR != NULL && gpuCosts != NULL && gpuOut != NULL);
    assert(gpuImgL->GetWidth() == gpuImgR->GetWidth() && gpuImgL->GetHeight() == gpuImgR->GetHeight() && gpuImgL->GetPitch() == gpuImgR->GetPitch());

#ifdef UPSAMPLE_GROUND_TRUTH // FOR PAPER: upsample ground truth disparity map for comparison -----
	
	Bitmap^ groundTruth = gcnew Bitmap("..\\..\\..\\data\\teddy\\true.png");
	int outWidth = groundTruth->Width;
	int outHeight = groundTruth->Height;
	int inWidth = input->Width;
	int inHeight = input->Height;

	float* gtDisps = new float[inWidth * inHeight];

	for(int y = 0; y < inHeight; y++)
	{
		for(int x = 0; x < inWidth; x++)
		{
			gtDisps[inWidth * y + x] = groundTruth->GetPixel(
				int(float(x * outWidth) / inWidth),
				int(float(y * outHeight) / inHeight)).R / float(60 * 4);// / (outputDisparities / inputDisparities);
		}
	}

#endif // FOR PAPER: upsample ground truth disparity map for comparison ---------------------------

	// ensure that the output memory is of the correct size
	gpuOut->Create(gpuIn->GetType(), gpuImgL->GetWidth(), gpuImgL->GetHeight());
    gpuCosts->Create(COST_SPACE_TYPE_SINGLE, gpuImgL->GetWidth(), gpuImgL->GetHeight(), outputDisparities);

    unsigned int texWidth = 0, texHeight = 0;
    CalculateGridTextureSize(gpuImgL->GetWidth(), gpuImgL->GetHeight(), outputDisparities, sigmaS, sigmaC, texWidth, texHeight);
    gpuGrid->Create(IMAGE_TYPE_FLOAT2, texWidth, texHeight);

	RunDcbSuperResolution(
#ifdef UPSAMPLE_GROUND_TRUTH // FOR PAPER: upsample ground truth disparity map for comparison -----
		gtDisps, // <-- Paper: for upsampling ground truth disparity maps
#endif // FOR PAPER: upsample ground truth disparity map for comparison ---------------------------
        gpuIn->Get(), gpuIn->GetPitch(), gpuIn->GetWidth(), gpuIn->GetHeight(), inputDisparities,
        gpuImgL->Get(), gpuImgR->Get(), gpuImgL->GetPitch(), gpuCosts->Get(),
        (float2*)gpuGrid->Get(), gpuGrid->GetPitch(), gpuGrid->GetWidth(), gpuGrid->GetHeight(),
        gpuOut->Get(), gpuOut->GetPitch(), gpuOut->GetWidth(), gpuOut->GetHeight(), outputDisparities,
        clipCosts, sigmaS, sigmaC, numInterations);

#ifdef UPSAMPLE_GROUND_TRUTH // FOR PAPER: upsample ground truth disparity map for comparison -----
	delete gtDisps;
#endif // FOR PAPER: upsample ground truth disparity map for comparison ---------------------------
}