// $Id: ManagedDownsamplers.h 65 2010-03-18 17:06:22Z cr333 $
#pragma once

#include "InputImage.h"
#include "CostSpace.h"
#include "DepthMap.h"

namespace Stereo { namespace GpGpuLib {

public ref class ManagedDownsamplers
{
public:
	/// <summary>This method blurs individual cost space depth planes indepenedently</summary>
	/// <remarks>Prefer <see cref="DownsampleImage"/> instead if depth resolution is not critical</remarks>
	static void BlurCostSpaceLevels(CostSpace^ input, CostSpace^ temp, float sigma);

	/// <summary>This method downsamples individual cost space depth planes indepenedently</summary>
	/// <remarks>Prefer <see cref="DownsampleImage"/> instead if depth resolution is not critical</remarks>
	static void DownsampleCostSpace(CostSpace^ input, int scaleFactor, CostSpace^ output);

	static void DownsampleImage(InputImage^ input, int scaleFactor, InputImage^ output);
};

} }