// $Id: ManagedCostComputers.cpp 65 2010-03-18 17:06:22Z cr333 $
#include "UnmanagedCostComputers.h"
#include "ManagedCostComputers.h"

using namespace Stereo::GpGpuLib;

#define IMPLEMENT_COST_COMPUTATION_WRAPPER_SINGLE(FUNCTION_NAME, RUNNER_NAME)                           \
void ManagedCostComputers::FUNCTION_NAME(InputImage^ leftImage, InputImage^ rightImage,                 \
    int nDisparities, float costGradient, float costLimit, CostSpace^ costSpace,                        \
    ExecutionStream^ stream)                                                                            \
{                                                                                                       \
    GpuImage* gpuLeft = leftImage->Get();                                                               \
    GpuImage* gpuRight = rightImage->Get();                                                             \
    GpuCostSpace* gpuCost = costSpace->Get();                                                           \
                                                                                                        \
    /* Ensure the cost space is of the correct dimensions */                                            \
    gpuCost->Create(COST_SPACE_TYPE_SINGLE, gpuLeft->GetWidth(), gpuLeft->GetHeight(), nDisparities);   \
                                                                                                        \
    /* Compute the cost space */                                                                        \
    RUNNER_NAME(                                                                                        \
        gpuLeft->Get(), gpuRight->Get(), gpuLeft->GetPitch() / sizeof(unsigned int),                    \
        gpuLeft->GetWidth(), gpuLeft->GetHeight(), gpuCost->GetDepth(),                                 \
        costGradient, costLimit, gpuCost->Get());                                                       \
}

IMPLEMENT_COST_COMPUTATION_WRAPPER_SINGLE(RunSadKernel,        RunCostSpaceSadKernel);
IMPLEMENT_COST_COMPUTATION_WRAPPER_SINGLE(RunMadKernel,        RunCostSpaceMadKernel);

IMPLEMENT_COST_COMPUTATION_WRAPPER_SINGLE(RunCrAdKernel,       RunCostSpaceCrAdKernel);
IMPLEMENT_COST_COMPUTATION_WRAPPER_SINGLE(RunCrSdKernel,       RunCostSpaceCrSdKernel);

// clean up
#undef IMPLEMENT_COST_COMPUTATION_WRAPPER_SINGLE