function SimilarityMatrix = similarityTemporal( x, sigma, range, mask)
%SIMILARITYTEMPORAL Summary of this function goes here
%   Detailed explanation goes here
% get the euclidean distance for each pair
inds = [1:size(x,1)]';
Distances = exp(-pdist(inds)/sigma); % 4 best so far

SimilarityMatrix = squareform(Distances);

% invalidate the illegal values from the mask (if at least one element is
% not present in the mask set similarity to 0)
if(numel(mask) ~= 0)
    invalidInds = sum(mask(:,range),2) < numel(range);

    SimilarityMatrix(invalidInds,:) = 0;
    SimilarityMatrix(:,invalidInds) = 0;
end

SimilarityMatrix = SimilarityMatrix + eye(size(x, 1));

end

