function [alphasGradient, betasGradient] = gradientAnalytical(Similarities, alphas, betas, lambda, x, y, mask)
%-------------------------------------------------------------------------
% Description: Analytic gradient for CCRF
%-------------------------------------------------------------------------

    % dL(theta)/dlog(alpha_k) 
    %       = alpha_k * dL(theta)/dalpha_k
    %       = alpha_k * (L(alpha_k+epsilon) - L(alpha_k-epsilon)) / (2*epsilon)
    epsilon = 1e-5;
    K = numel(alphas);
    alphasGradient = zeros(size(alphas));
    for i = 1:K    
        epsilonVec = zeros(K,1);
        epsilonVec(i) = epsilon;

        alphasGradient(i) = (LogLikelihoodCCRF({y},{x},{mask},alphas+epsilonVec, betas, lambda, {Similarities}) - ...
                      LogLikelihoodCCRF({y},{x},{mask},alphas-epsilonVec, betas, lambda, {Similarities})) / (2 * epsilon);
    end
    
    alphasGradient = alphas .* alphasGradient;
    
    K2 = numel(betas);
    betasGradient = zeros(size(alphas));
    for i=1:K2
        epsilonVec = zeros(K2,1);
        epsilonVec(i) = epsilon;

        betasGradient(i) = (LogLikelihoodCCRF({y},{x},{mask},alphas, betas + epsilonVec, lambda, {Similarities}) - ...
                          LogLikelihoodCCRF({y},{x},{mask},alphas, betas - epsilonVec, lambda, {Similarities})) / (2 * epsilon);
    end
    
    betasGradient = betas .* betasGradient;
end