structure Calibrate : Calibrate =
struct

(* ------------------------------------------------------------------------- *)
(* Calibrate QepcadB and Mathematica for machine learning timing.            *)
(* ------------------------------------------------------------------------- *)

fun calibrate_eadms n =
    (print ("\n ------------------------------------------------------------------------- \n");
     print ("  Calibrating average initialisation CPU time for QepcadB and Mathematica \n");
     print (" ------------------------------------------------------------------------- \n");
     print (" - # Samples to be taken for each tool: " ^ (Int.toString n) ^ ".\n");
     print (" - Sampling QepcadB: ");
     let val (q_ave, q_std, q_bcd) = Qepcad.calibrate n in
	 (print ("...\n   QepcadB ave.: " ^ (Time.fmt 5 q_ave) ^ " sec.\n");
	  print      ("   QepcadB std.: " ^ (Time.fmt 5 q_std) ^ " sec.\n");
	  print      ("   QepcadB bcd.: " ^ (Time.fmt 5 q_bcd) ^ " sec.\n"))
     end;
     print (" - Sampling Mathmca: ");
     let val (m_ave, m_std, m_bcd) = Mathematica.calibrate n in
	 (print ("...\n   Mathmca ave.: " ^ (Time.fmt 5 m_ave) ^ " sec.\n");
	  print      ("   Mathmca std.: " ^ (Time.fmt 5 m_std) ^ " sec.\n");
	  print      ("   Mathmca bcd.: " ^ (Time.fmt 5 m_bcd) ^ " sec.\n"))
     end;
     print (" ------------------------------------------------------------------------- \n\n"));



end;
