(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

open HolKernel boolLib bossLib pred_setTheory pairTheory relationTheory
open res_quanTheory arithmeticTheory optionTheory;

val _ = new_theory "util";

val is_permutation_def = Define `
  is_permutation xlist xset =
    (set xlist = xset) /\ (ALL_DISTINCT xlist)`;

val PAIR_RES_FORALL_THM = Q.store_thm ("PAIR_RES_FORALL_THM",
`!P f. RES_FORALL P f = !x y. (x, y) IN P ==> f (x, y)`,
SRW_TAC [] [RES_FORALL_THM] THEN
EQ_TAC THEN
SRW_TAC [] [] THEN
Cases_on `x` THEN
SRW_TAC [] []);

val PAIR_APP_THM = Q.store_thm ("PAIR_APP_THM",
`!f x y. (\(x, y). f x y) (x, y) = f x y`,
SRW_TAC [] []);

val PAIR_GSPEC_ID = Q.store_thm ("PAIR_GSPEC_ID",
`!s. {(x,y) | (x,y) IN s} = s`,
SRW_TAC [] [EXTENSION, GSPECIFICATION] THEN 
EQ_TAC THEN
SRW_TAC [] [SPECIFICATION] THENL
[Cases_on `x'` THEN 
     FULL_SIMP_TAC (srw_ss()) [],
 Q.EXISTS_TAC `x` THEN
     Cases_on `x` THEN
     SRW_TAC [] []]);

val CURRY_EMPTY = Q.store_thm ("CURRY_EMPTY",
`CURRY {} = \x. \y. F`,
SRW_TAC [] [FUN_EQ_THM, CURRY_DEF] THEN
METIS_TAC [SPECIFICATION, EMPTY_DEF]);

val TC_EMPTY = Q.store_thm ("TC_EMPTY",
`TC (\x y. F) = \x y. F`,
SRW_TAC [] [FUN_EQ_THM, TC_DEF] THEN
Q.EXISTS_TAC `\x y. F` THEN
SRW_TAC [] []);

val CARD_EQ_SUC = Q.store_thm ("CARD_EQ_SUC",
`!s. FINITE s ==> !n. (CARD s = SUC n) ==> ~(s = {})`,
SRW_TAC [] [] THEN
CCONTR_TAC THEN
FULL_SIMP_TAC (srw_ss()) []);

val COND_EXPAND_EQ = Q.store_thm ("COND_EXPAND_EQ",
`!b t1 t2 v. ((if b then t1 else t2) = v) = (b /\ (t1 = v)) \/ (~b /\ (t2 = v))`,
METIS_TAC []);

val _ = export_theory ();
