(*        x86-TSO Semantics: HOL sources                                *)
(*                                                                      *)
(* Scott Owens, Susmit Sarkar, Peter Sewell                             *)
(*                                                                      *)
(*  Computer Laboratory, University of Cambridge                        *)
(*                                                                      *)
(*  Copyright 2007-2009                                                 *)
(*                                                                      *)
(* Redistribution and use in source and binary forms, with or without   *)
(* modification, are permitted provided that the following conditions   *)
(* are met:                                                             *)
(*                                                                      *)
(* 1. Redistributions of source code must retain the above copyright    *)
(*    notice, this list of conditions and the following disclaimer.     *)
(* 2. Redistributions in binary form must reproduce the above copyright *)
(*    notice, this list of conditions and the following disclaimer in   *)
(*    the documentation and/or other materials provided with the        *)
(*    distribution.                                                     *)
(* 3. The names of the authors may not be used to endorse or promote    *)
(*    products derived from this software without specific prior        *)
(*    written permission.                                               *)
(*                                                                      *)
(* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS   *)
(* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *)
(* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *)
(* ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY      *)
(* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *)
(* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *)
(* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *)
(* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *)
(* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *)
(* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *)
(* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *)
(* 
app load ["utilLib", "linear_valid_executionTheory", "lts_memory_modelTheory", 
          "pathTheory", "lts_traceTheory", "HolDoc"];
use "lts_axiomatic_equivScript.sml";
*)

open HolKernel boolLib Parse bossLib wordsTheory pred_setTheory pathTheory;
open optionTheory arithmeticTheory listTheory prim_recTheory llistTheory;
open combinTheory;
open utilLib utilTheory set_relationTheory;
open axiomatic_memory_modelTheory lts_memory_modelTheory basic_lemmasTheory;
open linear_valid_executionTheory lts_traceTheory;

open HolDoc;
val _ = new_theory "lts_axiomatic_equiv";

val UNION_LEM = Q.prove (
`!P Q. { x | P x \/ Q x } = {x | P x} UNION {x | Q x}`,
RWTAC [EXTENSION]);

val INTER_LEM = Q.prove (
`!P Q. { x | P x /\ Q x } = {x | P x} INTER {x | Q x}`,
RWTAC [EXTENSION]);

val per_disj = Q.prove (
`!r s s1 s2 x y. per s r /\ s1 IN r /\ s2 IN r /\ s1 <> s2 /\ x IN s1 ==> x NOTIN s2`,
RWTAC [per_def, EXTENSION, DISJOINT_DEF] THEN
METIS_TAC []);

val get_mem_event_def = Define `
(get_mem_event (TauEvt e) = SOME e) /\
(get_mem_event (REvt e _) = 
       if is_mem_access e then
         SOME e
       else
         NONE) /\
(get_mem_event _ = NONE)`;

val path_to_X_def = Define `
path_to_X path =
  <| memory_order :=
       { (e1, e2) | 
           ?j i l1 l2.
             j + 1 IN PL path /\ i <= j /\ 
             (nth_label i path = l1) /\ (nth_label j path = l2) /\
             (get_mem_event l1 = SOME e1) /\ (get_mem_event l2 = SOME e2) };
     rfmap := { (ew, er) | (ew, er) | ?i. i + 1 IN PL path /\ (nth_label i path = REvt er (SOME ew)) };
     initial_state := evt_machine_state_to_state_constraint (first path) |>`;

val lem01 = Q.prove (
`!i j. (j + 1 IN PL path /\ i <= j ==> i + 1 IN PL path) /\
       (j + 1 IN PL path /\ i < j ==> i + 1 IN PL path)`,
RWTAC [] THEN
`i + 1 < j + 1 \/ (i = j)` by DECIDE_TAC THEN
METIS_TAC [PL_downward_closed]);

val lem06 = Q.prove (
`!E X e1 e2.
  linear_valid_execution E X /\
  (e1, e2) IN X.memory_order
  ==>
  e1 IN mem_accesses E /\
  e2 IN mem_accesses E`,
RWTAC [linear_valid_execution_def, linear_order_def, domain_def, range_def,
       SUBSET_DEF] THEN
METIS_TAC []);

val eplem01 = Q.prove (
`!E path i e. okEpath E path /\ i + 1 IN PL path /\ (nth_label i path = WEvt e) ==> e IN E.events`,
RWTAC [okEpath_def] THEN
METIS_TAC [get_orig_event_def]);

val eplem02 = Q.prove (
`!E path i e1 e2. okEpath E path /\ i + 1 IN PL path /\ (nth_label i path = REvt e1 e2) ==> e1 IN E.events`,
RWTAC [okEpath_def] THEN
METIS_TAC [get_orig_event_def]);

val eplem03 = Q.prove (
`!E path i j e. 
  okEpath E path /\ 
  i + 1 IN PL path /\ 
  j + 1 IN PL path /\ 
  (get_orig_event (nth_label i path) = SOME e) /\
  (get_orig_event (nth_label j path) = SOME e)
  ==>
  (i = j)`,
RWTAC [okEpath_def] THEN
METIS_TAC []);

val eplem04 = Q.prove (
`!E path e.
  okEpath E path /\
  e IN mem_accesses E
  ==>
  ?i. i + 1 IN PL path /\ (get_orig_event (nth_label i path) = SOME e)`,
RWTAC [okEpath_def, mem_accesses_def, EXTENSION] THEN
METIS_TAC []);

val eplem05 = Q.prove (
`!E path e.
  okEpath E path /\
  e IN E.events
  ==>
  ?i. i + 1 IN PL path /\ (get_orig_event (nth_label i path) = SOME e)`,
RWTAC [okEpath_def, mem_writes_def, EXTENSION] THEN
METIS_TAC []);

val eplem06 = Q.prove (
`!E path e1 e2.
  okEpath E path /\
  (e1, e2) IN po_iico E
  ==>
  ?i j. 
    j + 1 IN PL path /\ 
    i < j /\ 
    (get_orig_event (nth_label i path) = SOME e1) /\
    (get_orig_event (nth_label j path) = SOME e2)`,
RWTAC [okEpath_def] THEN
METIS_TAC []);

val eplem07 = Q.prove (
`!E path es i j e1 e2.
  well_formed_event_structure E /\
  okEpath E path /\
  j + 1 IN PL path /\
  i < j /\
  (get_orig_event (nth_label i path) = SOME e1) /\
  (get_orig_event (nth_label j path) = SOME e2) /\
  es IN E.atomicity /\
  e1 IN es /\
  e2 NOTIN es /\
  e1 IN mem_accesses E /\
  e2 IN mem_accesses E /\
  (proc e1 = proc e2)
  ==>
  ?k es'. i < k /\ k < j /\ (nth_label k path = UnlockE (proc e1) es')`,
RWTAC [okEpath_def] THEN
Q.PAT_ASSUM `!es. es IN E.atomicity ==> P es` (MP_TAC o Q.SPEC `es`) THEN
RWTAC [locked_segment_def] THEN
FSTAC [] THEN
RWTAC [] THEN
`e1 IN {e | ?k. i' < k /\ k < j' /\ 
                (get_orig_event (nth_label k path) = SOME e) /\ 
                e IN mem_accesses E /\ (proc e = p)}` 
           by (FSTAC [EXTENSION] THEN
               METIS_TAC []) THEN
`e2 NOTIN {e | ?k. i' < k /\ k < j' /\ 
                (get_orig_event (nth_label k path) = SOME e) /\ 
                e IN mem_accesses E /\ (proc e = p)}` 
           by (FSTAC [EXTENSION] THEN
               METIS_TAC []) THEN
FSTAC [] THEN
IMP_RES_TAC lem01 THEN
`i = k` by METIS_TAC [eplem03] THEN
RWTAC [] THEN
Q.EXISTS_TAC `j'` THEN
RWTAC [] THEN
`(j' < j) \/ (j' = j)` by METIS_TAC [LESS_TRANS, DECIDE ``!x y:num. (x = y) \/ x < y \/ y < x``] THEN
RWTAC [] THEN
FSTAC [get_orig_event_def]);

val eplem08 = Q.prove (
`!E path es i j e1 e2.
  well_formed_event_structure E /\
  okEpath E path /\
  j + 1 IN PL path /\
  i < j /\
  (get_orig_event (nth_label i path) = SOME e1) /\
  (get_orig_event (nth_label j path) = SOME e2) /\
  es IN E.atomicity /\
  e1 NOTIN es /\
  e2 IN es /\
  e1 IN mem_accesses E /\
  e2 IN mem_accesses E /\
  (proc e1 = proc e2)
  ==>
  ?k es'. i < k /\ k < j /\ (nth_label k path = LockE (proc e1) es')`,
RWTAC [okEpath_def] THEN
Q.PAT_ASSUM `!es. es IN E.atomicity ==> P es` (MP_TAC o Q.SPEC `es`) THEN
RWTAC [locked_segment_def] THEN
FSTAC [] THEN
RWTAC [] THEN
`e1 NOTIN {e | ?k. i' < k /\ k < j' /\ 
                (get_orig_event (nth_label k path) = SOME e) /\ 
                e IN mem_accesses E /\ (proc e = p)}` 
           by (FSTAC [EXTENSION] THEN
               METIS_TAC []) THEN
`e2 IN {e | ?k. i' < k /\ k < j' /\ 
                (get_orig_event (nth_label k path) = SOME e) /\ 
                e IN mem_accesses E /\ (proc e = p)}` 
           by (FSTAC [EXTENSION] THEN
               METIS_TAC []) THEN
FSTAC [] THEN
IMP_RES_TAC lem01 THEN
`j = k` by METIS_TAC [eplem03] THEN
RWTAC [] THEN
Q.EXISTS_TAC `i'` THEN
RWTAC [] THEN
`(i < i') \/ (i' = i)` by METIS_TAC [LESS_TRANS, DECIDE ``!x y:num. (x = y) \/ x < y \/ y < x``] THEN
RWTAC [] THEN
FSTAC [get_orig_event_def]);

val eplem09 = Q.prove (
`!E path es e.
  okEpath E path /\
  es IN E.atomicity /\
  e IN mem_accesses E /\
  e IN es
  ==>
  ?i j. locked_segment path i j (proc e) /\
        (es INTER mem_accesses E = 
         {e' | ?k. i < k /\ k < j /\ (get_orig_event (nth_label k path) = SOME e') /\
                   e' IN mem_accesses E /\ (proc e' = proc e)})`,
RWTAC [okEpath_def, EXTENSION] THEN
RES_TAC THEN
FSTAC [] THEN
MAP_EVERY Q.EXISTS_TAC [`i`, `j`] THEN
RWTAC [] THEN
METIS_TAC []);

val eplem10 = Q.prove (
`!E path. okEpath E path ==> no_dup_writes path`,
RWTAC [okEpath_def, no_dup_writes_def] THEN
Q.PAT_ASSUM `!i j e2. P i j e2 ==> (i = j)` MATCH_MP_TAC THEN
Q.EXISTS_TAC `ew` THEN
RWTAC [GSYM ADD1, get_orig_event_def]);

val pathlem01 = Q.prove (
`!E path i j e.
  okEpath E path /\
  okMpath path /\
  i + 1 IN PL path /\
  j + 1 IN PL path /\
  (get_mem_event (nth_label i path) = SOME e) /\
  (get_mem_event (nth_label j path) = SOME e)
  ==>
  (i = j)`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
Cases_on `nth_label j path` THEN
FSTAC [get_mem_event_def, COND_EXPAND_EQ] THEN
RWTAC [] THENL
[STRIP_ASSUME_TAC (DECIDE ``(i:num = j) \/ (i < j) \/ (j < i)``) THENL
     [MP_TAC (Q.SPECL [`path`, `i`, `j`, `e`, `e`] tau_ordered_source),
      MP_TAC (Q.SPECL [`path`, `j`, `i`, `e`, `e`] tau_ordered_source)] THEN
     RWTAC [] THEN
     IMP_RES_TAC lem01 THEN
     METIS_TAC [eplem03, get_orig_event_def, DECIDE ``!x y:num. x < y ==> x <> y``],
 MAP_EVERY IMP_RES_TAC [lem01, tau_source] THEN
     METIS_TAC [revt_read, wevt_write, action_11, dirn_distinct],
 MAP_EVERY IMP_RES_TAC [lem01, tau_source] THEN
     METIS_TAC [revt_read, wevt_write, action_11, dirn_distinct],
 METIS_TAC [get_orig_event_def, eplem03]]);

val pathlem02 = Q.prove (
`!E path er i.
  okMpath path /\
  er IN mem_reads E /\
  i + 1 IN PL path /\
  (get_orig_event (nth_label i path) = SOME er)
  ==>
  (?e. nth_label i path = REvt er e)`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_orig_event_def, mem_reads_def] THEN
METIS_TAC [wevt_write, bevt_barrier, action_11, dirn_distinct, action_distinct]);

val pathlem03 = Q.prove (
`!E path ew i.
  okMpath path /\
  ew IN mem_writes E /\
  i + 1 IN PL path /\
  (get_orig_event (nth_label i path) = SOME ew)
  ==>
  (?j. j + 1 IN PL path /\ i < j /\ (nth_label j path = TauEvt ew))`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_orig_event_def, mem_writes_def] THENL
[METIS_TAC [revt_read, dirn_distinct, action_11],
 METIS_TAC [tau_fairness, is_mem_access_def],
 METIS_TAC [bevt_barrier, action_distinct]]);

val pathlem05 = Q.prove (
`!E path er i.
  okMpath path /\
  er IN mem_reads E /\
  i + 1 IN PL path /\
  (get_orig_event (nth_label i path) = SOME er)
  ==>
  (get_mem_event (nth_label i path) = SOME er)`,
RWTAC [] THEN
IMP_RES_TAC pathlem02 THEN
RWTAC [get_mem_event_def] THEN
FSTAC [mem_reads_def, is_mem_access_def]);

val pathlem04 = Q.prove (
`!E path e i.
  okMpath path /\
  e IN mem_accesses E /\
  i + 1 IN PL path /\
  (get_orig_event (nth_label i path) = SOME e)
  ==>
  (?j. j + 1 IN PL path /\ i <= j /\ (get_mem_event (nth_label j path) = SOME e))`,
RWTAC [mem_access_lem01] THEN
Cases_on `e IN mem_writes E` THEN1 
METIS_TAC [pathlem03, get_mem_event_def, LESS_IMP_LESS_OR_EQ] THEN
Cases_on `e IN mem_reads E` THEN1 
METIS_TAC [pathlem02, get_mem_event_def, LESS_EQ_REFL] THEN
FSTAC [mem_writes_def, mem_reads_def, mem_accesses_def] THENL
[METIS_TAC [],
 METIS_TAC [],
 METIS_TAC [],
 FSTAC [is_mem_access_def] THEN
     Cases_on `d` THEN
     FSTAC []]);

val pathlem06 = Q.prove (
`!E path ew i.
  okMpath path /\
  ew IN mem_writes E /\
  i + 1 IN PL path /\
  (get_orig_event (nth_label i path) = SOME ew)
  ==>
  (nth_label i path = WEvt ew)`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_orig_event_def, mem_writes_def] THEN
METIS_TAC [revt_read, bevt_barrier, action_11, dirn_distinct, action_distinct]);

val pathlem07 = Q.prove (
`!E path ef i.
  okMpath path /\
  ef IN mfences E /\
  i + 1 IN PL path /\
  (get_orig_event (nth_label i path) = SOME ef)
  ==>
  (nth_label i path = BEvt ef)`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_orig_event_def, mfences_def] THEN
METIS_TAC [revt_read, wevt_write, action_11, dirn_distinct, action_distinct]);

val pathlem08 = Q.prove (
`!E path i er ew.
  okEpath E path /\
  okMpath path /\
  i + 1 IN PL path /\
  (nth_label i path = REvt er (SOME ew))
  ==>
  ew IN writes E`,
RWTAC [] THEN
IMP_RES_TAC eplem10 THEN
MP_TAC (Q.SPECL [`path`, `i`, `er`, `ew`] read_from_write) THEN
RWTAC [] THEN
IMP_RES_TAC lem01 THEN
IMP_RES_TAC tau_source THEN
IMP_RES_TAC lem01 THEN
IMP_RES_TAC wevt_write THEN
RWTAC [writes_def] THEN
METIS_TAC [eplem01]);

val pathlem09 = Q.prove (
`!E path i j er ew.
  okEpath E path /\
  okMpath path /\ 
  i + 1 IN PL path /\
  j + 1 IN PL path /\
  (nth_label i path = REvt er ew) /\
  (get_mem_event (nth_label j path) = SOME er)
  ==>
  (i = j)`,
RWTAC [] THEN
Cases_on `nth_label j path` THEN
FSTAC [get_mem_event_def] THEN
RWTAC [] THENL
[MAP_EVERY IMP_RES_TAC [revt_read, tau_source, lem01, wevt_write] THEN
     FSTAC [],
 FSTAC [COND_EXPAND_EQ] THEN
     METIS_TAC [pathlem01, get_mem_event_def]]);

val pathlem10 = Q.prove (
`!E path i ew.
  okMpath path /\ 
  i + 1 IN PL path /\
  (get_mem_event (nth_label i path) = SOME ew) /\
  ew IN writes E
  ==>
  (nth_label i path = TauEvt ew)`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_mem_event_def] THEN
RWTAC [] THEN
FSTAC [COND_EXPAND_EQ] THEN
RWTAC [] THEN
IMP_RES_TAC revt_read THEN
FSTAC [writes_def]);

val pathlem11 = Q.prove (
`!E path i er.
  okMpath path /\
  i + 1 IN PL path /\
  (get_mem_event (nth_label i path) = SOME er) /\
  er IN reads E
  ==>
  (?ew_opt. nth_label i path = REvt er ew_opt) /\
  is_mem_access er`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_mem_event_def] THEN
RWTAC [] THEN
FSTAC [COND_EXPAND_EQ] THEN
RWTAC [] THEN
IMP_RES_TAC tau_source THEN
IMP_RES_TAC lem01 THEN
IMP_RES_TAC wevt_write THEN
FSTAC [reads_def]);

val pathlem12 = Q.prove (
`!E path er i.
  okMpath path /\
  er IN reads E /\
  i + 1 IN PL path /\
  (get_orig_event (nth_label i path) = SOME er)
  ==>
  (?e. nth_label i path = REvt er e)`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_orig_event_def, reads_def] THEN
METIS_TAC [wevt_write, bevt_barrier, action_11, dirn_distinct, action_distinct]);

val pathlem13 = Q.prove (
`!E path ew i.
  okMpath path /\
  ew IN writes E /\
  i + 1 IN PL path /\
  (get_orig_event (nth_label i path) = SOME ew)
  ==>
  (nth_label i path = WEvt ew)`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_orig_event_def, writes_def] THEN
METIS_TAC [revt_read, bevt_barrier, action_11, dirn_distinct, action_distinct]);

val pathlem14 = Q.prove (
`!E path ew i j.
  okEpath E path /\
  okMpath path /\
  i + 1 IN PL path /\
  j + 1 IN PL path /\
  (nth_label j path = TauEvt ew) /\
  (nth_label i path = WEvt ew)
  ==>
  (i < j)`,
RWTAC [] THEN
IMP_RES_TAC tau_source THEN
IMP_RES_TAC lem01 THEN
METIS_TAC [eplem03, get_orig_event_def]);

val pathlem15 = Q.prove (
`!E path e1 e2.
  well_formed_event_structure E /\
  okEpath E path /\
  okMpath path /\
  (e1, e2) IN po_iico E /\
  ((e1 IN mem_reads E /\ e2 IN mem_accesses E) \/
   (e1 IN mem_writes E /\ e2 IN mem_writes E))
  ==>
  (e1, e2) IN (path_to_X path).memory_order`,
RWTAC [path_to_X_def] THEN
     `?i j. 
        j + 1 IN PL path /\ i < j /\
        (get_orig_event (nth_label i path) = SOME e1) /\
        (get_orig_event (nth_label j path) = SOME e2)`
                by METIS_TAC [eplem06] THEN
     IMP_RES_TAC lem01 THENL
[METIS_TAC [pathlem05, pathlem04, DECIDE ``!x y z:num. x < y /\ y <= z ==> x <= z``],
 `is_mem_access e1 /\ is_mem_access e2` by FSTAC [mem_writes_def, is_mem_access_def] THEN
     METIS_TAC [get_mem_event_def, LESS_IMP_LESS_OR_EQ, pathlem06, tau_ordered_fairness, wfes_proc, eplem10]]);

val pathlem16 = Q.prove (
`!E path i j k l e. 
  okEpath E path /\
  okMpath path /\
  locked_segment path i j (proc e) /\
  i < k /\
  k < j /\
  (get_orig_event (nth_label k path) = SOME e) /\
  l + 1 IN PL path /\
  (get_mem_event (nth_label l path) = SOME e)
  ==>
  i < l /\ l < j`,
RWTAC [] THEN
Cases_on `nth_label k path` THEN
FSTAC [get_orig_event_def, COND_EXPAND_EQ] THEN
RWTAC [] THEN
`k + 1 IN PL path` by METIS_TAC [locked_segment_def, lem01] THENL
[`k = l` by METIS_TAC [pathlem09] THEN
     FSTAC [get_mem_event_def],
 Cases_on `nth_label l path` THEN
     FSTAC [get_mem_event_def, COND_EXPAND_EQ] THENL
     [METIS_TAC [LESS_TRANS, pathlem14],
      MAP_EVERY IMP_RES_TAC [wevt_write, revt_read] THEN
          RWTAC [] THEN
          FSTAC []],
 Cases_on `nth_label l path` THEN
     FSTAC [get_mem_event_def, COND_EXPAND_EQ] THEN
     MAP_EVERY IMP_RES_TAC [tau_source, bevt_barrier, revt_read] THEN
     FSTAC [is_mem_access_def] THEN
     RWTAC [] THEN
     FSTAC [],
 `k = l` by METIS_TAC [pathlem09] THEN
     FSTAC [get_mem_event_def],
 Cases_on `nth_label l path` THEN
     FSTAC [get_mem_event_def, COND_EXPAND_EQ] THENL
     [`is_mem_access e` by METIS_TAC [tau_source] THEN
          `?k. i < k /\ k < j /\ (nth_label k path = TauEvt e)` by METIS_TAC [lock_wevt_tau] THEN
          `k' + 1 IN PL path` by METIS_TAC [locked_segment_def, lem01] THEN
          METIS_TAC [pathlem01, get_mem_event_def],
      MAP_EVERY IMP_RES_TAC [wevt_write, revt_read] THEN
          RWTAC [] THEN
          FSTAC []],
 Cases_on `nth_label l path` THEN
     FSTAC [get_mem_event_def, COND_EXPAND_EQ] THEN
     MAP_EVERY IMP_RES_TAC [tau_source, bevt_barrier, revt_read] THEN
     FSTAC [is_mem_access_def] THEN
     RWTAC [] THEN
     FSTAC []]);

val pathlem17 = Q.prove (
`!E path i j k l e. 
  okEpath E path /\
  okMpath path /\
  locked_segment path i j (proc e) /\
  i < k /\
  k < j /\
  (get_mem_event (nth_label k path) = SOME e) /\
  l + 1 IN PL path /\
  (get_orig_event (nth_label l path) = SOME e)
  ==>
  i < l /\ l < j`,
RWTAC [] THEN
Cases_on `nth_label k path` THEN
FSTAC [get_mem_event_def, COND_EXPAND_EQ] THEN
RWTAC [] THEN
`k + 1 IN PL path` by METIS_TAC [locked_segment_def, lem01] THENL
[Cases_on `nth_label l path` THEN
     FSTAC [get_orig_event_def, COND_EXPAND_EQ] THENL
     [IMP_RES_TAC tau_source THEN
          MAP_EVERY IMP_RES_TAC [lem01, wevt_write, revt_read] THEN
          RWTAC [] THEN
          FSTAC [],
      `is_mem_access e` by METIS_TAC [tau_source] THEN
          `?k. i < k /\ k < j /\ (nth_label k path = WEvt e)` by METIS_TAC [lock_wevt_tau] THEN
          `k' + 1 IN PL path` by METIS_TAC [locked_segment_def, lem01] THEN
          METIS_TAC [eplem03, get_orig_event_def],
      MAP_EVERY IMP_RES_TAC [tau_source, bevt_barrier] THEN
          FSTAC [is_mem_access_def] THEN
          RWTAC [] THEN
          FSTAC []],
 METIS_TAC [eplem03, get_orig_event_def],
 Cases_on `nth_label l path` THEN
     FSTAC [get_orig_event_def, COND_EXPAND_EQ] THENL
     [MAP_EVERY IMP_RES_TAC [tau_source] THEN
          MAP_EVERY IMP_RES_TAC [lem01, wevt_write, revt_read] THEN
          RWTAC [] THEN
          FSTAC [],
      METIS_TAC [LESS_TRANS, pathlem14],
      MAP_EVERY IMP_RES_TAC [tau_source, bevt_barrier] THEN
          FSTAC [is_mem_access_def] THEN
          RWTAC [] THEN
          FSTAC []],
 METIS_TAC [eplem03, get_orig_event_def]]);

val pathlem18 = Q.prove (
`!E path i e.
  okMpath path /\
  i + 1 IN PL path /\
  (get_mem_event (nth_label i path) = SOME e)
  ==>
  ?j. j <= i /\ (get_orig_event (nth_label j path) = SOME e)`,
RWTAC [] THEN
Cases_on `nth_label i path` THEN
FSTAC [get_mem_event_def, COND_EXPAND_EQ] THENL
[METIS_TAC [tau_source, get_orig_event_def, LESS_IMP_LESS_OR_EQ],
 METIS_TAC [LESS_EQ_REFL, get_orig_event_def]]);

val TAC = 
`y IN E.events` by METIS_TAC [eplem02] THEN
`(y, x) NOTIN po_iico E` 
         by (CCONTR_TAC THEN
             FSTAC [] THEN
             IMP_RES_TAC eplem06 THEN
             IMP_RES_TAC lem01 THEN
             `(i = i'') /\ (i' = j)` 
                   by METIS_TAC [eplem03, get_orig_event_def, LESS_EQ_REFL] THEN
             RWTAC [] THEN
             DECIDE_TAC) THEN
Cases_on `x.iiid.poi = y.iiid.poi` THEN
RWTAC [po_iico_def, po_strict_def] THENL
[`x.iiid = y.iiid` 
        by (Cases_on `x.iiid` THEN
            Cases_on `y.iiid` THEN
            RWTAC [] THEN
            FSTAC [proc_def]) THEN
     `y IN reads E`
              by (RWTAC [reads_def] THEN
                  METIS_TAC [revt_read]) THEN
     FSTAC [po_iico_def, well_formed_event_structure_def] THEN
     METIS_TAC [events_disj],
 CCONTR_TAC THEN 
     FSTAC [] THENL
     [METIS_TAC [proc_def],
     `y.iiid.poi < x.iiid.poi` by DECIDE_TAC THEN
          FSTAC [po_iico_def, po_strict_def, proc_def] THENL
          [METIS_TAC [],
           METIS_TAC [],
           FSTAC [writes_def]],
      FSTAC [writes_def]]];

val machine_is_valid = Q.store_thm  ("machine_is_valid",
`!E path.
  well_formed_event_structure E /\
  okEpath E path /\ 
  okMpath path
  ==>
  linear_valid_execution E (path_to_X path)`,
RWTAC [linear_valid_execution_def] THENL
[RWTAC [linear_order_def, transitive_def, antisym_def,
        domain_def, range_def, path_to_X_def, SUBSET_DEF] THENL
     [Cases_on `nth_label i path` THEN
          FSTAC [get_mem_event_def, mem_access_lem01, COND_EXPAND_EQ] THEN
          METIS_TAC [lem01, tau_source, eplem01, eplem02],
      Cases_on `nth_label j path` THEN
          FSTAC [get_mem_event_def, mem_access_lem01, COND_EXPAND_EQ] THEN
          METIS_TAC [lem01, tau_source, eplem01, eplem02],
      IMP_RES_TAC lem01 THEN
          METIS_TAC [pathlem01, LESS_EQ_TRANS],
      IMP_RES_TAC lem01 THEN
          METIS_TAC [pathlem01, LESS_EQUAL_ANTISYM, SOME_11],
      METIS_TAC [eplem04, pathlem04, LESS_EQ_REFL, LESS_EQ_CASES]],
 RWTAC [finite_prefixes_def, path_to_X_def] THEN
     Cases_on `?j. j + 1 IN PL path /\ (get_mem_event (nth_label j path) = SOME e)` THEN
     FSTAC [] THENL
     [`{e' | ?j i. j + 1 IN PL path /\ i <= j /\ 
                   (get_mem_event (nth_label i path) = SOME e') /\ 
                   (get_mem_event (nth_label j path) = SOME e)}
       SUBSET
       IMAGE (\n. THE (get_mem_event (nth_label n path))) (count (j+1))`
                 by (RWTAC [SUBSET_DEF, IN_COUNT, DECIDE ``!x y. x < y + 1 = x <= y``] THEN
                     METIS_TAC [THE_DEF, pathlem01]) THEN
          METIS_TAC [IMAGE_FINITE, SUBSET_FINITE, FINITE_COUNT],
      `{e' | ?j i. j + 1 IN PL path /\ i <= j /\
                   (get_mem_event (nth_label i path) = SOME e') /\
                   (get_mem_event (nth_label j path) = SOME e)}
       =
       {}`
                 by (RWTAC [EXTENSION] THEN
                     METIS_TAC []) THEN
          METIS_TAC [FINITE_EMPTY]],
 METIS_TAC [pathlem15],
 METIS_TAC [pathlem15],
 RWTAC [path_to_X_def] THEN
     `?i j. 
        j + 1 IN PL path /\ i < j /\
        (get_orig_event (nth_label i path) = SOME ew) /\
        (get_orig_event (nth_label j path) = SOME ef)`
                by METIS_TAC [eplem06] THEN 
     `?j' k. 
        k + 1 IN PL path /\ j' < k /\
        (get_orig_event (nth_label j' path) = SOME ef) /\
        (get_orig_event (nth_label k path) = SOME er)`
                by METIS_TAC [eplem06] THEN 
     IMP_RES_TAC lem01 THEN
     `j' = j` by METIS_TAC [eplem03] THEN
     RWTAC [] THEN
     `(nth_label j path = BEvt ef) /\
      (nth_label i path = WEvt ew) /\
      (get_mem_event (nth_label k path) = SOME er)` 
                by METIS_TAC [pathlem06, pathlem07, pathlem05] THEN
     `is_mem_access ew` by FSTAC [mem_writes_def, is_mem_access_def] THEN
     `?l. l < j /\ (nth_label l path = TauEvt ew)` 
                by (FSTAC [mfences_def] THEN
                    METIS_TAC [wevt_tau_bevt, wfes_proc]) THEN
     METIS_TAC [get_mem_event_def, LESS_IMP_LESS_OR_EQ, LESS_TRANS],
 FSTAC [mem_access_lem02] THENL
     [METIS_TAC [pathlem15, mem_access_lem02],
      METIS_TAC [pathlem15, mem_access_lem02],
      RWTAC [path_to_X_def] THEN
          `?i j. j + 1 IN PL path /\ i < j /\
                (get_orig_event (nth_label i path) = SOME e1) /\
                (get_orig_event (nth_label j path) = SOME e2) /\
                (get_mem_event (nth_label j path) = SOME e2)`
                     by METIS_TAC [eplem06, pathlem05] THEN
          Cases_on `e2 IN es` THENL
          [FSTAC [po_iico_def, po_strict_def] THENL
               [`e1.iiid = e2.iiid` 
                          by (FSTAC [well_formed_event_structure_def] THEN
                              METIS_TAC []) THEN
                    FSTAC [],
                FSTAC [well_formed_event_structure_def] THEN
                    METIS_TAC [events_disj]],
           `?k es'. i < k /\ k < j /\ (nth_label k path = UnlockE (proc e1) es')` 
                           by (MATCH_MP_TAC eplem07 THEN
                               RWTAC [] THEN
                               METIS_TAC [mem_access_lem02, wfes_proc]) THEN
               `is_mem_access e1` by FSTAC [mem_writes_def, is_mem_access_def] THEN
               IMP_RES_TAC lem01 THEN
               `?l. l < k /\ (nth_label l path = TauEvt e1)` 
                           by METIS_TAC [wevt_tau_bevt, wfes_proc, pathlem06] THEN
               METIS_TAC [get_mem_event_def, LESS_IMP_LESS_OR_EQ, LESS_TRANS]],
      METIS_TAC [pathlem15]],
 FSTAC [mem_access_lem02] THENL
     [METIS_TAC [pathlem15, mem_access_lem02],
      METIS_TAC [pathlem15, mem_access_lem02],
      RWTAC [path_to_X_def] THEN
          `?i j. j + 1 IN PL path /\ i < j /\
                (get_orig_event (nth_label i path) = SOME e1) /\
                (get_orig_event (nth_label j path) = SOME e2) /\
                (get_mem_event (nth_label j path) = SOME e2)`
                     by METIS_TAC [eplem06, pathlem05] THEN
          Cases_on `e1 IN es` THENL
          [FSTAC [po_iico_def, po_strict_def] THENL
               [`e1.iiid = e2.iiid` 
                          by (FSTAC [well_formed_event_structure_def] THEN
                              METIS_TAC []) THEN
                    FSTAC [],
                FSTAC [well_formed_event_structure_def] THEN
                    METIS_TAC [events_disj]],
           `?k es'. i < k /\ k < j /\ (nth_label k path = LockE (proc e1) es')` 
                               by (MATCH_MP_TAC eplem08 THEN
                                   RWTAC [] THEN
                                   METIS_TAC [mem_access_lem02, wfes_proc]) THEN
               `is_mem_access e1` by FSTAC [mem_writes_def, is_mem_access_def] THEN
               IMP_RES_TAC lem01 THEN
               `?l. l < k /\ (nth_label l path = TauEvt e1)` 
                              by METIS_TAC [wevt_tau_bevt, wfes_proc, pathlem06] THEN
               METIS_TAC [get_mem_event_def, LESS_IMP_LESS_OR_EQ, LESS_TRANS]],
      METIS_TAC [pathlem15]],
 Cases_on `~?e'. e' IN es /\ e' IN mem_accesses E` THEN1
     METIS_TAC [] THEN
     FSTAC [] THEN
     `e' IN E.events /\ e IN E.events` by FSTAC [mem_accesses_def] THEN
     `(?i. i + 1 IN PL path /\ (get_mem_event (nth_label i path) = SOME e')) /\
      (?j. j + 1 IN PL path /\ (get_mem_event (nth_label j path) = SOME e))` 
                  by METIS_TAC [eplem05, pathlem04] THEN
     `(i = j) \/ (j < i) \/ (i < j)` by DECIDE_TAC THENL
     [METIS_TAC [SOME_11],
      DISJ1_TAC THEN
          RWTAC [] THEN
          `e'' IN E.events` by FSTAC [mem_accesses_def] THEN
          `?k. k + 1 IN PL path /\ (get_mem_event (nth_label k path) = SOME e'')`
                        by METIS_TAC [eplem05, pathlem04] THEN
          RWTAC [path_to_X_def] THEN
          `(k = j) \/ (j < k) \/ (k < j)` by DECIDE_TAC THEN
          RWTAC [] THEN1
          METIS_TAC [SOME_11] THEN1
          METIS_TAC [LESS_IMP_LESS_OR_EQ] THEN
          `?i j. locked_segment path i j (proc e') /\
                 (es INTER mem_accesses E = 
                  {e | ?k. i < k /\ k < j /\
                           (get_orig_event (nth_label k path) = SOME e) /\
                            e IN mem_accesses E /\ (proc e = proc e')})`
                     by METIS_TAC [eplem09] THEN
          FSTAC [EXTENSION] THEN
          POP_ASSUM (fn thm => MP_TAC (Q.SPEC `e` thm) THEN
                               MP_TAC (Q.SPEC `e'` thm) THEN
                               MP_TAC (Q.SPEC `e''` thm)) THEN
          RWTAC [] THEN
          `i' < k /\ i < j'` by METIS_TAC [pathlem16] THEN
          `i' < j /\ j < j'` by METIS_TAC [LESS_TRANS] THEN
          `proc e = proc e'`  
                      by (Cases_on `nth_label j path` THEN
                          FSTAC [get_mem_event_def, COND_EXPAND_EQ] THEN
                          METIS_TAC [lock_proc, mem_access_lem01]) THEN
          `?j'. j' <= j /\ (get_orig_event (nth_label j' path) = SOME e)` 
                        by METIS_TAC [pathlem18] THEN
          `j'' + 1 IN PL path` by METIS_TAC [lem01] THEN
          `i' < j'' /\ j'' < j'` by METIS_TAC [pathlem17] THEN
          METIS_TAC [],
      DISJ2_TAC THEN
          RWTAC [] THEN
          `e'' IN E.events` by FSTAC [mem_accesses_def] THEN
          `?k. k + 1 IN PL path /\ (get_mem_event (nth_label k path) = SOME e'')`
                        by METIS_TAC [eplem05, pathlem04] THEN
          RWTAC [path_to_X_def] THEN
          `(k = j) \/ (k < j) \/ (j < k)` by DECIDE_TAC THEN
          RWTAC [] THEN1
          METIS_TAC [SOME_11] THEN1
          METIS_TAC [LESS_IMP_LESS_OR_EQ] THEN
          `?i j. locked_segment path i j (proc e') /\
                 (es INTER mem_accesses E = 
                  {e | ?k. i < k /\ k < j /\
                          (get_orig_event (nth_label k path) = SOME e) /\
                          e IN mem_accesses E /\ (proc e = proc e')})`
                     by METIS_TAC [eplem09] THEN
          FSTAC [EXTENSION] THEN
          POP_ASSUM (fn thm => MP_TAC (Q.SPEC `e` thm) THEN
                               MP_TAC (Q.SPEC `e'` thm) THEN
                               MP_TAC (Q.SPEC `e''` thm)) THEN
          RWTAC [] THEN
          `i' < i /\ k < j'` by METIS_TAC [pathlem16] THEN
          `i' < j /\ j < j'` by METIS_TAC [LESS_TRANS] THEN
          `proc e = proc e'`  
                      by (Cases_on `nth_label j path` THEN
                          FSTAC [get_mem_event_def, COND_EXPAND_EQ] THEN
                          METIS_TAC [lock_proc, mem_access_lem01]) THEN
          `?j'. j' <= j /\ (get_orig_event (nth_label j' path) = SOME e)` 
                        by METIS_TAC [pathlem18] THEN
          `j'' + 1 IN PL path` by METIS_TAC [lem01] THEN
          `i' < j'' /\ j'' < j'` by METIS_TAC [pathlem17] THEN
          METIS_TAC []],
 RWTAC [path_to_X_def, in_rfmc] THEN
     RWTAC [] THENL
     [IMP_RES_TAC revt_read THEN
          RWTAC [reads_def] THEN
          METIS_TAC [eplem02],
      METIS_TAC [pathlem08],
      METIS_TAC [read_from_write, eplem10],
      METIS_TAC [read_from_write, eplem10]],
 RWTAC [path_to_X_def, check_rfmap_written_def, previous_writes_def, maximal_elements_def] THEN
     IMP_RES_TAC eplem10 THEN
     MP_TAC (Q.SPECL [`path`, `i`, `y`, `x`] read_from_write) THEN
     RWTAC [] THEN
     IMP_RES_TAC lem01 THEN
     `x IN writes E` by METIS_TAC [pathlem08] THEN
     RWTAC [] THENL
     [DISJ2_TAC THEN
          TAC,
      `(j' = i'') /\ (i = j)` by METIS_TAC [pathlem01, get_mem_event_def,
      pathlem09] THEN
          FSTAC [] THEN
          RWTAC [] THEN
          `(nth_label i'' path = TauEvt x'') /\ (nth_label i''' path = TauEvt
          x)` by METIS_TAC [pathlem10] THEN
          FSTAC [get_mem_event_def, LESS_OR_EQ] THEN
          RWTAC [] THEN
          METIS_TAC [LESS_TRANS, pathlem14, evt_machine_label_11, evt_machine_label_distinct],      
      `?k l. l + 1 IN PL path /\ k < l /\ 
             (get_orig_event (nth_label k path) = SOME x'') /\  
             (get_orig_event (nth_label l path) = SOME y)`
                             by METIS_TAC [eplem06] THEN
          `(nth_label i'' path = TauEvt x) /\ (nth_label j path = TauEvt x'')`
          by METIS_TAC [pathlem10] THEN
          FSTAC [get_mem_event_def, LESS_OR_EQ] THEN
          RWTAC [] THENL
          [`proc x = proc x''` by METIS_TAC [wfes_proc] THEN
               `i = l` by METIS_TAC [eplem03, get_orig_event_def] THEN
               MP_TAC (Q.SPECL [`path`, `i''`, `j`, `x`, `x''`] tau_ordered_source) THEN
               RWTAC [] THEN
               IMP_RES_TAC lem01 THEN
               `(i''' = k') /\ (k = l) /\ (i''' = i')` by METIS_TAC [get_orig_event_def, eplem03] THEN
               FSTAC [] THEN
               RWTAC [] THEN
               METIS_TAC [wfes_proc],
           METIS_TAC [evt_machine_label_11, evt_machine_label_distinct]],
      DISJ1_TAC THEN
          `is_mem_access x` by METIS_TAC [tau_source] THEN
          `is_mem_access y`
                       by (FSTAC [is_mem_access_def, loc_def] THEN
                           Cases_on `y.action` THEN
                           FSTAC [] THEN
                           METIS_TAC []) THEN
          METIS_TAC [get_mem_event_def, LESS_IMP_LESS_OR_EQ],
      `(i'' = j') /\ (i''' = i') /\ (j = i)` by METIS_TAC [pathlem01, get_mem_event_def, pathlem09] THEN
          FSTAC [] THEN
          RWTAC [] THEN
          `nth_label i'' path = TauEvt x''` by METIS_TAC [pathlem10] THEN
          METIS_TAC [LESS_OR_EQ, evt_machine_label_11, evt_machine_label_distinct],
     `?k l. l + 1 IN PL path /\ k < l /\ 
             (get_orig_event (nth_label k path) = SOME x'') /\  
             (get_orig_event (nth_label l path) = SOME y)`
                             by METIS_TAC [eplem06] THEN
          `(nth_label i'' path = TauEvt x) /\ (nth_label j path = TauEvt x'')`
          by METIS_TAC [pathlem10] THEN
          FSTAC [get_mem_event_def, LESS_OR_EQ] THEN
          RWTAC [] THENL
          [`(i = l) /\ (i'' = i')` 
                         by METIS_TAC [eplem03, get_orig_event_def, pathlem01, get_mem_event_def] THEN
               RWTAC [] THEN
               `nth_label k path = WEvt x''` by METIS_TAC [pathlem13] THEN
               `?l. k < l /\ l < i /\ (nth_label l path = TauEvt x'')` by METIS_TAC [wfes_proc] THEN
               IMP_RES_TAC lem01 THEN
               `j = l` by METIS_TAC [get_mem_event_def, pathlem01] THEN
               METIS_TAC [],
           METIS_TAC [evt_machine_label_11, evt_machine_label_distinct]],
      TAC,
      `?k l j. l + 1 IN PL path /\ k < l /\ 
             (get_orig_event (nth_label k path) = SOME x'') /\  
             (get_orig_event (nth_label l path) = SOME y)`
                             by METIS_TAC [eplem06] THEN
          `i = l` by METIS_TAC [get_orig_event_def, eplem03] THEN
          RWTAC [] THEN
          `?l j. j + 1 IN PL path /\ l < j /\ 
             (get_orig_event (nth_label j path) = SOME x'') /\  
             (get_orig_event (nth_label l path) = SOME x)`
                             by METIS_TAC [eplem06] THEN
          IMP_RES_TAC lem01 THEN
          `(k = j) /\ (i' = l)` by METIS_TAC [get_orig_event_def, eplem03] THEN
          FSTAC [] THEN
          RWTAC [] THEN
          METIS_TAC [pathlem13, wfes_proc],
      FSTAC [mem_access_lem01] THENL
          [IMP_RES_TAC pathlem08 THEN
               FSTAC [writes_def],
           METIS_TAC [tau_source]],
      FSTAC [mem_access_lem01] THENL
          [IMP_RES_TAC pathlem08 THEN
               FSTAC [writes_def],
           METIS_TAC [tau_source]]],
 RWTAC [path_to_X_def, check_rfmap_initial_def, previous_writes_def, EXTENSION,
        range_def] THENL
     [`?i. i + 1 IN PL path /\ (get_orig_event (nth_label i path) = SOME er)` 
                  by (FSTAC [reads_def] THEN
                      METIS_TAC [eplem05]) THEN
          `?ew_opt. nth_label i path = REvt er ew_opt` by METIS_TAC [pathlem12] THEN
          FSTAC [reads_def, loc_def] THEN
          Cases_on `ew_opt` THEN
          IMP_RES_TAC read_from_init THEN
          FSTAC [loc_def] THEN
          METIS_TAC [],
      CCONTR_TAC THEN
          FSTAC [] THEN
          IMP_RES_TAC lem01 THEN
          `nth_label i path = TauEvt x` by METIS_TAC [pathlem10] THEN
          `?ew_opt. nth_label j path = REvt er ew_opt` by METIS_TAC [pathlem11] THEN
          Cases_on `ew_opt` THEN
          METIS_TAC [LESS_OR_EQ, evt_machine_label_11, evt_machine_label_distinct, read_from_init],
      CCONTR_TAC THEN
          FSTAC [] THEN
          IMP_RES_TAC eplem06 THEN
          `?ew_opt. nth_label j path = REvt er ew_opt` by METIS_TAC [pathlem12] THEN
          IMP_RES_TAC lem01 THEN
          `nth_label i path = WEvt x` by METIS_TAC [pathlem13] THEN
          Cases_on `ew_opt` THEN
          METIS_TAC [LESS_OR_EQ, evt_machine_label_11, evt_machine_label_distinct, read_from_init, wfes_proc]]]);

local

fun not_elim th =
  if is_neg(concl th) then (true, NOT_ELIM th) else (false,th)
fun canon (fl,th) =
   let val w = concl th
   in
   if is_conj w
     then let val (th1,th2) = CONJ_PAIR th
          in (canon(fl,th1) @ canon(fl,th2))
          end else
   if is_imp w andalso not(is_neg w) then
     let val (ant,_) = dest_imp w
     in if is_conj ant
        then let val (conj1,conj2) = dest_conj ant
                 val cth = MP th (CONJ (ASSUME conj1) (ASSUME conj2))
                 val th1 = DISCH conj2 cth
             in
                canon(true,DISCH conj1 th1)
             end else
        if is_disj ant
        then let val (disj1,disj2) = dest_disj ant
                 val ath = DISJ1 (ASSUME disj1) disj2
                 and bth = DISJ2 disj1 (ASSUME disj2)
                 val th1 = DISCH disj1 (MP th ath)
                 and th2 = DISCH disj2 (MP th bth)
             in
                 canon(true,th1) @ canon(true,th2)
             end else
        if is_exists ant
        then let val (Bvar,Body) = dest_exists ant
                 val newv = variant(thm_frees th) Bvar
                 val newa = subst [Bvar |-> newv] Body
                 val th1  = MP th (EXISTS (ant,newv) (ASSUME newa))
             in
               canon(true,DISCH newa th1)
             end
        else map (GEN_ALL o (DISCH ant)) (canon (true,UNDISCH th))
     end else
   if is_eq w andalso (type_of (rand w) = Type.bool)
   then let val (th1,th2) = EQ_IMP_RULE th
        in (if fl then [GEN_ALL th] else [])@canon(true,th1)@canon(true,th2)
        end else
   if is_forall w then
     let val (vs,_) = strip_forall w
         val fvs = HOLset.listItems (FVL[concl th] (hyp_frees th))
         val nvs = itlist (fn v => fn nv => variant (nv @ fvs) v::nv) vs []
     in
        canon (fl, SPECL nvs th)
     end else
   if fl then [GEN_ALL th] else []
   end

fun check ex [] = raise ex
  | check ex l = l;

in

fun MY_RES_CANON th =
 let val conjlist = CONJUNCTS (SPEC_ALL th)
     fun operate th accum =
          accum @ map GEN_ALL (canon (not_elim (SPEC_ALL th)))
     val imps = Lib.rev_itlist operate conjlist []
 in Lib.assert (op not o null) imps
 end handle HOL_ERR _
 => raise ERR "RES_CANON" "No implication is derivable from input thm"

fun MY_IMP_RES_THEN ttac impth =
 let val ths = CONJUNCTS impth
      handle HOL_ERR _ => raise ERR "IMP_RES_THEN" "No implication"
 in
  Tactical.ASSUM_LIST
   (fn asl =>
     let val l = itlist (fn th => append (mapfilter(MATCH_MP th) asl)) ths []
         val res  = check (ERR "IMP_RES_THEN" "No resolvents") l
         val tacs = check (ERR "IMP_RES_THEN" "No tactics")
                          (Lib.mapfilter ttac res)
     in
        Tactical.EVERY tacs
     end)
 end;
end;

fun RESOLVE thms = 
let val res_thms = LIST_CONJ (List.concat (List.map MY_RES_CANON thms)) in
  REPEAT (CHANGED_TAC ((REPEAT_GTCL MY_IMP_RES_THEN 
                                    (fn thm => 
                                      if pred_setSyntax.is_in (concl thm) orelse
                                         is_const (concl thm) then
                                        STRIP_ASSUME_TAC thm 
                                      else if boolSyntax.is_eq (concl thm) then 
                                        FULL_SIMP_TAC std_ss [thm]
                                      else 
                                        ALL_TAC))
                                    res_thms))
end;

val memL_def = Define `
  memL E X =
    { TauEvt e | e IN mem_writes E } UNION
    { REvt er NONE | er IN mem_reads E /\ er NOTIN range X.rfmap } UNION
    { REvt er (SOME ew) | er IN mem_reads E /\ (ew, er) IN X.rfmap }`;

val to_memL_def = Define `
  to_memL E X e =
    if e IN mem_writes E then
      TauEvt e
    else if e IN mem_reads E /\ e NOTIN range X.rfmap then
      REvt e NONE
    else
      REvt e (SOME (CHOICE { ew | (ew, e) IN X.rfmap }))`;

val localL_def = Define `
localL E X = 
  { REvt er NONE | er IN reads E /\ er NOTIN range X.rfmap } UNION 
  { REvt er (SOME ew) | er IN reads E /\ (ew, er) IN X.rfmap } UNION 
  { WEvt e | e IN writes E } UNION
  { BEvt e | e IN fences E }`;

val to_localL_def = Define `
  to_localL E X e =
    if e IN writes E then
      WEvt e
    else if e IN fences E then
      BEvt e
    else if e IN reads E /\ e NOTIN range X.rfmap then
      REvt e NONE
    else
      REvt e (SOME (CHOICE { ew | (ew, e) IN X.rfmap }))`;

val proc_es_def = Define `
  proc_es es = { proc e | e IN es }`;

val lockL_def = Define `
  lockL E X = 
    { LockE p es | es IN E.atomicity /\ (p IN proc_es es) } UNION
    { UnlockE p es | es IN E.atomicity /\ (p IN proc_es es) }`;

val allL_def = Define `
  allL E X = 
    memL E X UNION 
    localL E X UNION
    lockL E X`;

val l_e_def = Define `
  (l_e (TauEvt e) = SOME e) /\
  (l_e (REvt e _) = SOME e) /\
  (l_e (WEvt e) = SOME e) /\
  (l_e (BEvt e) = SOME e) /\
  (l_e _ = NONE)`;
  
val l_es_def = Define `
  (l_es (LockE p es) = SOME es) /\
  (l_es (UnlockE p es) = SOME es) /\
  (l_es _ = NONE)`;

val lo1_def = Define `
  lo1 E X = 
    { (l, l') | l IN memL E X /\ l' IN memL E X /\ 
        (THE (l_e l), THE (l_e l')) IN X.memory_order}`;

val lo1_alt_def = Define `
  lo1_alt E X = 
    { (to_memL E X e, to_memL E X e') | (e, e') | (e, e') IN X.memory_order }`;

val lo1_alt_lem = Q.prove (
`!E X er ew. 
  well_formed_event_structure E /\ valid_execution E X /\
  (ew, er) IN X.rfmap 
  ==> 
  (ew = CHOICE {ew | (ew, er) IN X.rfmap})`,
RWTAC [] THEN
`{ew | (ew, er) IN X.rfmap} = {ew}`
      by (RWTAC [EXTENSION] THEN
          METIS_TAC [rfmap_func]) THEN
RWTAC []);

val lo1_alt_equiv = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  (lo1 E X = lo1_alt E X)`,
RWTAC [lo1_alt_def, lo1_def, EXTENSION, memL_def, to_memL_def] THEN
EQ_TAC THEN
RWTAC [] THEN
FSTAC [l_e_def, range_def] THENL
[METIS_TAC [],
 METIS_TAC [events_disj], 
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj],
 METIS_TAC [events_disj],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 IMP_RES_TAC lem06 THEN
     FSTAC [mem_access_lem02] THEN
     RWTAC [events_disj] THEN
     FSTAC [l_e_def] THEN
     METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem]]);

val lo2_def = Define `
  lo2 E X = 
    { (l, l') | l IN localL E X /\ l' IN localL E X /\
        (THE (l_e l), THE (l_e l')) IN po_iico E } UNION
    { (WEvt e, WEvt e') | WEvt e IN allL E X /\ WEvt e' IN allL E X /\
                          (e, e') IN X.memory_order /\ (proc e = proc e') } UNION
    { (l, WEvt e) | l IN localL E X /\ WEvt e IN allL E X /\
                    ?e'. WEvt e' IN localL E X /\ (THE (l_e l), e') IN po_iico E /\
                         (e', e) IN X.memory_order /\ (proc e' = proc e) }`;

val lo2_alt_def = Define `
  lo2_alt E X = 
    { (to_localL E X e, to_localL E X e') | (e, e') | (e, e') IN po_iico E } UNION
    { (WEvt e, WEvt e') | WEvt e IN allL E X /\ WEvt e' IN allL E X /\
                          (e, e') IN X.memory_order /\ (proc e = proc e') } UNION
    { (to_localL E X e'', WEvt e) | (e'', e) |  
           WEvt e IN allL E X /\
           ?e'. WEvt e' IN localL E X /\ (e'', e') IN po_iico E /\
                (e', e) IN X.memory_order /\ (proc e' = proc e) }`;

val lo2_alt_equiv = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  (lo2 E X = lo2_alt E X)`,
RWTAC [lo2_alt_def, lo2_def, EXTENSION, localL_def, to_localL_def] THEN
EQ_TAC THEN
RWTAC [] THEN
FSTAC [l_e_def, range_def] THENL
[METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 METIS_TAC [events_disj, valid_ex_equiv_thm1, lo1_alt_lem],
 `e' IN E.events /\ e IN E.events`
           by  (IMP_RES_TAC wfes_po_iico THEN
                FSTAC [partial_order_def, range_def, domain_def, SUBSET_DEF] THEN
                METIS_TAC []) THEN
     RWTAC [l_e_def, COND_EXPAND] THEN
     METIS_TAC [events_cases, valid_ex_equiv_thm1, lo1_alt_lem],
 `e' IN E.events /\ e'' IN E.events`
           by  (IMP_RES_TAC wfes_po_iico THEN
                FSTAC [partial_order_def, range_def, domain_def, SUBSET_DEF] THEN
                METIS_TAC []) THEN
     RWTAC [l_e_def, COND_EXPAND] THEN
     METIS_TAC [events_cases, valid_ex_equiv_thm1, lo1_alt_lem]]);

val lo3_def = Define `
  lo3 E X = 
    { (WEvt e, TauEvt e) | WEvt e IN allL E X /\ TauEvt e IN allL E X }`;

val lo4_def = Define `
  lo4 E X = 
    { (TauEvt e, BEvt e') | TauEvt e IN allL E X /\ BEvt e' IN allL E X /\
        e' IN mfences E /\ (e, e') IN po_iico E }`;

val lo5_def = Define `
  lo5 E X = 
    { (LockE p es, LockE p es) | LockE p es IN lockL E X } UNION
    { (UnlockE p es, UnlockE p es) | LockE p es IN lockL E X } UNION
    { (l1, l2) | l1 IN lockL E X /\ l2 IN lockL E X /\ 
                 THE (l_es l1) <> THE (l_es l2) /\
                 ?e1 e2. e1 IN THE (l_es l1) /\ e2 IN THE (l_es l2) /\
                         (e1, e2) IN X.memory_order } UNION
    { (LockE p es, UnlockE p es) | LockE p es IN lockL E X /\ UnlockE p es IN lockL E X }`;

val lo6_def = Define `
  lo6 E X =
    { (LockE p es, l) | LockE p es IN allL E X /\ l IN allL E X /\
                        ?e. (l_e l = SOME e) /\ e IN es /\ e IN mem_accesses E }`;

val lo7_def = Define `
  lo7 E X =
    { (l, UnlockE p es) | l IN memL E X /\ UnlockE p es IN allL E X /\
                          ?e. (l_e l = SOME e) /\ e IN es }`;

val lo8_def = Define `
  lo8 E X =
    { (UnlockE p es, l) | UnlockE p es IN allL E X /\ l IN allL E X /\
                          ?e e'. (l_e l = SOME e) /\ e' IN es /\ e NOTIN es /\
                                 (e', e) IN X.memory_order /\ 
                                 (l NOTIN memL E X ==> ((proc e = p) /\ e IN mem_accesses E)) }`;

val lo9_def = Define `
  lo9 E X =
    { (l, LockE p es) | l IN memL E X /\ LockE p es IN allL E X /\
                        ?e e'. (l_e l = SOME e) /\ e' IN es /\ e NOTIN es /\
                               (e, e') IN X.memory_order }`;

val lo_events_def = Define `
  lo_events E X =
    lo1 E X UNION lo2 E X UNION
    rcomp (lo1 E X) (lo2 E X) UNION
    rcomp (lo2 E X) (lo1 E X) UNION
    rcomp (lo2 E X) (rcomp (lo1 E X) (lo2 E X)) UNION
    rcomp (lo2 E X) (rcomp (lo3 E X) (lo1 E X)) UNION
    rcomp (lo2 E X) (rcomp (lo3 E X) (rcomp (lo1 E X) (lo2 E X))) UNION
    rcomp (lo1 E X) (rcomp (lo4 E X) (lo2 E X)) UNION
    rcomp (lo2 E X) (rcomp (lo1 E X) (rcomp (lo4 E X) (lo2 E X))) UNION
    rcomp (lo2 E X) (rcomp (lo3 E X) (rcomp (lo1 E X) (rcomp (lo4 E X) (lo2 E X))))`;

val memL_dom = Q.prove (
`!E X p es. 
  LockE p es NOTIN memL E X /\
  UnlockE p es NOTIN memL E X`,
RWTAC [memL_def]);

val localL_dom = Q.prove (
`!E X p es. 
  LockE p es NOTIN localL E X /\
  UnlockE p es NOTIN localL E X`,
RWTAC [localL_def]);

val proc_es_unique = Q.prove (
`!E es p p'.
  well_formed_event_structure E /\ 
  es IN E.atomicity /\ p IN proc_es es /\ p' IN proc_es es
  ==>
  (p = p')`,
RWTAC [well_formed_event_structure_def, proc_es_def, proc_def] THEN
METIS_TAC []);

val localL_memL_lem = Q.prove (
`!E X l e.
  (l_e l = SOME e) /\ e IN mem_accesses E /\ l IN localL E X /\ l NOTIN memL E X 
  ==> 
  e IN mem_writes E /\
  (l = WEvt e)`,
RWTAC [localL_def, memL_def, mem_access_lem02] THEN
FSTAC [l_e_def] THEN
METIS_TAC [events_disj, events_disj, mem_access_lem04, mem_access_lem03]);

val memL_read_lem = Q.prove (
`!E X l e.
  (l_e l = SOME e) /\ e IN mem_reads E /\ l IN memL E X 
  ==> 
  ?ew. (l = REvt e ew)`,
RWTAC [memL_def] THEN
FSTAC [l_e_def] THEN
METIS_TAC [events_disj]);

val lo1_trans = Q.prove (
`!E X l1 l2 l3. 
  linear_valid_execution E X /\ (l1, l2) IN lo1 E X /\ (l2, l3) IN lo1 E X ==> 
  (l1, l3) IN lo1 E X`,
FSTAC [lo1_def, linear_valid_execution_def, linear_order_def, transitive_def] THEN
     METIS_TAC []);

val lo1_refl = Q.prove (
`!E X l. linear_valid_execution E X /\ l IN memL E X ==> (l, l) IN lo1 E X`,
RWTAC [memL_def, lo1_def, linear_valid_execution_def, linear_order_def, reflexive_def] THEN
FSTAC [l_e_def, mem_access_lem02] THEN
METIS_TAC []);

val lo1_asym = Q.prove (
`!E X l1 l2. 
  well_formed_event_structure E /\ linear_valid_execution E X /\ 
  (l1, l2) IN lo1 E X /\ (l2, l1) IN lo1 E X 
  ==> 
  (l1 = l2)`,
RWTAC [lo1_def, memL_def] THEN
`antisym X.memory_order` 
       by FSTAC [linear_valid_execution_def, linear_order_def] THEN
FSTAC [l_e_def, antisym_def] THENL
[METIS_TAC [events_disj],
 METIS_TAC [events_disj],
 METIS_TAC [events_disj],
 FSTAC [range_def] THEN
     METIS_TAC [],
 METIS_TAC [events_disj],
 FSTAC [range_def] THEN
     METIS_TAC [],
 METIS_TAC [rfmap_func, valid_ex_equiv_thm1]]);

val lo2_refl = Q.prove (
`!E X l. well_formed_event_structure E /\ l IN localL E X ==> (l, l) IN lo2 E X`,
RWTAC [localL_def, lo2_def] THEN
IMP_RES_TAC wfes_po_iico THEN
FSTAC [partial_order_def, reflexive_def, l_e_def, reads_def, writes_def, fences_def]);

(* Relies on the fact that nothing follows a memory write in intra_causality *)     
val lo2_trans_lem = Q.prove (
`!E X e1 e2 e3.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (e1, e2) IN X.memory_order /\
  (e2, e3) IN po_iico E /\
  (proc e1 = proc e2) /\
  e2 IN writes E /\
  e1 IN writes E /\
  e2 <> e3
  ==>
  (e1, e3) IN po_iico E`,
RWTAC [po_iico_def, po_strict_def, proc_def] THEN
RWTAC [] THEN
`e1 IN mem_writes E /\ e2 IN mem_writes E`
        by (IMP_RES_TAC lem06 THEN
            FSTAC [mem_access_lem02, mem_reads_def, writes_def] THEN
            FSTAC []) THENL
[FSTAC [linear_valid_execution_def, linear_order_def, antisym_def, writes_def,
        po_iico_def, po_strict_def] THEN
     METIS_TAC [LESS_LESS_CASES, LESS_TRANS],
 FSTAC [well_formed_event_structure_def] THEN
     METIS_TAC []]);

val lo2_trans = Q.prove (
`!E X l1 l2 l3. 
  well_formed_event_structure E /\ 
  linear_valid_execution E X /\
  (l1, l2) IN lo2 E X /\ (l2, l3) IN lo2 E X ==> 
  (l1, l3) IN lo2 E X`,
RWTAC [] THEN
IMP_RES_TAC wfes_po_iico THEN
FSTAC [lo2_def] THEN
RWTAC [] THEN
FSTAC [l_e_def] THENL
[FSTAC [partial_order_def, transitive_def] THEN
     METIS_TAC [],
 RWTAC [allL_def] THEN 
     METIS_TAC [],
 FSTAC [allL_def, partial_order_def, transitive_def] THEN
     METIS_TAC [],
 FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
     RWTAC [] THEN
     FSTAC [l_e_def] THEN
     METIS_TAC [lo2_trans_lem, events_disj],
 FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
     METIS_TAC [],
 FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
     RWTAC [] THEN
     FSTAC [l_e_def] THEN
     Cases_on `e' = e'''` THENL
     [FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
          METIS_TAC [],
      METIS_TAC [lo2_trans_lem]],
 `e IN writes E /\ e' IN writes E`
          by (FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
              METIS_TAC [events_disj]) THEN
     Cases_on `e = THE (l_e l3)` THENL
     [FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          METIS_TAC [events_disj],
      FSTAC [partial_order_def, transitive_def] THEN
          METIS_TAC [lo2_trans_lem]],
 FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
     METIS_TAC [],
 `e IN writes E /\ e' IN writes E`
          by (FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
              METIS_TAC [events_disj]) THEN
     Cases_on `e = e'''` THENL
     [FSTAC [linear_valid_execution_def, linear_order_def, transitive_def, 
             allL_def, memL_def] THEN
          METIS_TAC [],
      FSTAC [partial_order_def, transitive_def] THEN
          METIS_TAC [lo2_trans_lem]]]);

val lo2_asym = Q.prove (
`!E X l1 l2. 
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo2 E X /\ (l2, l1) IN lo2 E X 
  ==> 
  (l1 = l2)`,
RWTAC [lo2_def] THEN
IMP_RES_TAC wfes_po_iico THEN
FSTAC [l_e_def] THENL
[FSTAC [partial_order_def, antisym_def, localL_def] THEN
     RWTAC [] THEN
     FSTAC [l_e_def, range_def] THEN
     METIS_TAC [events_disj, rfmap_func, valid_ex_equiv_thm1],
 FSTAC [localL_def, l_e_def, linear_valid_execution_def, linear_order_def,
        domain_def, range_def, SUBSET_DEF, antisym_def] THEN
     METIS_TAC [mem_access_lem04],
 `e = e'`
         by (FSTAC [localL_def, l_e_def, linear_valid_execution_def, linear_order_def,
                    domain_def, range_def, SUBSET_DEF, antisym_def, partial_order_def,
                    transitive_def] THEN
                 METIS_TAC [mem_access_lem04]) THEN
     FSTAC [partial_order_def, antisym_def, localL_def] THEN
     RWTAC [] THEN
     FSTAC [l_e_def, range_def] THEN
     METIS_TAC [events_disj, rfmap_func, valid_ex_equiv_thm1],
 FSTAC [localL_def, l_e_def, linear_valid_execution_def, linear_order_def,
        domain_def, range_def, SUBSET_DEF, antisym_def] THEN
     METIS_TAC [mem_access_lem04],
 FSTAC [linear_valid_execution_def, linear_order_def, antisym_def] THEN
     METIS_TAC [],
 FSTAC [localL_def, l_e_def, linear_valid_execution_def, linear_order_def,
        domain_def, range_def, SUBSET_DEF, antisym_def, partial_order_def,
        transitive_def] THEN
     METIS_TAC [mem_access_lem04],
 `e = e'`
         by (FSTAC [localL_def, l_e_def, linear_valid_execution_def, linear_order_def,
                    domain_def, range_def, SUBSET_DEF, antisym_def, partial_order_def,
                    transitive_def] THEN
                 METIS_TAC [mem_access_lem04]) THEN
     FSTAC [partial_order_def, antisym_def, localL_def] THEN
     RWTAC [] THEN
     FSTAC [l_e_def, range_def] THEN
     METIS_TAC [events_disj, rfmap_func, valid_ex_equiv_thm1],
 FSTAC [localL_def, l_e_def, linear_valid_execution_def, linear_order_def,
        domain_def, range_def, SUBSET_DEF, antisym_def, partial_order_def,
        transitive_def] THEN
     METIS_TAC [mem_access_lem04],
 FSTAC [localL_def, l_e_def, linear_valid_execution_def, linear_order_def,
        domain_def, range_def, SUBSET_DEF, antisym_def, partial_order_def,
        transitive_def] THEN
     METIS_TAC [mem_access_lem04]]);

val lo3_dom_rng = Q.prove (
`!E X l1 l2. (l1, l2) IN lo3 E X ==> 
  l1 IN localL E X /\
  l2 IN memL E X`,
RWTAC [localL_def, memL_def, allL_def, lo3_def, lockL_def]);

val lo4_dom_rng = Q.prove (
`!E X l1 l2. (l1, l2) IN lo4 E X ==> 
  l2 IN localL E X /\
  l1 IN memL E X`,
RWTAC [localL_def, memL_def, allL_def, lo4_def, lockL_def]);

val lo3_expand = Q.prove (
`!E X l1 l2. 
  well_formed_event_structure E /\ linear_valid_execution E X /\
  (l1, l2) IN lo3 E X ==>
  (l1, l1) IN lo2 E X /\
  (l2, l2) IN lo1 E X`,
METIS_TAC [lo1_refl, lo2_refl, lo3_dom_rng]);

val lo4_expand = Q.prove (
`!E X l1 l2. 
  well_formed_event_structure E /\ linear_valid_execution E X /\
  (l1, l2) IN lo4 E X ==>
  (l1, l1) IN lo1 E X /\
  (l2, l2) IN lo2 E X`,
METIS_TAC [lo1_refl, lo2_refl, lo4_dom_rng]);

val lo_events_dom_rng = Q.prove (
`!E X l p es.
  (LockE p es, l) NOTIN lo_events E X /\
  (UnlockE p es, l) NOTIN lo_events E X /\
  (l, LockE p es) NOTIN lo_events E X /\
  (l, UnlockE p es) NOTIN lo_events E X`,
RWTAC [lo_events_def, lo1_def, lo2_def, lo3_def, lo4_def, rcomp_def] THEN
CCONTR_TAC THEN
FSTAC [] THEN
METIS_TAC [memL_dom, localL_dom]);

val lo_events_dom_rng2 = Q.prove (
`!E X l1 l2.
  (l1, l2) IN lo_events E X ==> l1 IN allL E X /\ l2 IN allL E X`,
RWTAC [lo_events_def, lo1_def, lo2_def, rcomp_def] THEN
RWTAC [allL_def]);

val lo_disjoint = Q.prove (
`!E X l1 l2 l3.
  ~((l1, l2) IN lo1 E X /\ (l2, l3) IN lo3 E X) /\
  ~((l1, l2) IN lo2 E X /\ (l2, l3) IN lo4 E X) /\
  ~((l1, l2) IN lo3 E X /\ (l2, l3) IN lo2 E X) /\
  ~((l1, l2) IN lo3 E X /\ (l2, l3) IN lo3 E X) /\
  ~((l1, l2) IN lo4 E X /\ (l2, l3) IN lo1 E X) /\
  ~((l1, l2) IN lo4 E X /\ (l2, l3) IN lo3 E X) /\
  ~((l1, l2) IN lo4 E X /\ (l2, l3) IN lo4 E X) /\
  ~((l1, l2) IN lo_events E X /\ (l2, l3) IN lo5 E X) /\
  ~((l1, l2) IN lo_events E X /\ (l2, l3) IN lo6 E X) /\
  ~((l1, l2) IN lo_events E X /\ (l2, l3) IN lo8 E X) /\
  ~((l1, l2) IN lo5 E X /\ (l2, l3) IN lo_events E X) /\
  ~((l1, l2) IN lo5 E X /\ (l2, l3) IN lo7 E X) /\
  ~((l1, l2) IN lo5 E X /\ (l2, l3) IN lo9 E X) /\
  ~((l1, l2) IN lo6 E X /\ (l2, l3) IN lo5 E X) /\
  ~((l1, l2) IN lo6 E X /\ (l2, l3) IN lo6 E X) /\
  ~((l1, l2) IN lo6 E X /\ (l2, l3) IN lo8 E X) /\
  ~((l1, l2) IN lo7 E X /\ (l2, l3) IN lo6 E X) /\
  ~((l1, l2) IN lo7 E X /\ (l2, l3) IN lo7 E X) /\
  ~((l1, l2) IN lo7 E X /\ (l2, l3) IN lo9 E X) /\
  ~((l1, l2) IN lo8 E X /\ (l2, l3) IN lo5 E X) /\
  ~((l1, l2) IN lo8 E X /\ (l2, l3) IN lo6 E X) /\
  ~((l1, l2) IN lo8 E X /\ (l2, l3) IN lo8 E X) /\
  ~((l1, l2) IN lo9 E X /\ (l2, l3) IN lo7 E X) /\
  ~((l1, l2) IN lo9 E X /\ (l2, l3) IN lo8 E X) /\
  ~((l1, l2) IN lo9 E X /\ (l2, l3) IN lo9 E X)`,
RWTAC [lo1_def, lo2_def, lo3_def, lo4_def, memL_def, localL_def, lo5_def, 
       lo6_def, lo7_def, lo8_def, lo9_def, lockL_def, rcomp_def] THEN
CCONTR_TAC THEN
FSTAC [] THEN
RWTAC [] THEN
FSTAC [l_e_def, l_es_def] THEN
METIS_TAC [lo_events_dom_rng]);

val lo_collapse34_2 = Q.prove (
`!E X l1 l2 l3.
  (l1, l2) IN lo3 E X /\ (l2, l3) IN lo4 E X ==> (l1, l3) IN lo2 E X`,
RWTAC [lo3_def, lo4_def, lo2_def, localL_def, allL_def, memL_def, lockL_def] THEN
RWTAC [l_e_def]);

val lo_collapse423_1 = Q.prove (
`!E X l1 l2 l3 l4.
  well_formed_event_structure E /\ linear_valid_execution E X /\
  (l1, l2) IN lo4 E X /\ (l2, l3) IN lo2 E X /\ (l3, l4) IN lo3 E X ==> (l1, l4) IN lo1 E X`,
RWTAC [lo3_def, lo4_def, lo2_def, lo1_def, localL_def, allL_def, memL_def, lockL_def] THEN
FSTAC [l_e_def] THEN
IMP_RES_TAC wfes_po_iico THEN
FSTAC [partial_order_def, transitive_def, linear_valid_execution_def,
       linear_order_def, domain_def, SUBSET_DEF] THEN
METIS_TAC [mem_access_lem04]);

val lo_collapse121_1 = Q.prove (
`!E X l1 l2 l3 l4.
  linear_valid_execution E X /\
  (l1, l2) IN lo1 E X /\ (l2, l3) IN lo2 E X /\ (l3, l4) IN lo1 E X 
  ==> 
  (l2, l3) IN lo1 E X`,
FSTAC [linear_valid_execution_def, linear_order_def, mem_access_lem02] THEN
RWTAC [lo2_def, lo1_def, localL_def, allL_def, memL_def, lockL_def] THEN
FSTAC [l_e_def]);

val lo_collapse123_1 = Q.prove (
`!E X l1 l2 l3 l4.
  linear_valid_execution E X /\
  (l1, l2) IN lo1 E X /\ (l2, l3) IN lo2 E X /\ (l3, l4) IN lo3 E X 
  ==> 
  (l2, l4) IN lo1 E X`,
FSTAC [linear_valid_execution_def, linear_order_def, transitive_def,
mem_access_lem02] THEN
RWTAC [lo3_def, lo2_def, lo1_def, localL_def, allL_def, memL_def, lockL_def] THEN
FSTAC [l_e_def, domain_def, SUBSET_DEF] THEN 
METIS_TAC [mem_access_lem04]);

val lo_collapse421_1 = Q.prove (
`!E X l1 l2 l3 l4.
  linear_valid_execution E X /\
  (l1, l2) IN lo4 E X /\ (l2, l3) IN lo2 E X /\ (l3, l4) IN lo1 E X 
  ==> 
  (l1, l3) IN lo1 E X`,
FSTAC [linear_valid_execution_def, linear_order_def, transitive_def, mem_access_lem02] THEN
RWTAC [lo4_def, lo2_def, lo1_def, localL_def, allL_def, memL_def, lockL_def] THEN
FSTAC [l_e_def] THEN
METIS_TAC []);

val lo_collapse = LIST_CONJ
  [lo_collapse34_2, lo_collapse423_1, lo_collapse121_1, lo_collapse123_1,
   lo_collapse421_1];

val lo_events_trans = Q.prove (
`!E X. 
  well_formed_event_structure E /\ 
  linear_valid_execution E X ==> 
  transitive (lo_events E X)`,
RWTAC [lo_events_def, transitive_def, rcomp_def] THEN
RESOLVE [lo1_trans, lo2_trans, lo_collapse] THEN 
FULL_SIMP_TAC std_ss [] THEN
METIS_TAC [lo4_expand, lo3_expand]);

val lo_events_asym = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X ==>
  antisym (lo_events E X)`,
RWTAC [lo_events_def, antisym_def, rcomp_def] THEN
RESOLVE [lo1_trans, lo2_trans, lo1_asym, lo2_asym, lo_collapse, lo_disjoint] THEN
METIS_TAC [lo1_trans, lo2_trans, lo1_asym, lo2_asym, lo_collapse, lo_disjoint]);

val lo1_mem_dom_rng = Q.prove (
`!E X l1 l2.
  (l1, l2) IN lo1 E X
  ==>
  (?e. e IN mem_accesses E /\ (l_e l1 = SOME e)) /\
  (?e. e IN mem_accesses E /\ (l_e l2 = SOME e))`,
RWTAC [lo1_def, memL_def] THEN
FSTAC [l_e_def, mem_access_lem02]);

val lo2_lock_mem_order = Q.prove (
`!E X es l1 l2 e1 e2.
  linear_valid_execution E X /\
  es IN E.atomicity /\
  e1 IN es /\
  (l1, l2) IN lo2 E X /\
  e1 IN mem_accesses E /\
  e2 IN mem_accesses E /\
  (l_e l1 = SOME e1) /\
  (l_e l2 = SOME e2)
  ==>
  (e1, e2) IN X.memory_order`,
RWTAC [lo2_def] THEN
FSTAC [l_e_def, localL_def] THEN
RWTAC [] THEN
FSTAC [l_e_def] THEN
RWTAC [] THEN
IMP_RES_TAC lem06 THEN
FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
METIS_TAC [mem_access_lem02]);

val lo_cond_collapse142_1 = Q.prove (
`!E X l1 l2 l3 l4.
  well_formed_event_structure E /\ linear_valid_execution E X /\
  (l1, l2) IN lo1 E X /\ (l2, l3) IN lo4 E X /\ (l3, l4) IN lo2 E X /\
  l4 IN memL E X
  ==> 
  (l1, l4) IN lo1 E X`,
RWTAC [lo4_def, lo2_def, lo1_def, localL_def, allL_def, memL_def, lockL_def] THEN
FSTAC [l_e_def] THEN
IMP_RES_TAC wfes_po_iico THEN
FSTAC [partial_order_def, transitive_def, linear_valid_execution_def,
       linear_order_def, domain_def, SUBSET_DEF] THEN
METIS_TAC [mem_access_lem04]);

val lo_cond_collapse12_1 = Q.prove (
`!E X l1 l2 l3.
  well_formed_event_structure E /\ linear_valid_execution E X /\
  (l1, l2) IN lo1 E X /\ (l2, l3) IN lo2 E X /\
  l3 IN memL E X
  ==> 
  (l1, l3) IN lo1 E X`,
RWTAC [lo2_def, lo1_def, localL_def, allL_def, memL_def, lockL_def] THEN
FSTAC [l_e_def] THEN
FSTAC [transitive_def, linear_valid_execution_def,
       linear_order_def, domain_def, SUBSET_DEF] THEN
METIS_TAC [mem_access_lem02, mem_access_lem04]);

val from_lock_lo = Q.prove (
`!E X es l1 l2 e1 e2.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  es IN E.atomicity /\
  e1 IN es /\
  (l_e l1 = SOME e1) /\
  (l_e l2 = SOME e2) /\
  e1 IN mem_accesses E /\
  l1 IN allL E X /\
  l2 IN memL E X /\
  (l1, l2) IN lo_events E X
  ==>
  (e1, e2) IN X.memory_order`,
RWTAC [] THEN
`(e1, e2) IN X.memory_order \/ (e2, e1) IN X.memory_order`
              by (FSTAC [linear_valid_execution_def, linear_order_def,
              mem_access_lem02, memL_def] THEN
                  RWTAC [] THEN
                  FSTAC [l_e_def] THEN
                  METIS_TAC []) THEN
Cases_on `l1 IN memL E X` THENL
[`(l2, l1) IN lo_events E X` by RWTAC [lo_events_def, lo1_def] THEN
     IMP_RES_TAC lo_events_asym THEN
     FSTAC [antisym_def, memL_def] THEN
     RES_TAC THEN
     RWTAC [] THEN
     FSTAC [l_e_def] THEN
     RWTAC [] THEN
     FSTAC [] THEN
     METIS_TAC [],
 `e1 IN mem_writes E /\ (l1 = WEvt e1)` 
              by (FSTAC [allL_def, lockL_def, l_e_def] THEN
                  METIS_TAC [lo_events_dom_rng, localL_memL_lem]) THEN
     RWTAC [] THEN
     FSTAC [l_e_def, lo_events_def, rcomp_def] THEN
     RWTAC [] THENL
     [FSTAC [lo1_def],
      FSTAC [memL_def] THEN
          METIS_TAC [mem_access_lem02, lo2_lock_mem_order, l_e_def, THE_DEF],
      FSTAC [lo1_def],
      IMP_RES_TAC lo1_mem_dom_rng THEN
          `(e1, e) IN X.memory_order` 
                   by METIS_TAC [mem_access_lem02, lo2_lock_mem_order, l_e_def] THEN
          RWTAC [] THEN
          FSTAC [lo1_def, transitive_def, antisym_def, linear_valid_execution_def, 
                 linear_order_def] THEN
          METIS_TAC [THE_DEF],
      RESOLVE [lo_cond_collapse12_1] THEN
          IMP_RES_TAC lo1_mem_dom_rng THEN
          `(e1, e) IN X.memory_order`
                   by METIS_TAC [mem_access_lem02, lo2_lock_mem_order, l_e_def] THEN
          RWTAC [] THEN
          FSTAC [lo1_def, transitive_def, antisym_def, linear_valid_execution_def, 
                 linear_order_def] THEN
          METIS_TAC [THE_DEF],
      FSTAC [lo3_def] THEN 
          IMP_RES_TAC lo1_mem_dom_rng THEN
          RWTAC [] THEN
          FSTAC [] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          RWTAC [] THEN
          `(e1, e) IN X.memory_order`
                   by METIS_TAC [mem_access_lem02, lo2_lock_mem_order, l_e_def] THEN
          RWTAC [] THEN
          FSTAC [lo1_def, transitive_def, antisym_def, linear_valid_execution_def, 
                 linear_order_def] THEN
          METIS_TAC [THE_DEF, l_e_def],
      RESOLVE [lo_cond_collapse12_1] THEN
          FSTAC [lo3_def] THEN 
          IMP_RES_TAC lo1_mem_dom_rng THEN
          RWTAC [] THEN
          FSTAC [] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          RWTAC [] THEN
          `(e1, e) IN X.memory_order`
                   by METIS_TAC [mem_access_lem02, lo2_lock_mem_order, l_e_def] THEN
          RWTAC [] THEN
          FSTAC [lo1_def, transitive_def, antisym_def, linear_valid_execution_def, 
                 linear_order_def] THEN
          METIS_TAC [THE_DEF, l_e_def],
      FSTAC [lo1_def],
      RESOLVE [lo_cond_collapse142_1] THEN
          IMP_RES_TAC lo1_mem_dom_rng THEN
          RWTAC [] THEN
          FSTAC [] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          RWTAC [] THEN
          `(e1, e) IN X.memory_order`
                   by METIS_TAC [mem_access_lem02, lo2_lock_mem_order, l_e_def] THEN
          RWTAC [] THEN
          FSTAC [lo1_def, transitive_def, antisym_def, linear_valid_execution_def, 
                 linear_order_def] THEN
          METIS_TAC [THE_DEF, l_e_def],
      RESOLVE [lo_cond_collapse142_1] THEN
          FSTAC [lo3_def] THEN
          IMP_RES_TAC lo1_mem_dom_rng THEN
          RWTAC [] THEN
          FSTAC [] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          RWTAC [] THEN
          `(e1, e) IN X.memory_order`
                   by METIS_TAC [mem_access_lem02, lo2_lock_mem_order, l_e_def] THEN
          RWTAC [] THEN
          FSTAC [lo1_def, transitive_def, antisym_def, linear_valid_execution_def, 
                 linear_order_def] THEN
          METIS_TAC [THE_DEF, l_e_def]]]);

val lo_collapse_6t7_5 = Q.prove (
`!E X l1 l2 l3 l4.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo6 E X /\ (l2, l3) IN lo_events E X /\ (l3, l4) IN lo7 E X
  ==>
  (l1, l4) IN lo5 E X`,
RWTAC [lo5_def, lo6_def, lo7_def, l_es_def] THEN
Cases_on `es = es'` THENL
[FSTAC [allL_def, localL_def, memL_def, lockL_def] THEN
     METIS_TAC [proc_es_unique],
 `LockE p es IN lockL E X /\
  UnlockE p' es' IN lockL E X` by FSTAC [allL_def, memL_def, localL_def] THEN
     FSTAC [lockL_def] THEN
     METIS_TAC [from_lock_lo]]);

val lo_collapse_6t9_5 = Q.prove (
`!E X l1 l2 l3 l4.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo6 E X /\ (l2, l3) IN lo_events E X /\ (l3, l4) IN lo9 E X
  ==>
  (l1, l4) IN lo5 E X`,
RWTAC [lo5_def, lo6_def, lo9_def, l_es_def] THEN
Cases_on `es = es'` THENL
[FSTAC [allL_def, localL_def, memL_def, lockL_def] THEN
     METIS_TAC [proc_es_unique],
 `LockE p es IN lockL E X /\
  LockE p' es' IN lockL E X` by FSTAC [allL_def, memL_def, localL_def] THEN
     FSTAC [lockL_def] THEN
     `(e, e') IN X.memory_order` by METIS_TAC [from_lock_lo] THEN
     FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
     METIS_TAC []]);

val mo_to_po_iico = Q.prove (
`!E X es e1 e2.
  linear_valid_execution E X /\
  es IN E.atomicity /\
  e1 IN es /\
  (e1, e2) IN X.memory_order /\
  (proc e1 = proc e2) /\
  e1.iiid <> e2.iiid
  ==>
  (e1, e2) IN po_iico E`,
RWTAC [] THEN
`e1 IN mem_accesses E /\ e2 IN mem_accesses E`
        by (METIS_TAC [lem06]) THEN
`(e2, e1) NOTIN po_iico E`
        by (CCONTR_TAC THEN
            FSTAC [linear_order_def, antisym_def, linear_valid_execution_def] THEN
            METIS_TAC [mem_access_lem02]) THEN
`e1.iiid.poi <> e2.iiid.poi`
        by (FSTAC [proc_def] THEN
            Cases_on `e1.iiid` THEN
            Cases_on `e2.iiid` THEN
            FSTAC [] THEN
            METIS_TAC []) THEN
FSTAC [proc_def, mem_accesses_def, po_iico_def, po_strict_def] THEN
`e1.iiid.poi < e2.iiid.poi \/ e1.iiid.poi < e2.iiid.poi` 
         by METIS_TAC [LESS_LESS_CASES] THEN
RWTAC [] THEN
FSTAC []);

val collapse_lem = Q.prove (
`!E X e1 l2 e2.
  (l_e l2 = SOME e2) /\
  l2 IN allL E X /\
  l2 NOTIN memL E X /\
  e1 IN mem_accesses E /\
  e2 IN mem_accesses E /\
  (e1, e2) IN po_iico E
  ==>
  ?l1.
    (l_e l1 = SOME e1) /\
    l1 IN localL E X /\
    (l1, l2) IN lo_events E X`,
RWTAC [allL_def, memL_def, localL_def, lockL_def] THEN
FSTAC [l_e_def, GSYM mem_access_lem03] THEN
RWTAC [] THEN
FSTAC [] THEN
FSTAC [fences_def, mem_accesses_def] THEN
FSTAC [] THEN
Cases_on `d` THENL
[Cases_on `?ew. (ew, e1) IN X.rfmap` THEN
     FSTAC [] THENL
     [Q.EXISTS_TAC `REvt e1 (SOME ew)`,
      Q.EXISTS_TAC `REvt e1 NONE`],
 Q.EXISTS_TAC `WEvt e1`] THEN
RWTAC [l_e_def, writes_def, reads_def, range_def, lo_events_def, rcomp_def] THEN
FSTAC [writes_def] THEN
NTAC 8 DISJ1_TAC THEN
DISJ2_TAC THEN
RWTAC [lo2_def, l_e_def, allL_def, localL_def, memL_def, lockL_def, reads_def,
       writes_def, range_def]);

val lo_collapse_8t7_5 = Q.prove (
`!E X l1 l2 l3 l4.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo8 E X /\ (l2, l3) IN lo_events E X /\ (l3, l4) IN lo7 E X
  ==>
  (l1, l4) IN lo5 E X`,
RWTAC [lo5_def, lo7_def, lo8_def, l_es_def] THEN
Cases_on `es = es'` THENL
[FSTAC [allL_def, localL_def, memL_def, lockL_def] THEN
     METIS_TAC [proc_es_unique],
 `UnlockE p es IN lockL E X /\ UnlockE p' es' IN lockL E X` 
                  by FSTAC [allL_def, memL_def, localL_def] THEN
     RWTAC [] THEN
     FSTAC [lockL_def] THEN
     Cases_on `l2 IN memL E X` THEN
     FSTAC [] THENL
     [`e IN mem_accesses E /\ e'' IN mem_accesses E` 
                   by (FSTAC [memL_def, mem_access_lem02] THEN
                       RWTAC [] THEN
                       FSTAC [l_e_def] THEN
                       RWTAC []) THEN
          `(e'', e) IN X.memory_order \/ (e, e'') IN X.memory_order`
                   by (FSTAC [linear_order_def, linear_valid_execution_def] THEN
                       METIS_TAC []) THENL
          [`(l3,l2) IN lo_events E X` by RWTAC [lo_events_def, lo1_def] THEN
               IMP_RES_TAC lo_events_asym THEN
               FSTAC [antisym_def] THEN
               METIS_TAC [SOME_11],
           FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
               METIS_TAC []],
      `proc e' IN proc_es es` 
             by (RWTAC [proc_es_def] THEN
                 METIS_TAC []) THEN
          `proc e = proc e'` by METIS_TAC [proc_es_unique] THEN
          `e.iiid <> e'.iiid`
                     by (FSTAC [well_formed_event_structure_def, mem_accesses_def] THEN
                         METIS_TAC []) THEN
          `(e', e) IN po_iico E`
                     by METIS_TAC [mo_to_po_iico] THEN
          `e' IN mem_accesses E`
                  by (METIS_TAC [lem06]) THEN
          `?l1. (l_e l1 = SOME e') /\ l1 IN allL E X /\ (l1, l2) IN lo_events E X`
                    by METIS_TAC [collapse_lem, allL_def, IN_UNION] THEN
          `(l1, l3) IN lo_events E X`
                    by METIS_TAC [lo_events_trans, transitive_def] THEN
          `(e', e'') IN X.memory_order` by METIS_TAC [from_lock_lo] THEN
          FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
          METIS_TAC []]]);

val lock_lem = Q.prove (
`!E X es1 es2 e1 e2 e3.
  linear_valid_execution E X /\
  es1 IN E.atomicity /\
  es2 IN E.atomicity /\
  e1 IN mem_accesses E /\
  e2 IN mem_accesses E /\
  e3 IN mem_accesses E /\
  e1 IN es1 /\
  (e2 NOTIN es1 \/ e2 NOTIN es2) /\
  e3 IN es2 /\
  (e1, e2) IN X.memory_order /\
  (e2, e3) IN X.memory_order
  ==>
  es1 <> es2`,
RWTAC [linear_valid_execution_def, linear_order_def, antisym_def] THEN
CCONTR_TAC THEN
FSTAC [] THEN
METIS_TAC []);

val lo_collapse_8t9_5 = Q.prove (
`!E X l1 l2 l3 l4.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo8 E X /\ (l2, l3) IN lo_events E X /\ (l3, l4) IN lo9 E X
  ==>
  (l1, l4) IN lo5 E X`,
RWTAC [lo5_def, lo9_def, lo8_def, l_es_def] THEN
`UnlockE p es IN lockL E X /\ UnlockE p' es' IN lockL E X` 
                  by FSTAC [allL_def, memL_def, localL_def] THEN
FSTAC [lockL_def] THEN
Cases_on `l2 IN memL E X` THEN
FSTAC [] THENL
[`e IN mem_accesses E /\ e'' IN mem_accesses E` 
              by (FSTAC [memL_def, mem_access_lem02] THEN
                  RWTAC [] THEN
                  FSTAC [l_e_def] THEN
                  RWTAC []) THEN
     `e' IN mem_accesses E /\ e''' IN mem_accesses E`
              by (METIS_TAC [lem06]) THEN
     `(e'', e) IN X.memory_order \/ (e, e'') IN X.memory_order`
              by (FSTAC [linear_order_def, linear_valid_execution_def] THEN
                  METIS_TAC []) THENL
     [`(l3,l2) IN lo_events E X` by RWTAC [lo_events_def, lo1_def] THEN
          IMP_RES_TAC lo_events_asym THEN
          `(e = e'') /\ (e', e''') IN X.memory_order`
                   by (FSTAC [antisym_def, linear_valid_execution_def, linear_order_def,
                              transitive_def] THEN
                       METIS_TAC [SOME_11]) THEN
          RWTAC [] THENL
          [IMP_RES_TAC lock_lem,
           METIS_TAC []],
      `(e', e''') IN X.memory_order /\ (e, e''') IN X.memory_order`
                by (FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
                    METIS_TAC []) THEN
          RWTAC [] THENL
          [IMP_RES_TAC lock_lem,
           METIS_TAC []]],
 `proc e' IN proc_es es` 
        by (RWTAC [proc_es_def] THEN
            METIS_TAC []) THEN
     `proc e = proc e'` by METIS_TAC [proc_es_unique] THEN
     `e.iiid <> e'.iiid`
                by (FSTAC [well_formed_event_structure_def, mem_accesses_def] THEN
                    METIS_TAC []) THEN
     `(e', e) IN po_iico E`
                by METIS_TAC [mo_to_po_iico] THEN
     `e' IN mem_accesses E`
             by (METIS_TAC [lem06]) THEN
     `?l1. (l_e l1 = SOME e') /\ l1 IN allL E X /\ (l1, l2) IN lo_events E X`
               by METIS_TAC [collapse_lem, allL_def, IN_UNION] THEN
     `(l1, l3) IN lo_events E X`
               by METIS_TAC [lo_events_trans, transitive_def] THEN
     `(e', e'') IN X.memory_order` by METIS_TAC [from_lock_lo] THEN
     `(e', e''') IN X.memory_order`
            by (FSTAC [linear_valid_execution_def, linear_order_def, transitive_def] THEN
                METIS_TAC []) THEN
     RWTAC [] THENL
     [`e'' IN mem_accesses E /\ e''' IN mem_accesses E`
             by (METIS_TAC [lem06]) THEN
          IMP_RES_TAC lock_lem,
      METIS_TAC []]]);

val lo_cycle_96t = Q.prove (
`!E X l1 l2 l3.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo9 E X /\ (l2, l3) IN lo6 E X /\ (l3, l1) IN lo_events E X
  ==>
  F`,
RWTAC [lo9_def, lo6_def] THEN
CCONTR_TAC THEN
FSTAC [] THEN
`e IN mem_accesses E /\ e' IN mem_accesses E` by METIS_TAC [lem06] THEN
`es IN E.atomicity` by FSTAC [lockL_def, localL_def, memL_def, allL_def] THEN
`(e, e'') IN X.memory_order`
          by (FSTAC [linear_valid_execution_def, linear_order_def, antisym_def] THEN
              METIS_TAC []) THEN
FSTAC [] THEN
`(e'', e) IN X.memory_order`
          by METIS_TAC [from_lock_lo] THEN
FSTAC [linear_valid_execution_def, linear_order_def, antisym_def] THEN
METIS_TAC []);

val cycle_78t_lem = Q.prove (
`!E X l2 e1 e2 es.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  es IN E.atomicity /\
  (WEvt e1, l2) IN lo_events E X /\
  e1 IN mem_writes E /\
  e2 IN es /\
  (l_e l2 = SOME e2) /\
  l2 IN memL E X /\
  (e2, e1) IN po_iico E
  ==>
  (e1 = e2)`,
RWTAC [] THEN
FSTAC [memL_def] THENL
[FSTAC [lo_events_def, rcomp_def] THENL
     [FSTAC [lo1_def, memL_def],
      FSTAC [lo2_def, localL_def],
      FSTAC [lo1_def, memL_def],
      FSTAC [lo2_def, lo1_def, l_e_def] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          RWTAC [] THEN
          FSTAC [localL_def, memL_def] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          RWTAC [] THEN
          IMP_RES_TAC wfes_po_iico THEN
          FSTAC [partial_order_def, transitive_def] THEN
          `(e, er) IN po_iico E` by METIS_TAC [] THEN
          FSTAC [linear_order_def, linear_valid_execution_def, antisym_def] THEN
          `(e, er) IN X.memory_order` by METIS_TAC [mem_access_lem02] THEN
          METIS_TAC [events_disj, mem_access_lem02],
      FSTAC [lo2_def, localL_def],
      FSTAC [lo3_def, lo2_def, lo1_def, l_e_def] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          RWTAC [] THEN
          FSTAC [localL_def, memL_def] THEN
          RWTAC [] THEN
          FSTAC [l_e_def] THEN
          RWTAC [] THEN
          IMP_RES_TAC wfes_po_iico THEN
          IMP_RES_TAC lem06 THEN
          FSTAC [linear_order_def, linear_valid_execution_def, antisym_def,
                 partial_order_def, transitive_def] THEN
          METIS_TAC [],
      FSTAC [lo2_def, localL_def],
      FSTAC [lo2_def, localL_def],
      FSTAC [lo2_def, localL_def],
      FSTAC [lo2_def, localL_def]],
 `(l2, WEvt e1) IN lo_events E X`
         by (RWTAC [lo_events_def, lo2_def, localL_def, l_e_def] THEN
             FSTAC [l_e_def] THEN 
             METIS_TAC [mem_access_lem03, mem_access_lem04]) THEN
     IMP_RES_TAC lo_events_asym THEN
     FSTAC [antisym_def] THEN
     RES_TAC THEN
     FSTAC [l_e_def] THEN
     RWTAC [],
 `(l2, WEvt e1) IN lo_events E X`
         by (RWTAC [lo_events_def, lo2_def, localL_def, l_e_def] THEN
             FSTAC [l_e_def] THEN 
             METIS_TAC [mem_access_lem03, mem_access_lem04]) THEN
     IMP_RES_TAC lo_events_asym THEN
     FSTAC [antisym_def] THEN
     RES_TAC THEN
     FSTAC [l_e_def] THEN
     RWTAC []]);

val lo_cycle_78t = Q.prove (
`!E X l1 l2 l3.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo7 E X /\ (l2, l3) IN lo8 E X /\ (l3, l1) IN lo_events E X
  ==>
  F`,
RWTAC [lo7_def, lo8_def] THEN
CCONTR_TAC THEN
FSTAC [] THEN
`e'' IN mem_accesses E /\ e' IN mem_accesses E` by METIS_TAC [lem06] THEN
`e IN mem_accesses E`
         by (FSTAC [memL_def] THEN
             RWTAC [] THEN
             FSTAC [l_e_def] THEN
             RWTAC [] THEN
             METIS_TAC [mem_access_lem02]) THEN
`es IN E.atomicity` by FSTAC [lockL_def, localL_def, memL_def, allL_def] THEN
`(e, e') IN X.memory_order`
          by (FSTAC [linear_valid_execution_def, linear_order_def, antisym_def] THEN
              METIS_TAC []) THEN
FSTAC [] THENL
[`(l1, l3) IN lo_events E X` by RWTAC [lo_events_def, lo1_def] THEN
     IMP_RES_TAC lo_events_asym THEN
     FSTAC [antisym_def] THEN
     METIS_TAC [SOME_11],
 Cases_on `l3 IN memL E X` THENL
     [`(l1, l3) IN lo_events E X` by RWTAC [lo_events_def, lo1_def] THEN
          IMP_RES_TAC lo_events_asym THEN
          FSTAC [antisym_def] THEN
          METIS_TAC [SOME_11],
      `proc e' IN proc_es es` 
        by (FSTAC [proc_es_def, allL_def, localL_def, memL_def, lockL_def] THEN
            METIS_TAC []) THEN
     `proc e IN proc_es es` 
              by (RWTAC [proc_es_def] THEN
                  METIS_TAC []) THEN
     `proc e = proc e'` by METIS_TAC [proc_es_unique] THEN
     `e.iiid <> e'.iiid`
                by (FSTAC [well_formed_event_structure_def, mem_accesses_def] THEN
                    METIS_TAC []) THEN
     `(e, e') IN po_iico E`
                by METIS_TAC [mo_to_po_iico] THEN
     `l3 IN localL E X`
                by (FSTAC [allL_def, localL_def, memL_def, lockL_def] THEN
                    RWTAC [] THEN
                    FSTAC [l_e_def]) THEN
     `(l3 = WEvt e') /\ e' IN mem_writes E` 
                by METIS_TAC [localL_memL_lem] THEN
     METIS_TAC [cycle_78t_lem]]]);

val lo_events_lem = Q.prove (
`!E X es1 es2 es3 e1 e2 e1' e2'.
  well_formed_event_structure E /\ linear_valid_execution E X /\
  (e1, e2) IN X.memory_order /\ (e1', e2') IN X.memory_order /\
  es1 IN E.atomicity /\ es2 IN E.atomicity /\ es3 IN E.atomicity /\
  e1 IN es1 /\ e2 IN es2 /\ e1' IN es2 /\ e2' IN es3 /\
  es1 <> es2 /\ es2 <> es3
  ==>
  e1 NOTIN es2 /\ es1 <> es3`,
RWTAC [] THEN
`e1 IN mem_accesses E /\ e2 IN mem_accesses E /\ 
 e1' IN mem_accesses E /\ e2' IN mem_accesses E`
             by (METIS_TAC [lem06]) THEN
RWTAC [linear_valid_execution_def] THEN
`e1 NOTIN es2 /\ e1' NOTIN es1`
        by (FSTAC [well_formed_event_structure_def] THEN 
            METIS_TAC [per_disj]) THEN
RWTAC [] THEN
`(e1, e1') IN X.memory_order` 
       by (FSTAC [linear_valid_execution_def, linear_order_def, antisym_def] THEN
           METIS_TAC []) THEN
FSTAC [linear_valid_execution_def, linear_order_def, antisym_def] THEN
METIS_TAC []);

local
val TAC =
`e1 NOTIN es' /\ es <> es'''` 
          by (MATCH_MP_TAC lo_events_lem THEN
              RWTAC [] THEN
              METIS_TAC []) THEN
`e1 IN mem_accesses E /\ e2 IN mem_accesses E /\ 
 e1' IN mem_accesses E /\ e2' IN mem_accesses E`
             by (METIS_TAC [lem06]) THEN
FSTAC [linear_valid_execution_def] THEN
RWTAC [] THEN
`(e1, e1') IN X.memory_order` 
       by (FSTAC [linear_order_def, antisym_def] THEN
           METIS_TAC []) THEN
FSTAC [linear_order_def, transitive_def] THEN
METIS_TAC [];
in
val lo5_trans = Q.prove (
`!E X l1 l2 l3.
  well_formed_event_structure E /\ linear_valid_execution E X /\
  (l1, l2) IN lo5 E X /\ (l2, l3) IN lo5 E X ==> (l1, l3) IN lo5 E X`,
RWTAC [lo5_def, lockL_def] THEN
FSTAC [l_es_def] THENL
[METIS_TAC [],
 METIS_TAC [],
 METIS_TAC [],
 METIS_TAC [],
 METIS_TAC [],
 TAC,
 TAC,
 METIS_TAC [],
 METIS_TAC [],
 TAC,
 TAC,
 METIS_TAC [],
 TAC,
 TAC,
 METIS_TAC [],
 METIS_TAC [],
 TAC,
 TAC,
 METIS_TAC [],
 METIS_TAC []]);
end;

val lo5_asym = Q.prove (
`!E X l1 l2.
  well_formed_event_structure E /\ linear_valid_execution E X /\
  (l1, l2) IN lo5 E X /\ (l2, l1) IN lo5 E X ==> (l1 = l2)`,
RWTAC [lo5_def, lockL_def] THEN
FSTAC [l_es_def] THEN
METIS_TAC [lo_events_lem]);

val lo68_def = Define `
  lo68 E X = lo6 E X UNION lo8 E X`;

val lo79_def = Define `
  lo79 E X = lo7 E X UNION lo9 E X`;

val lo_lock_collapse = Q.prove (
`!E X l1 l2 l3 l4.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo68 E X /\ (l2, l3) IN lo_events E X /\ (l3, l4) IN lo79 E X
  ==>
  (l1, l4) IN lo5 E X`,
RWTAC [lo68_def, lo79_def] THEN
METIS_TAC [lo_collapse_6t9_5, lo_collapse_6t7_5, lo_collapse_8t9_5,
           lo_collapse_8t7_5]);

val lo_def = Define `
  lo E X =
    lo_events E X UNION
    lo5 E X UNION
    rcomp (lo5 E X) (rcomp (lo68 E X) (lo_events E X)) UNION
    rcomp (lo5 E X) (rcomp (lo68 E X) (lo_events E X)) UNION
    rcomp (lo_events E X) (rcomp (lo79 E X) (lo5 E X)) UNION
    rcomp (lo_events E X) (rcomp (lo79 E X) (rcomp (lo5 E X) (rcomp (lo68 E X) (lo_events E X))))`;

val lo_trans = Q.prove (
`!E X. 
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  transitive (lo E X)`,
RWTAC [transitive_def, lo_def, rcomp_def] THEN
RESOLVE [lo_lock_collapse,
         SIMP_RULE std_ss [transitive_def] lo_events_trans,
         SIMP_RULE std_ss [transitive_def] lo5_trans,
         lo_disjoint] THEN
METIS_TAC []);

val lo_asym = Q.prove (
`!E X. 
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  antisym (lo E X)`,
RWTAC [antisym_def, lo_def, rcomp_def] THEN
RESOLVE [lo_lock_collapse,
         SIMP_RULE std_ss [transitive_def] lo_events_trans,
         SIMP_RULE std_ss [transitive_def] lo5_trans,
         SIMP_RULE std_ss [antisym_def] lo_events_asym, 
         SIMP_RULE std_ss [antisym_def] lo5_asym] THEN
FSTAC [lo68_def, lo79_def] THEN
RESOLVE [lo_disjoint, lo_cycle_96t, lo_cycle_78t]);

val label_order_def = Define `
label_order E X =
  { (l, l') | l IN memL E X /\ l' IN memL E X /\ 
       (THE (l_e l), THE (l_e l')) IN X.memory_order} UNION
  { (l, l') | l IN localL E X /\ l' IN localL E X /\
       (THE (l_e l), THE (l_e l')) IN po_iico E } UNION
  { (WEvt e, TauEvt e) | WEvt e IN allL E X /\ TauEvt e IN allL E X } UNION
  { (TauEvt e, BEvt e') | TauEvt e IN allL E X /\ BEvt e' IN allL E X /\
       e' IN mfences E /\ (e, e') IN po_iico E } UNION
  { (TauEvt e, LockE p es ) | TauEvt e IN allL E X /\ LockE p es IN allL E X /\
       e NOTIN es /\ ?e'. e' IN es /\ e' IN mem_accesses E /\ (e, e') IN po_iico E } UNION
  { (LockE p es, l) | LockE p es IN allL E X /\ l IN allL E X /\
       ?e. (l_e l = SOME e) /\ e IN es /\ e IN mem_accesses E } UNION
  { (l, UnlockE p es) | l IN memL E X /\ UnlockE p es IN allL E X /\
       ?e. (l_e l = SOME e) /\ e IN es } UNION
  { (UnlockE p es, l) | UnlockE p es IN allL E X /\ l IN allL E X /\
       ?e e'. (l_e l = SOME e) /\ e' IN es /\ e NOTIN es /\
              (e', e) IN X.memory_order /\
              (l IN memL E X \/ (e IN mem_accesses E /\ (proc e = p))) } UNION
  { (l, LockE p es) | l IN memL E X /\ LockE p es IN allL E X /\
       ?e e'. (l_e l = SOME e) /\ e' IN es /\ e NOTIN es /\
              (e, e') IN X.memory_order } UNION
  { (UnlockE p es, LockE p' es') | UnlockE p es IN allL E X /\ LockE p' es' IN allL E X /\
       es <> es' /\ ?e e'. e IN es /\ e' IN es' /\ (e, e') IN X.memory_order } UNION
  { (WEvt e, WEvt e') | WEvt e IN allL E X /\ WEvt e' IN allL E X /\
       (e, e') IN X.memory_order /\ (proc e = proc e') }`;

val lo_events_refl = Q.prove (
`!E X l.
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l IN localL E X \/ l IN memL E X)
  ==> 
  (l, l) IN lo_events E X`,
RWTAC [lo_events_def, rcomp_def] THEN
METIS_TAC [lo1_refl, lo2_refl]);

val lo68_expand = Q.prove (
`!E X l1 l2. 
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo68 E X ==>
  (l1, l1) IN lo5 E X /\
  (l2, l2) IN lo_events E X`,
RWTAC [lo68_def, lo8_def, lo6_def, lo5_def] THENL
[FSTAC [allL_def, localL_def, lockL_def, memL_def, l_e_def],
 `l2 IN memL E X \/ l2 IN localL E X`
        by (FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
            RWTAC [] THEN
            FSTAC [l_e_def]) THEN
     METIS_TAC [lo_events_refl],
 FSTAC [allL_def, localL_def, lockL_def, memL_def, l_e_def],
 `l2 IN memL E X \/ l2 IN localL E X`
        by (FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
            RWTAC [] THEN
            FSTAC [l_e_def]) THEN
     METIS_TAC [lo_events_refl]]);

val lo79_expand = Q.prove (
`!E X l1 l2. 
  well_formed_event_structure E /\
  linear_valid_execution E X /\
  (l1, l2) IN lo79 E X ==>
  (l1, l1) IN lo_events E X /\
  (l2, l2) IN lo5 E X`,
RWTAC [lo79_def, lo7_def, lo9_def, lo5_def] THENL
[`l1 IN memL E X \/ l1 IN localL E X`
        by (FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
            RWTAC [] THEN
            FSTAC [l_e_def]) THEN
     METIS_TAC [lo_events_refl],
 FSTAC [allL_def, localL_def, lockL_def, memL_def, l_e_def],
 `l1 IN memL E X \/ l1 IN localL E X`
        by (FSTAC [allL_def, memL_def, localL_def, lockL_def] THEN
            RWTAC [] THEN
            FSTAC [l_e_def]) THEN
     METIS_TAC [lo_events_refl],
 FSTAC [allL_def, localL_def, lockL_def, memL_def, l_e_def]]);

val lo_partial_order = Q.store_thm ("lo_partial_order",
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  partial_order (lo E X) (allL E X)`,
RWTAC [partial_order_def, domain_def, range_def, SUBSET_DEF, lo_trans,
       lo_asym, lo_events_refl] THENL
[FSTAC [lo_def, lo5_def, rcomp_def] THEN
     IMP_RES_TAC lo_events_dom_rng2 THEN
     FSTAC [allL_def, lockL_def],
 FSTAC [lo_def, lo5_def, rcomp_def] THEN
     IMP_RES_TAC lo_events_dom_rng2 THEN
     FSTAC [allL_def, lockL_def],
 RWTAC [reflexive_def] THEN
     FSTAC [allL_def, lo_def, lo5_def, lockL_def, rcomp_def] THEN
     METIS_TAC [lo_events_refl]]);

val to_memL_inj = Q.prove (
`!E X e1 e2. (to_memL E X e1 = to_memL E X e2) ==> (e1 = e2)`,
RWTAC [to_memL_def]);

val to_memL_rng = Q.prove (
`!E X e e' p es ew_opt. 
  to_memL E X e <> WEvt e' /\
  to_memL E X e <> BEvt e' /\
  to_memL E X e <> LockE p es /\
  to_memL E X e <> UnlockE p es /\
  ((REvt e' ew_opt = to_memL E X e) ==> (e' = e))`,
RWTAC [to_memL_def]); 

val lo1_finite_prefixes = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes (lo1 E X) (allL E X)`,
RWTAC [lo1_alt_equiv, lo1_alt_def] THEN
`finite_prefixes {(to_memL E X e,to_memL E X e') | (e,e') | (e,e') IN X.memory_order}
                 (IMAGE (to_memL E X) (mem_accesses E))`
          by (MATCH_MP_TAC finite_prefixes_inj_image THEN
              FSTAC [linear_valid_execution_def] THEN
              METIS_TAC [to_memL_inj]) THEN
`IMAGE (to_memL E X) (mem_accesses E) = memL E X`
          by (RWTAC [EXTENSION, to_memL_def, memL_def] THEN
              EQ_TAC THEN
              RWTAC [] THEN
              RWTAC [] THEN
              FSTAC [range_def] THEN
              METIS_TAC [mem_access_lem02, events_disj, lo1_alt_lem,
                         valid_ex_equiv_thm1]) THEN
FSTAC [] THEN
FSTAC [memL_def, allL_def, lockL_def, localL_def, finite_prefixes_def] THEN
RWTAC [] THEN
RWTAC [to_memL_rng] THEN
Cases_on `er IN mem_reads E` THEN
FSTAC [] THENL
[`{ e' | ?e'' e'''. ((e' = to_memL E X e'') /\ (REvt er NONE = to_memL E X e''')) /\
                    (e'',e''') IN X.memory_order } = {}`
               by (RWTAC [EXTENSION] THEN
                   METIS_TAC [lem06, mem_access_lem03, to_memL_rng]) THEN
     RWTAC [],
 `{ e' | ?e'' e'''. ((e' = to_memL E X e'') /\ (REvt er (SOME ew) = to_memL E X e''')) /\
                    (e'',e''') IN X.memory_order } = {}`
               by (RWTAC [EXTENSION] THEN
                   METIS_TAC [lem06, mem_access_lem03, to_memL_rng]) THEN
     RWTAC []]);

val to_localL_inj = Q.prove (
`!E X e1 e2. (to_localL E X e1 = to_localL E X e2) ==> (e1 = e2)`,
RWTAC [to_localL_def]);

val to_localL_rng = Q.prove (
`!E X e e' p es ew_opt. 
  to_localL E X e <> TauEvt e' /\
  to_localL E X e <> LockE p es /\
  to_localL E X e <> UnlockE p es /\
  ((REvt e' ew_opt = to_localL E X e) ==> (e' = e))`,
RWTAC [to_localL_def]); 

val lo2_finite_prefixes_lem1 = Q.prove (
`!E X. allL E X = localL E X UNION (lockL E X UNION {TauEvt e | e IN mem_writes E})`,
RWTAC [allL_def, lockL_def, localL_def, memL_def, EXTENSION] THEN
EQ_TAC THEN
RWTAC [] THEN
FSTAC [reads_def, mem_reads_def]);

val lo2_finite_prefixes_lem2 = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes {(to_localL E X e,to_localL E X e') | (e,e') | (e,e') IN po_iico E}
                  (allL E X)`,
RWTAC [lo2_finite_prefixes_lem1] THEN
MATCH_MP_TAC finite_prefixes_range THEN
RWTAC [DISJOINT_DEF, range_def, EXTENSION] THENL
[`localL E X = IMAGE (to_localL E X) E.events`
          by (RWTAC [EXTENSION, to_localL_def, localL_def] THEN
              EQ_TAC THENL
              [RWTAC [] THEN
                   FSTAC [COND_RAND] THEN
                   RWTAC [] THEN
                   FSTAC [reads_def, writes_def, fences_def, range_def] THEN
                   METIS_TAC [events_disj, events_cases, lo1_alt_lem,
                              valid_ex_equiv_thm1],
               RWTAC [] THEN
                   RWTAC [] THEN
                   FSTAC [range_def] THEN
                   METIS_TAC [events_disj, events_cases, lo1_alt_lem,
                              valid_ex_equiv_thm1]]) THEN
     RWTAC [] THEN
     MATCH_MP_TAC finite_prefixes_inj_image THEN
     FSTAC [well_formed_event_structure_def] THEN
     METIS_TAC [to_localL_inj],
 CCONTR_TAC THEN 
     FSTAC [lockL_def] THEN
     METIS_TAC [to_localL_rng],
 CCONTR_TAC THEN 
     FSTAC [] THEN
     METIS_TAC [to_localL_rng]]);

val lo2_finite_prefixes_lem3 = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes {(WEvt e,WEvt e') | WEvt e IN allL E X /\ WEvt e' IN allL E X /\
                                      (e,e') IN X.memory_order /\ (proc e = proc e')}
                  (allL E X)`,
RWTAC [] THEN
`finite_prefixes {(WEvt e, WEvt e') | (e,e') | (e,e') IN X.memory_order}
                 (IMAGE WEvt (mem_accesses E))`
          by (MATCH_MP_TAC finite_prefixes_inj_image THEN
              FSTAC [linear_valid_execution_def]) THEN
FSTAC [finite_prefixes_def, allL_def, lockL_def, localL_def, memL_def] THEN
RWTAC [] THEN
Cases_on `e' IN mem_writes E` THEN
FSTAC [mem_access_lem02] THENL
[RES_TAC THEN
     FSTAC [] THEN
     `{ e'' | ?e'''. (e'' = WEvt e''') /\ e''' IN writes E /\
                    (e''',e') IN X.memory_order /\ (proc e''' = proc e')} 
      SUBSET
      {e'' | ?e'''. (e'' = WEvt e''') /\ (e''', e') IN X.memory_order}`
               by RWTAC [SUBSET_DEF] THEN
     METIS_TAC [SUBSET_FINITE],
 `{ e'' | ?e'''. (e'' = WEvt e''') /\ e''' IN writes E /\
                    (e''',e') IN X.memory_order /\ (proc e''' = proc e')} = {}`
               by (RWTAC [EXTENSION] THEN
                   METIS_TAC [lem06, mem_access_lem04, to_memL_rng]) THEN
     RWTAC []]);

val lo2_finite_prefixes_lem4 = Q.prove (
`!E X.
  {(to_localL E X e'',WEvt e) | (e'',e) |
      WEvt e IN allL E X /\ ?e'. WEvt e' IN localL E X /\ (e'',e') IN po_iico E /\
                                 (e',e) IN X.memory_order /\ (proc e' = proc e)}
  = 
  rcomp { (to_localL E X e, to_localL E X e') | (e, e') | (e, e') IN po_iico E }
        { (WEvt e, WEvt e') | WEvt e IN allL E X /\ WEvt e' IN allL E X /\
                                     (e, e') IN X.memory_order /\ (proc e = proc e') }`,
RWTAC [EXTENSION, rcomp_def] THEN
EQ_TAC THEN
RWTAC [GSYM RIGHT_EXISTS_AND_THM, GSYM LEFT_EXISTS_AND_THM] THENL
[MAP_EVERY Q.EXISTS_TAC [`e''`, `e'`, `e'`] THEN
     RWTAC [allL_def, to_localL_def] THEN
     FSTAC [localL_def],
 MAP_EVERY Q.EXISTS_TAC [`e`, `e''`] THEN
     RWTAC [allL_def, to_localL_def] THEN
     FSTAC [localL_def, to_localL_def] THEN
     Cases_on `e' IN writes E` THEN
     FSTAC [] THEN 
     RWTAC [] THEN
     Cases_on `e' IN fences E` THEN
     FSTAC [] THEN
     FSTAC [COND_RAND, COND_RATOR]]);

val lem07 = Q.prove (
`!r1 r2 s.
  finite_prefixes r1 s /\ finite_prefixes r2 s = finite_prefixes (r1 UNION r2) s`,
RWTAC [] THEN
EQ_TAC THEN1
METIS_TAC [INTER_IDEMPOT, finite_prefixes_union] THEN
RWTAC [finite_prefixes_def, UNION_LEM]);

val lo2_finite_prefixes = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes (lo2 E X) (allL E X)`,
RWTAC [lo2_alt_equiv, lo2_alt_def, GSYM lem07,
       lo2_finite_prefixes_lem2, lo2_finite_prefixes_lem3] THEN
REWRITE_TAC [lo2_finite_prefixes_lem4] THEN
MATCH_MP_TAC finite_prefixes_comp THEN
Q.EXISTS_TAC `allL E X` THEN
RWTAC [lo2_finite_prefixes_lem2, lo2_finite_prefixes_lem3] THEN
RWTAC [SUBSET_DEF] THEN
RWTAC []);

val lo3_finite_prefixes = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes (lo3 E X) (allL E X)`,
RWTAC [lo3_def, finite_prefixes_def, allL_def, memL_def, lockL_def, localL_def] THEN
Cases_on `e' IN writes E` THEN
RWTAC []);

val lo4_finite_prefixes = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes (lo4 E X) (allL E X)`,
RWTAC [lo4_def, finite_prefixes_def, allL_def, memL_def, lockL_def, localL_def] THEN
Cases_on `e' IN mfences E` THEN
RWTAC [] THEN
`{e'' | ?e'''. (e'' = TauEvt e''') /\ e''' IN mem_writes E /\ (e''', e') IN po_iico E}
 =
 IMAGE TauEvt {e''' | e''' IN mem_writes E /\ (e''', e') IN po_iico E}`
      by RWTAC [EXTENSION] THEN
RWTAC [] THEN
`{e''' | e''' IN mem_writes E /\ (e''',e') IN po_iico E}
 SUBSET
 {e''' | (e''', e') IN po_iico E}`
        by RWTAC [SUBSET_DEF] THEN
`FINITE {e''' | (e''', e') IN po_iico E}`
          by FSTAC [well_formed_event_structure_def, finite_prefixes_def,
                    mfences_def] THEN
METIS_TAC [SUBSET_FINITE]);

val lem08 = Q.prove (
`!E X x y. (x, y) IN lo2 E X \/ (x, y) IN lo1 E X \/
           (x, y) IN lo3 E X \/ (x, y) IN lo4 E X ==> x IN allL E X`,
RWTAC [lo2_def, lo1_def, allL_def, lo3_def, lo4_def] THEN
METIS_TAC []);

val lo_events_finite_prefixes = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes (lo_events E X) (allL E X)`,
RWTAC [lo_events_def, GSYM lem07] THEN
IMP_RES_TAC lo1_finite_prefixes THEN
IMP_RES_TAC lo2_finite_prefixes THEN
IMP_RES_TAC lo3_finite_prefixes THEN
IMP_RES_TAC lo4_finite_prefixes THEN
REPEAT (MATCH_MP_TAC finite_prefixes_comp THEN 
        Q.EXISTS_TAC `allL E X` THEN
        RWTAC []) THEN
RWTAC [SUBSET_DEF] THEN
FSTAC [rcomp_def] THEN
METIS_TAC [lem08]);

val lem09 = Q.prove (
`!s t. FINITE t ==> FINITE (s INTER t)`,
METIS_TAC [INTER_COMM, INTER_FINITE]);
(*
val lo5_finite_prefixes = Q.prove (
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes (lo5 E X) (allL E X)`,
RWTAC [lo5_def, GSYM lem07] THENL
[RWTAC [finite_prefixes_def, lockL_def, allL_def, memL_def, localL_def],
 RWTAC [finite_prefixes_def, lockL_def, allL_def, memL_def, localL_def],
 ALL_TAC,
 RWTAC [finite_prefixes_def, lockL_def, allL_def, memL_def, localL_def]]

RWTAC [finite_prefixes_def, lockL_def, allL_def, memL_def, localL_def, l_es_def] THEN
RWTAC [UNION_LEM, INTER_LEM] THEN
MATCH_MP_TAC lem09 THEN
MATCH_MP_TAC lem09 THEN

RWTAC [RIGHT_OR_EXISTS_THM, LEFT_OR_EXISTS_THM,
       GSYM RIGHT_EXISTS_AND_THM, GSYM LEFT_EXISTS_AND_THM]

STOP;

val lo_finite_prefixes = Q.store_thm ("lo_finite_prefixes",
`!E X.
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  finite_prefixes (lo E X) (allL E X)`,
RWTAC [lo_def, GSYM lem07] THEN
IMP_RES_TAC lo_events_finite_prefixes THEN
REPEAT (MATCH_MP_TAC finite_prefixes_comp THEN 
        Q.EXISTS_TAC `allL E X` THEN
        RWTAC []) THEN
RWTAC [SUBSET_DEF] THEN
FSTAC [rcomp_def] THEN
METIS_TAC [lem08]);
*)

val label_order_superset = Q.store_thm ("label_order_superset",
`!E X. 
  well_formed_event_structure E /\ linear_valid_execution E X
  ==>
  label_order E X SUBSET lo E X`,
RWTAC [label_order_def, lo_def, SUBSET_DEF, rcomp_def] THENL
[RWTAC [lo_events_def, rcomp_def, lo1_def],
 RWTAC [lo_events_def, rcomp_def, lo2_def], 
 RWTAC [rcomp_def, lo_events_def] THEN
     `(WEvt e, TauEvt e) IN lo3 E X` by RWTAC [lo3_def] THEN
     METIS_TAC [lo3_expand],
 RWTAC [rcomp_def, lo_events_def] THEN
     `(TauEvt e, BEvt e') IN lo4 E X` by RWTAC [lo4_def] THEN
     METIS_TAC [lo4_expand],
 FSTAC [memL_def, localL_def, allL_def, lockL_def] THEN
     `(e, e') IN X.memory_order`
                 by (FSTAC [linear_valid_execution_def] THEN
                     METIS_TAC [mem_access_lem02]) THEN
     `(TauEvt e, LockE p es) IN lo79 E X`
           by (FSTAC [lo79_def, lo9_def, l_e_def, memL_def, localL_def, allL_def, lockL_def] THEN
               METIS_TAC []) THEN
     IMP_RES_TAC lo79_expand THEN
     METIS_TAC [],
 `(LockE p es, l) IN lo68 E X` by FSTAC [lo68_def, lo6_def, l_e_def, allL_def] THEN
     IMP_RES_TAC lo68_expand THEN
     METIS_TAC [],
 `(l, UnlockE p es) IN lo79 E X` by FSTAC [lo79_def, lo7_def, l_e_def, allL_def] THEN
     IMP_RES_TAC lo79_expand THEN
     METIS_TAC [],
 `(UnlockE p es, l) IN lo68 E X` 
              by (FSTAC [lo68_def, lo8_def, l_e_def, allL_def, memL_def, 
                         localL_def, lockL_def] THEN
                  RWTAC [] THEN
                  FSTAC [l_e_def] THEN
                  METIS_TAC []) THEN 
     IMP_RES_TAC lo68_expand THEN
     METIS_TAC [],
 `(UnlockE (proc e) es, l) IN lo68 E X` 
              by (FSTAC [lo68_def, lo8_def, l_e_def, allL_def, memL_def, 
                         localL_def, lockL_def] THEN
                  RWTAC [] THEN
                  FSTAC [l_e_def] THEN
                  METIS_TAC []) THEN 
     IMP_RES_TAC lo68_expand THEN
     METIS_TAC [],
 `(l, LockE p es) IN lo79 E X` 
              by (FSTAC [lo79_def, lo9_def, l_e_def, allL_def, memL_def, 
                         localL_def, lockL_def] THEN
                  RWTAC [] THEN
                  FSTAC [l_e_def] THEN
                  METIS_TAC []) THEN 
     IMP_RES_TAC lo79_expand THEN
     METIS_TAC [],
 FSTAC [lo5_def, allL_def, memL_def, localL_def, lockL_def, l_es_def] THEN
     METIS_TAC [],
 RWTAC [lo_events_def, rcomp_def, lo2_def]]);

val _ = export_theory ();
