(*        x86-TSO Semantics: HOL sources                                *)
(*                                                                      *)
(* Scott Owens, Susmit Sarkar, Peter Sewell                             *)
(*                                                                      *)
(*  Computer Laboratory, University of Cambridge                        *)
(*                                                                      *)
(*  Copyright 2007-2009                                                 *)
(*                                                                      *)
(* Redistribution and use in source and binary forms, with or without   *)
(* modification, are permitted provided that the following conditions   *)
(* are met:                                                             *)
(*                                                                      *)
(* 1. Redistributions of source code must retain the above copyright    *)
(*    notice, this list of conditions and the following disclaimer.     *)
(* 2. Redistributions in binary form must reproduce the above copyright *)
(*    notice, this list of conditions and the following disclaimer in   *)
(*    the documentation and/or other materials provided with the        *)
(*    distribution.                                                     *)
(* 3. The names of the authors may not be used to endorse or promote    *)
(*    products derived from this software without specific prior        *)
(*    written permission.                                               *)
(*                                                                      *)
(* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS   *)
(* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *)
(* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *)
(* ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY      *)
(* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *)
(* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *)
(* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *)
(* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *)
(* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *)
(* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *)
(* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *)

(* 
app load ["utilLib", "axiomatic_memory_modelTheory", "basic_lemmasTheory"];
use "linear_valid_executionScript.sml";
*)

open HolKernel boolLib Parse bossLib wordsTheory pred_setTheory;
open optionTheory arithmeticTheory;
open utilTheory set_relationTheory;
open utilLib;
open axiomatic_memory_modelTheory basic_lemmasTheory;
open HolDoc;

val _ = new_theory "linear_valid_execution";

val UNION_LEM = Q.prove (
`!P Q. { x | P x \/ Q x } = {x | P x} UNION {x | Q x}`,
RWTAC [EXTENSION]);

val INTER_LEM = Q.prove (
`!P Q. { x | P x /\ Q x } = {x | P x} INTER {x | Q x}`,
RWTAC [EXTENSION]);

val valid_ex_equiv_thm1 = Q.store_thm ("valid_ex_equiv_thm1",
`!E X. linear_valid_execution E X ==> valid_execution E X`,
RWTAC [valid_execution_def, linear_valid_execution_def] THEN1
METIS_TAC [partial_order_linear_order] THENL
[`mem_writes E SUBSET mem_accesses E` by RWTAC [SUBSET_DEF, mem_access_lem02] THEN 
     METIS_TAC [linear_order_subset],
 `{er | er IN E.events /\ (loc er = loc ew) /\ (er,ew) NOTIN X.memory_order /\
       (ew,er) NOTIN X.memory_order} = {}`
           by (RWTAC [EXTENSION] THEN
               FSTAC [linear_order_def] THEN
               METIS_TAC [mem_access_lem02, mem_access_lem05]) THEN
     RWTAC [],
 METIS_TAC [],
 METIS_TAC [],
 METIS_TAC []]);

val linearlem01 = Q.prove (
`!memory_order memory_order' E.
  linear_order (rrestrict memory_order (mem_writes E)) (mem_writes E) /\
  memory_order SUBSET memory_order' /\
  linear_order memory_order' (mem_accesses E)
  ==>
  linear_order (rrestrict memory_order' (mem_writes E)) (mem_writes E)`,
RWTAC [linear_order_def, transitive_def, antisym_def, SUBSET_DEF, domain_def, in_rrestrict, range_def] THEN
METIS_TAC []);
 
val linearlem02 = Q.prove (
`!E er memory_order memory_order'.
  er IN reads E /\
  linear_order memory_order' (mem_accesses E) /\
  (!er :: (mem_reads E). !ew :: (mem_writes E). 
      (loc er = loc ew) /\ (ew, er) IN memory_order' ==> (ew, er) IN memory_order) /\
  memory_order SUBSET memory_order'
  ==>
  (previous_writes E er memory_order = previous_writes E er memory_order')`,
RWTAC [previous_writes_def, EXTENSION, SUBSET_DEF, linear_order_def, domain_def, range_def] THEN
METIS_TAC [mem_access_lem03, mem_access_lem04]);

val linearlem03 = Q.prove (
`!x s memory_order memory_order'.
  (rrestrict memory_order' s SUBSET rrestrict memory_order s) /\
  x IN maximal_elements s memory_order
  ==>
  x IN maximal_elements s memory_order'`,
RWTAC [rrestrict_def, EXTENSION, maximal_elements_def, SUBSET_DEF] THEN
METIS_TAC []);

val linearlem04 = Q.prove (
`!E memory_order memory_order' s.
  s SUBSET writes E /\
  memory_order SUBSET memory_order' /\
  partial_order memory_order' (mem_accesses E) /\
  linear_order (rrestrict memory_order (mem_writes E)) (mem_writes E)
  ==>
  (rrestrict memory_order' s SUBSET rrestrict memory_order s)`,
RWTAC [EXTENSION, rrestrict_def, SUBSET_DEF, partial_order_def, domain_def, range_def] THEN
`x' IN mem_writes E /\ y IN mem_writes E` 
            by METIS_TAC [mem_access_lem04] THEN
`(x', y) IN memory_order \/ (y, x') IN memory_order` by FSTAC [linear_order_def] THEN
METIS_TAC [antisym_def]);

val linearlem05 = Q.prove (
`!E X memory_order'.
  valid_execution E X /\
  X.memory_order SUBSET memory_order' /\
  linear_order memory_order' (mem_accesses E) /\
  finite_prefixes memory_order' (mem_accesses E) /\
  (!er :: (mem_reads E). !ew :: (mem_writes E). 
    (loc er = loc ew) /\ (ew, er) IN memory_order' ==> (ew, er) IN X.memory_order)
  ==>
  valid_execution E (X with memory_order := memory_order')`,
RWTAC [valid_execution_def] THEN
`partial_order memory_order' (mem_accesses E)`
          by (FSTAC [linear_order_def, partial_order_def, transitive_def, reflexive_def, antisym_def] THEN
              METIS_TAC []) THENL
[METIS_TAC [linearlem01],
 `ew IN mem_accesses E` by FSTAC [mem_access_lem02] THEN
     `{er | er IN E.events /\ (loc er = loc ew) /\ (er,ew) NOTIN memory_order' /\ (ew,er) NOTIN memory_order'} = {}`
             by (RWTAC [EXTENSION] THEN
                 CCONTR_TAC THEN
                 FSTAC [] THEN
                 `x IN mem_accesses E` by METIS_TAC [mem_access_lem05] THEN
                 FSTAC [linear_order_def] THEN
                 METIS_TAC []) THEN
     RWTAC [],
 FSTAC [SUBSET_DEF],
 FSTAC [SUBSET_DEF],
 FSTAC [SUBSET_DEF] THEN
     METIS_TAC [],
 FSTAC [SUBSET_DEF] THEN
     METIS_TAC [],
 FSTAC [SUBSET_DEF] THEN
     METIS_TAC [],
 FSTAC [SUBSET_DEF] THEN
     RES_TAC THEN
     METIS_TAC [],
 FSTAC [check_rfmap_written_def, in_rfmc] THEN
     RWTAC [] THEN
     RES_TAC THEN
     `previous_writes E y X.memory_order = previous_writes E y memory_order'` 
              by METIS_TAC [linearlem02] THEN
     FSTAC [] THEN
     RWTAC [] THEN
     `previous_writes E y memory_order' UNION previous_writes E y (po_iico E) SUBSET writes E`
                by (RWTAC [previous_writes_def, SUBSET_DEF]) THEN
     METIS_TAC [linearlem03, linearlem04],
 FSTAC [check_rfmap_initial_def, previous_writes_def, EXTENSION] THEN
     RWTAC [] THEN
     RES_TAC THEN
     CCONTR_TAC THEN
     FSTAC [] THEN
     `x IN mem_writes E /\ er IN mem_reads E` 
              by (FSTAC [partial_order_def, SUBSET_DEF, domain_def, range_def] THEN
                  METIS_TAC [mem_access_lem04, mem_access_lem03]) THEN
     METIS_TAC []]);

val valid_ex_equiv_thm2 = Q.store_thm ("valid_ex_equiv_thm2",
`!E X memory_order'.
  valid_execution E X /\
  X.memory_order SUBSET memory_order' /\
  linear_order memory_order' (mem_accesses E) /\
  finite_prefixes memory_order' (mem_accesses E) /\
  (!er :: (mem_reads E). !ew :: (mem_writes E). 
    (loc er = loc ew) /\ (ew, er) IN memory_order' ==> (ew, er) IN X.memory_order)
  ==>
  linear_valid_execution E (X with memory_order := memory_order')`,
RWTAC [] THEN
`valid_execution E (X with memory_order := memory_order')` by METIS_TAC [RQ linearlem05] THEN
FSTAC [valid_execution_def, linear_valid_execution_def] THEN
RWTAC [] THEN
METIS_TAC []);

val complete_memory_order_def = Define `
  complete_memory_order E memory_order =
    memory_order UNION 
    { (e1, e2) | ?ew er. (ew, er) NOTIN memory_order /\ (er, ew) NOTIN memory_order /\
                         ew IN mem_writes E /\ er IN mem_reads E /\ (loc ew = loc er) /\
                         (e1, er) IN memory_order /\ (ew, e2) IN memory_order }`;

val linearlem06 = Q.prove (
`!memory_order E e.
  {e' | ?ew er. (ew,er) NOTIN memory_order /\ (er,ew) NOTIN memory_order /\
                ew IN mem_writes E /\ er IN mem_reads E /\ (loc ew = loc er) /\
                (e',er) IN memory_order /\ (ew,e) IN memory_order}
  =
  BIGUNION
    (IMAGE (\er. { e' | (e', er) IN memory_order })
           (BIGUNION
             (IMAGE (\ew. { er | (ew,er) NOTIN memory_order /\ (er,ew) NOTIN memory_order /\
                                 er IN mem_reads E /\ (loc ew = loc er)})
                    { ew | (ew, e) IN memory_order /\ ew IN mem_writes E})))`,
RWTAC [EXTENSION] THEN
EQ_TAC THEN
RWTAC [] THENL
[Q.EXISTS_TAC `{x | (x, er) IN memory_order}` THEN
     RWTAC [] THEN
     Q.EXISTS_TAC `er` THEN
     RWTAC [] THEN
     Q.EXISTS_TAC `{x | (ew, x) NOTIN memory_order /\ (x, ew) NOTIN memory_order /\ (loc ew = loc x) /\ 
                        x IN mem_reads E}` THEN
     RWTAC [] THEN
     Q.EXISTS_TAC `ew` THEN
     RWTAC [] THEN
     EQ_TAC THEN
     RWTAC [],
 METIS_TAC []]); 

val linearlem07 = Q.prove (
`!E X. valid_execution E X 
  ==> 
  partial_order (complete_memory_order E X.memory_order) (mem_accesses E) /\
  finite_prefixes (complete_memory_order E X.memory_order) (mem_accesses E)`,
RWTAC [valid_execution_def, partial_order_def, domain_def, range_def, SUBSET_DEF,
       complete_memory_order_def] THEN1
METIS_TAC [] THEN1
METIS_TAC [] THEN1
METIS_TAC [] THEN1
METIS_TAC [] THENL
[RWTAC [transitive_def] THEN 
     RWTAC [METIS_PROVE [] ``!a b. a \/ b = ~a ==> b``] THENL
     [FSTAC [transitive_def] THEN
          METIS_TAC [],
      FSTAC [transitive_def] THEN
          METIS_TAC [],
      FSTAC [transitive_def] THEN
          METIS_TAC [],
      `(ew, ew') IN X.memory_order \/ (ew', ew) IN X.memory_order`
                  by FSTAC [linear_order_def, rrestrict_def] THEN
          FSTAC [transitive_def] THEN
          METIS_TAC []],
 FSTAC [reflexive_def],
 RWTAC [antisym_def] THENL
     [FSTAC [antisym_def],
      FSTAC [transitive_def] THEN
          METIS_TAC [],
      FSTAC [transitive_def] THEN
          METIS_TAC [],
      `(ew, ew') IN X.memory_order \/ (ew', ew) IN X.memory_order`
                  by FSTAC [linear_order_def, rrestrict_def] THEN
          FSTAC [transitive_def] THEN
          METIS_TAC []],
 RWTAC [finite_prefixes_def, UNION_LEM] THEN1
     FSTAC [finite_prefixes_def, mem_accesses_def] THEN
     RWTAC [linearlem06] THEN
     TRY (MATCH_MP_TAC IMAGE_FINITE) THEN
     RWTAC [INTER_LEM] THENL
     [MATCH_MP_TAC IMAGE_FINITE THEN
          RWTAC [] THEN
          FSTAC [finite_prefixes_def, mem_accesses_def, mem_writes_def],
      `({er | (ew,er) NOTIN X.memory_order} INTER 
       ({er | (er,ew) NOTIN X.memory_order} INTER 
       (mem_reads E INTER {er | loc ew = loc er})))
       SUBSET
       {er | er IN E.events /\ (loc er = loc ew) /\ (er,ew) NOTIN X.memory_order /\ (ew,er) NOTIN X.memory_order}`
               by RWTAC [mem_reads_def, SUBSET_DEF] THEN
          METIS_TAC [SUBSET_FINITE],
      FSTAC [finite_prefixes_def, mem_access_lem02]]]);

val linearlem08 = Q.prove (
`!E X.
  valid_execution E X
  ==> 
  (!er :: (mem_reads E). !ew :: (mem_writes E). 
    (loc er = loc ew) /\ (ew, er) IN complete_memory_order E X.memory_order ==> (ew, er) IN X.memory_order)`,
RWTAC [complete_memory_order_def, valid_execution_def, linear_order_def, partial_order_def, transitive_def] THEN
FSTAC [rrestrict_def] THEN
METIS_TAC [mem_access_lem02]);

val linearlem09 = Q.prove (
`!E memory_order. memory_order SUBSET complete_memory_order E memory_order`,
RWTAC [SUBSET_DEF, complete_memory_order_def]);

val linearlem10 = Q.prove (
`!E memory_order (er :: mem_reads E) (ew :: mem_writes E).
  reflexive memory_order (mem_accesses E) /\ (loc ew = loc er) 
  ==>
  (er, ew) IN complete_memory_order E memory_order \/
  (ew, er) IN complete_memory_order E memory_order`,
RWTAC [complete_memory_order_def, METIS_PROVE [] ``!x y. x \/ y = ~x ==> y``,
       reflexive_def, mem_access_lem02] THEN
METIS_TAC []);

val countableE = Q.prove (
`!E. well_formed_event_structure E ==> countable (mem_accesses E)`,
RWTAC [well_formed_event_structure_def] THEN
`mem_accesses E SUBSET E.events` by RWTAC [SUBSET_DEF, mem_accesses_def] THEN
METIS_TAC [subset_countable]);

val valid_ex_equiv_thm3 = Q.store_thm ("valid_ex_equiv_thm3",
`!E X.
  well_formed_event_structure E /\
  valid_execution E X
  ==>
  ?memory_order'.
    X.memory_order SUBSET memory_order' /\
    linear_order memory_order' (mem_accesses E) /\
    finite_prefixes memory_order' (mem_accesses E) /\
    (!er :: (mem_reads E). !ew :: (mem_writes E). 
      (loc er = loc ew) /\ (ew, er) IN memory_order' ==> (ew, er) IN X.memory_order)`,
RWTAC [] THEN
`?r. linear_order r (mem_accesses E) /\ finite_prefixes r (mem_accesses E) /\ 
      complete_memory_order E X.memory_order SUBSET r`
              by METIS_TAC [linearlem07, linear_order_of_countable_po, countableE] THEN
`X.memory_order SUBSET r` by METIS_TAC [SUBSET_TRANS, linearlem09] THEN
`!(er::mem_reads E) (ew::mem_writes E).
   (loc er = loc ew) /\ (ew,er) IN r ==> (ew,er) IN X.memory_order`
           by (RWTAC [] THEN
               MATCH_MP_TAC (SIMP_RULE (srw_ss()) [GSYM RIGHT_FORALL_IMP_THM, AND_IMP_INTRO] (RQ linearlem08)) THEN
               Q.EXISTS_TAC `E` THEN
               RWTAC [] THEN
               `(er, ew) IN complete_memory_order E X.memory_order \/
                (ew, er) IN complete_memory_order E X.memory_order`
                          by METIS_TAC [RQ linearlem10, valid_execution_def, partial_order_def] THEN
               FSTAC [SUBSET_DEF] THEN
               `er <> ew` 
                        by (CCONTR_TAC THEN 
                            FSTAC [mem_reads_def, mem_writes_def] THEN
                            FSTAC []) THEN
               METIS_TAC [linear_order_def, antisym_def]) THEN
METIS_TAC []);

val _ = export_theory ();
