(*        x86-TSO Semantics: HOL sources                                *)
(*                                                                      *)
(* Scott Owens, Susmit Sarkar, Peter Sewell                             *)
(*                                                                      *)
(*  Computer Laboratory, University of Cambridge                        *)
(*                                                                      *)
(*  Copyright 2007-2009                                                 *)
(*                                                                      *)
(* Redistribution and use in source and binary forms, with or without   *)
(* modification, are permitted provided that the following conditions   *)
(* are met:                                                             *)
(*                                                                      *)
(* 1. Redistributions of source code must retain the above copyright    *)
(*    notice, this list of conditions and the following disclaimer.     *)
(* 2. Redistributions in binary form must reproduce the above copyright *)
(*    notice, this list of conditions and the following disclaimer in   *)
(*    the documentation and/or other materials provided with the        *)
(*    distribution.                                                     *)
(* 3. The names of the authors may not be used to endorse or promote    *)
(*    products derived from this software without specific prior        *)
(*    written permission.                                               *)
(*                                                                      *)
(* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS   *)
(* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED    *)
(* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   *)
(* ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY      *)
(* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL   *)
(* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE    *)
(* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS        *)
(* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,         *)
(* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING            *)
(* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   *)
(* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.         *)

(* 
app load ["utilLib", "axiomatic_memory_modelTheory", "lts_memory_modelTheory"];
use "basic_lemmasScript.sml";
*)

open HolKernel boolLib Parse bossLib pred_setTheory arithmeticTheory; 
open utilLib utilTheory set_relationTheory;
open axiomatic_memory_modelTheory lts_memory_modelTheory; 

val _ = new_theory "basic_lemmas";

val in_rfmc = 
  GEN_ALL (REWRITE_CONV [reads_from_map_candidates_def, Once SPECIFICATION] 
  ``rfmap IN reads_from_map_candidates E``);

val _ = save_thm ("in_rfmc", in_rfmc);

val mem_access_lem01 = Q.store_thm ("mem_access_lem01",
`!E e. e IN mem_accesses E = e IN E.events /\ is_mem_access e`,
RWTAC [mem_accesses_def, is_mem_access_def]);

val mem_access_lem02 = Q.store_thm ("mem_access_lem02",
`!e E. e IN mem_accesses E = e IN mem_reads E \/ e IN mem_writes E`,
RWTAC [mem_accesses_def, mem_reads_def, mem_writes_def] THEN
METIS_TAC [dirn_nchotomy]);

val mem_access_lem03 = Q.store_thm ("mem_access_lem03",
`!e E. e IN mem_accesses E /\ e IN reads E = e IN mem_reads E`,
RWTAC [mem_accesses_def, mem_reads_def, reads_def] THEN
METIS_TAC [action_11]);

val mem_access_lem04 = Q.store_thm ("mem_access_lem04",
`!e E. e IN mem_accesses E /\ e IN writes E = e IN mem_writes E`,
RWTAC [mem_accesses_def, mem_writes_def, writes_def] THEN
METIS_TAC [action_11]);

val mem_access_lem05 = Q.store_thm ("mem_access_lem05",
`!E e1 e2.
  e1 IN mem_accesses E /\
  e2 IN E.events /\
  (loc e1 = loc e2)
  ==>
  e2 IN mem_accesses E`,
RWTAC [mem_access_lem01, is_mem_access_def, loc_def] THEN
Cases_on `e1.action` THEN
Cases_on `e2.action` THEN
FSTAC []);

val wfes_intra = Q.store_thm ("wfes_intra",
`!e1 e2.
  (e1, e2) IN E.intra_causality /\
  well_formed_event_structure E
  ==>
  (e1.iiid = e2.iiid) /\
  e1 IN E.events /\
  e2 IN E.events`,
RWTAC [well_formed_event_structure_def, partial_order_def, domain_def, range_def, SUBSET_DEF] THEN
METIS_TAC []);

val wfes_po_iico = Q.store_thm ("wfes_po_iico",
`!E. well_formed_event_structure E ==> partial_order (po_iico E) E.events`,
RWTAC [partial_order_def, well_formed_event_structure_def, po_iico_def, 
       po_strict_def, domain_def, range_def, SUBSET_DEF, transitive_def,
       reflexive_def, antisym_def] THEN
METIS_TAC [LESS_TRANS, LESS_ANTISYM]);

val wfes_proc = Q.store_thm ("wfes_proc",
`!e1 e2. 
  (e1, e2) IN po_iico E /\
  well_formed_event_structure E
  ==> 
  (proc e1 = proc e2)`,
RWTAC [proc_def, po_iico_def, po_strict_def] THEN
METIS_TAC [wfes_intra]);

val events_cases = Q.store_thm ("events_cases",
`!e E. e IN E.events ==> e IN reads E \/ e IN fences E \/ e IN writes E`,
RWTAC [reads_def, writes_def, fences_def] THEN
CCONTR_TAC THEN
FSTAC [] THEN
Cases_on `e.action` THEN
RWTAC [] THEN
Cases_on `d` THEN
RWTAC []);

val events_disj = Q.store_thm ("events_disj",
`!e E. ~(e IN mem_reads E /\ e IN mem_writes E) /\
       ~(e IN reads E /\ e IN writes E) /\
       ~(e IN reads E /\ e IN mfences E) /\
       ~(e IN mfences E /\ e IN writes E) /\
       ~(e IN reads E /\ e IN fences E) /\
       ~(e IN fences E /\ e IN writes E)`,
RWTAC [fences_def, reads_def, writes_def, mfences_def, mem_reads_def, mem_writes_def] THEN
Cases_on `e.action` THEN
RWTAC [] THEN
Cases_on `d` THEN
RWTAC []);

(* 
Relies on the fact that there must be an intra-causality edge between ew and ew'
if they are on the same register in an instruction.
*)
val rfmap_func = Q.store_thm ("rfmap_func",
`!E X ew ew' er.
  well_formed_event_structure E /\
  valid_execution E X  /\
  (ew, er) IN X.rfmap /\
  (ew', er) IN X.rfmap
  ==>
  (ew = ew')`,
RWTAC [valid_execution_def, check_rfmap_written_def, in_rfmc] THEN
RES_TAC THEN
FSTAC [maximal_elements_def, previous_writes_def] THEN
`ew IN E.events /\ ew' IN E.events`
          by FSTAC [writes_def] THEN
`ew IN mem_accesses E = ew' IN mem_accesses E` 
          by METIS_TAC [mem_access_lem05] THEN
Cases_on `ew IN mem_accesses E` THEN
FSTAC [] THENL
[IMP_RES_TAC mem_access_lem04 THEN
     FSTAC [maximal_elements_def, linear_order_def, rrestrict_def] THEN
     METIS_TAC [],
 IMP_RES_TAC mem_access_lem04 THEN
     FSTAC [maximal_elements_def, linear_order_def, rrestrict_def] THEN
     METIS_TAC [],
 IMP_RES_TAC mem_access_lem04 THEN
     FSTAC [maximal_elements_def, linear_order_def, rrestrict_def] THEN
     METIS_TAC [],
 IMP_RES_TAC mem_access_lem04 THEN
     FSTAC [maximal_elements_def, linear_order_def, rrestrict_def] THEN
     METIS_TAC [],
 `proc ew = proc ew'`
          by (FSTAC [loc_def, well_formed_event_structure_def] THEN
              Cases_on `er.action` THEN
              FSTAC [] THEN
              Cases_on `ew.action` THEN
              FSTAC [] THEN
              Cases_on `ew'.action` THEN
              FSTAC [writes_def, mem_accesses_def] THEN
              Cases_on `l` THEN
              FSTAC []) THEN
     Cases_on `ew.iiid = ew'.iiid` THENL
     [FSTAC [well_formed_event_structure_def, po_iico_def] THEN
          METIS_TAC [],
      `ew.iiid.poi <> ew'.iiid.poi`
               by (Cases_on `ew.iiid` THEN
                   Cases_on `ew'.iiid` THEN
                   FSTAC [proc_def] THEN
                   FSTAC []) THEN
          `ew.iiid.poi < ew'.iiid.poi \/ ew'.iiid.poi < ew.iiid.poi`
                   by DECIDE_TAC THEN
          FSTAC [po_iico_def, po_strict_def, proc_def]]]);
     
val _ = export_theory ();
