(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

open HolKernel boolLib Parse bossLib pairLib;
open x86_coretypesTheory;

open HolDoc;
val _ = new_theory "x86_types";


(************** Types *****************)

(* here we use a single value type, embedding the types of values in
normal registers, flags, and memory locations *)

val _ = type_abbrev  ("address", ``:Ximm``);
val _ = type_abbrev  ("value", ``:Ximm``); 
val _ = type_abbrev  ("eiid", ``:num``);
val _ = type_abbrev  ("reln", ``:'a # 'a -> bool``);


val _ = Hol_datatype `reg = Reg32 of Xreg | Reg1 of Xeflags | RegEIP`;
val _ = Hol_datatype `dirn = R | W`;
val _ = Hol_datatype `location = Location_reg of proc => reg 
             | Location_mem of address`;
val _ = Hol_datatype `barrier = Lfence | Sfence | Mfence`;
val _ = Hol_datatype `action = Access of dirn => location => value `;
val _ = Hol_datatype `event = <| eiid : eiid ; 
                                 iiid : iiid ; 
                                 action : action |>`;
val _ = Hol_datatype `event_structure = <| procs : proc set ;
                                             events : event set ; 
                                             intra_causality : event reln ;
                                             atomicity : event set set |>`;

val _ = type_abbrev ("state_constraint", ``:location -> value option``);

val _ = type_abbrev ("view_orders", ``:proc -> event reln``);

val _ = Hol_datatype `
  execution_witness = 
    <| initial_state : state_constraint;
       vo : view_orders;
       write_serialization : event reln;
       lock_serialization : event reln;
       rfmap : event reln |>`;

       (*final_state_opt : state_constraint option;*)


(* we abstract out the eiid gensym, to make it nondeterministic here, for simple proofs, but deterministic in future code-extracted versions *)
val _ = type_abbrev("eiid_state", ``: eiid set ``);
val _ = Define `(next_eiid : eiid_state -> (eiid # eiid_state) set) eiids = { (eiid,eiids UNION {eiid}) | eiid | ~(eiid IN eiids)}`;
val _ = Define `(initial_eiid_state : eiid_state) = {} `;





(* ******** LTS ********* *)

val _ = Hol_datatype `machine_visible_label = 
    <| mvl_event : event ; 
       mvl_iico : event set;
       mvl_first_of_instruction : bool;
       mvl_last_of_instruction : bool;
       mvl_locked : bool |>`;

val _ = Hol_datatype `lts_monad_visible_label = 
    <| lmvl_iiid : iiid ; 
       lmvl_action : action |>`;

val _ = Hol_datatype 
  `label = Vis of 'a | Tau` ;

val _ = type_abbrev ("machine_label", ``: machine_visible_label label``);

val _ = type_abbrev ("lts_monad_label", ``:lts_monad_visible_label label ``);



val _ = Hol_datatype `  LTS = <| states : 'state set;
                                initial : 'state;
                                final : ('state # 'value) set;
                                trans : ('state # ('visible label) # 'state) set |> `;


val _ = export_theory ();
