type ('a,'b) hom

type 'a next
type one
type ('a,'b) prod
type ('a,'b) exp
type ('a,'b) sum
type 'a stream
type 'a discrete
type 'a gui


type ('a,'b) iso
type 'a delay 

val id : ('a,'a) hom
val compose : ('a,'b) hom -> ('b,'c) hom -> ('a,'c) hom

val into : ('a,'b) iso -> ('a,'b) hom
val from : ('a,'b) iso -> ('b,'a) hom

val id_iso : ('a,'a) iso
val compose_iso : ('a,'b) iso -> ('b,'c) iso -> ('a,'c) iso 


(* Delay operators *)

val delay_one      : one delay
val delay_prod     : 'a delay -> 'b delay -> ('a,'b) prod delay
val delay_exp      : ('a,'b) exp delay
val delay_sum      : 'a delay -> 'b delay -> ('a,'b) sum delay
val delay_stream   : 'a delay -> 'a stream delay
val delay_next     : 'a delay -> 'a next delay
val delay_discrete : 'a discrete delay
val delay_gui      : 'a gui delay
val delay     : 'a delay -> ('a, 'a next) hom 

val next_one  : (one next, one) iso
val next_prod : (('a,'b) prod next, ('a next, 'b next) prod) iso
val next_exp  : (('a,'b) exp next, ('a next, 'b next) exp) iso

val map_next  : ('a, 'b) hom -> ('a next, 'b next) hom
val map_next_iso : ('a,'b) iso -> ('a next, 'b next) iso 

(* Unit type *)

val one : ('a, one) hom

(* Pairing *)

val fst : (('a,'b) prod, 'a) hom 
val snd : (('a,'b) prod, 'b) hom 
val pair : ('a,'b) hom -> ('a,'c) hom -> ('a, ('b,'c) prod) hom

val map_prod : ('a,'b) hom -> ('c,'d) hom -> (('a,'c) prod, ('b,'d) prod) hom 
val map_prod_iso : ('a,'b) iso -> ('c,'d) iso -> (('a,'c) prod, ('b,'d) prod) iso

val comm  : (('a,'b) prod, ('b,'a) prod) iso
val unit  : (('a,one) prod, 'a) iso
val assoc : ((('a,'b) prod, 'c) prod, ('a, ('b,'c) prod) prod) iso 

(* Sums *)

val inl : ('a, ('a,'b) sum) hom
val inr : ('a, ('b,'a) sum) hom
val case : ('a,'b) hom -> ('c,'b) hom -> (('a,'c) sum, 'b) hom

val map_sum : ('a,'b) hom -> ('c,'d) hom -> (('a,'c) sum, ('b,'d) sum) hom 
val map_sum_iso : ('a,'b) iso -> ('c,'d) iso -> (('a,'c) sum, ('b,'d) sum) iso 

(* This is derivable in closed categories, but it's more efficient
   to implement it directly *)

val distrib : (('a, ('b,'c) sum) prod, (('a,'b) prod, ('a,'c) prod) sum) iso 

(* Streams *)

val head : ('a stream, 'a) hom
val tail : ('a stream, 'a stream next) hom
val unfold : (('a, ('b, 'a next) prod) exp,  ('a, 'b stream) exp) hom
val cons : (('a, 'a stream next) prod, 'a stream) hom
val constant : 'a delay -> ('a, 'a stream) hom 

val map_stream : ('a,'b) hom -> ('a stream, 'b stream) hom
val map_stream_iso : ('a,'b) iso -> ('a stream, 'b stream) iso

val zip : (('a stream, 'b stream) prod, ('a,'b) prod stream) iso 

val stream_strength : ((('a,'b) exp, 'a stream) prod, 'b stream) hom

(* Functions *)

val curry : 'a delay -> (('a,'b) prod, 'c) hom -> ('a, ('b,'c) exp) hom
val eval : ((('a,'b) exp, 'a) prod, 'b) hom

val map_exp : ('a,'b) hom -> ('c,'d) hom -> (('b,'c) exp, ('a,'d) exp) hom 
val map_exp_iso : ('a,'b) iso -> ('c,'d) iso -> (('b,'c) exp, ('a,'d) exp) iso
 
(* Discrete (ML) types *)

val embed : 'a -> ('b, 'a discrete) hom 
val one_discrete   : (one, unit discrete) iso
val pair_discrete  : (('a discrete, 'b discrete) prod, ('a * 'b) discrete) iso
val exp_discrete   : (('a -> 'b) discrete, ('a discrete, 'b discrete) exp) hom  

(* Fixed points -- we have a special case for the base type of streams *)
    
val fix_stream : 'b delay -> (('a, 'b stream next) prod, 'b stream) hom -> ('a, 'b stream) hom
val fix_fun : (('a, ('b,'c) exp next) prod, ('b,'c) exp) hom -> ('a, ('b,'c) exp) hom 



(* GUI operations *)

val return   : ('a, 'a gui) hom
val bind     : ('a, 'b gui) hom -> ('a gui, 'b gui) hom
val strength : (('a, 'b gui) prod, ('a,'b) prod gui) hom

val fix_guistream : 'b delay -> 
  (('a, 'b stream next) prod, 'b stream gui) hom -> ('a, 'b stream gui) hom 
  
val label    : [`LEFT | `RIGHT | `CENTER | `FILL] -> (string discrete stream, one gui) hom 
val button   : (string discrete stream, bool discrete stream gui) hom
val checkbox : (string discrete stream, bool discrete stream gui) hom
val stack : [`HORIZONTAL | `VERTICAL] -> 
	    [`HOMOGENEOUS | `INHOMOGENEOUS] ->
            [`START | `FINISH] ->
            [`EXPAND | `NOEXPAND] -> 
            ('a gui, 'a gui) hom 


(* Run a program *)

val run : (one, 'a discrete stream) hom -> (unit -> 'a)
val guirun : (one, one gui) hom -> unit

