open Camlp4.PreCast
open Term

type ast = string -> Camlp4.PreCast.Ast.loc -> Camlp4.PreCast.Ast.expr

let op0 id : ast = fun p _loc ->
  <:expr< ($uid:p$ . $lid:id$) >>;;
let op1 id (f : ast) : ast = fun p _loc ->
  <:expr< $uid:p$ . $lid:id$ $(f p _loc)$>>;;
let op2 id (f1 : ast) (f2 : ast) : ast = fun p _loc ->
  <:expr< ($uid:p$ . $lid:id$ $(f1 p _loc)$ $(f2 p _loc)$) >>;;

let id = op0 "id"
let compose = op2 "compose"

let into = op1 "into"
let from = op1 "from"

let id_iso = op0 "id_iso"
let compose_iso = op2 "compose_iso"

let rec map_next n ast =
  match n with
  | 0 -> ast
  | m -> op1 "map_next" (map_next (m-1) ast)

let rec map_next_iso n ast =
  match n with 
  | 0 -> ast
  | m -> op1 "map_next_iso" (map_next_iso (m-1) ast)

let delay_one = op0 "delay_one"
let delay_prod = op2 "delay_prod" 
let delay_exp = op0 "delay_exp" 
let delay_gui = op0 "delay_gui" 
let delay_sum = op2 "delay_sum" 
let delay_stream = op1 "delay_stream" 
let delay_next = op1 "delay_next" 
let delay_discrete = op0 "delay_discrete" 
let delay_op = op1 "delay"

let rec make_delay (InT(_, tp')) =
  match tp' with 
  | One            -> delay_one
  | Prod(tp1, tp2) -> delay_prod (make_delay tp1) (make_delay tp2)
  | Arrow(tp1, tp2)-> delay_exp 
  | Sum(tp1, tp2)  -> delay_sum (make_delay tp1) (make_delay tp2)
  | Stream tp      -> delay_stream (make_delay tp)
  | Next tp        -> delay_next (make_delay tp)
  | Gui tp         -> delay_gui
  | Discrete       -> delay_discrete

let delay' tp = delay_op (make_delay tp)

let rec delay n tp =
  match n with
  | 0 -> id
  | _ -> let m = n-1 in compose (delay m tp) (map_next m (delay' tp))

let rec next_one = function
  | 0 -> id_iso 
  | n -> compose_iso (map_next_iso 1 (next_one (n-1))) (op0 "next_one")
		   
let rec next_prod = function
  | 0 -> id_iso 
  | n -> compose_iso (map_next_iso 1 (next_prod (n-1))) (op0 "next_prod")

let rec next_exp = function
  | 0 -> id_iso 
  | n -> compose_iso (map_next_iso 1 (next_exp (n-1))) (op0 "next_exp")

let map_prod = op2 "map_prod"
let map_prod_iso = op2 "map_prod_iso"
let unit = op0 "unit"
let assoc = op0 "assoc"
let comm = op0 "comm" 

let map_exp = op2 "map_exp"

(* Pairs *)

let one = op0 "one"

let pair = op2 "pair"
let pi1 = op0 "fst"
let pi2 = op0 "snd"

(* Sums *)

let inl = op0 "inl"
let inr = op0 "inr"
let case = op2 "case"
let distrib = op0 "distrib"

(* Streams *)

let cons = op0 "cons"
let head = op0 "head"
let tail = op0 "tail"
let unfold = op0 "unfold"
let map_stream = op1 "map_stream"
let stream_strength = op0 "stream_strength"
let zip = op0 "zip"
let constant tp = op1 "constant" (make_delay tp)

let curry tp = op2 "curry" (make_delay tp)
let eval = op0 "eval"

let embed = op1 "embed"
let one_discrete = op0 "one_discrete"
let pair_discrete = op0 "pair_discrete"
let exp_discrete = op0 "exp_discrete"

(* GUIs *)

let return = op0 "return"
let bind = op1 "bind"
let strength = op0 "strength"
let fix_guistream tp = op2 "fix_guistream" (make_delay tp)

(* Fixed points *)

let fix_stream tp = op2 "fix_stream" (make_delay tp)
let fix_fun = op1 "fix_fun"

let fix_next tp j fix f =
  match j with
  | 0 -> fix f
  | n -> let (>>) = compose in
    (curry tp f) >> (from (next_exp n)) >> (map_next n (fix eval))

let embed tm = fun p _loc ->
  <:expr< ($uid:p$ . embed) $tm$ >>;;

let exp_discrete = op0 "exp_discrete"

(* Patterns *)

let rec pattern p i =
  match p with
  | PVar x -> id
  | PUnit -> into (compose_iso (map_prod_iso id_iso (next_one i)) unit)
  | PPair(p1, p2) ->
      let h = compose_iso (map_prod_iso id_iso (next_prod i)) assoc in
      compose (from h) (compose (map_prod (pattern p1 i) id) (pattern p2 i))



(*
let guireturn = op0 "return"
let bind = op1 "bind"
let strength = op0 "strength"


let times f g = pair (compose pi1 f) (compose pi2 g) 
let assocr = pair (compose pi1 pi1) (pair (compose pi1 pi2) pi2)
let assocl = pair (pair pi1 (compose pi2 pi1)) (compose pi2 pi2)

let uncurry = curry(compose (pair (compose (pair pi1 (compose pi2 pi1))
                                     eval)
                               (compose pi2 pi2))
                      eval)

(* Reassociating environments, to move contractive hypotheses into and
   out of the regular context *)

let rec reassoc = function
  | [] -> pi1 
  | _ :: gamma -> compose assocl (times (reassoc gamma) id)
*)
