type tp = InT of Camlp4.PreCast.Ast.Loc.t * tp'
and tp' =
    Arrow of tp * tp
  | One
  | Prod of tp * tp
  | Sum of tp * tp 
  | Discrete
  | Next of tp
  | Stream of tp
  | Gui of tp

val tp_equal : tp -> tp -> bool
 
module Var : 
sig
  type t = string
  val compare : string -> string -> int
end

type var = Var.t

type pat =
  | PVar of var
  | PUnit
  | PPair of pat * pat 

type exp = In of Camlp4.PreCast.Ast.Loc.t * exp'
and exp' =
  | Var of var
  | Let of pat * exp * exp
  | App of exp * exp
  | Lam of pat * exp
  | Unit
  | Pair of exp * exp
  | Fst of exp
  | Snd of exp
  | Inl of exp
  | Inr of exp
  | Case of exp * var * exp * var * exp
  | NextE of exp
  | Await of exp
  | Head of exp
  | Tail of exp
  | Cons of exp * exp
  | Fix of var * exp
  | Annot of exp * tp
  | Map of exp * exp
  | Zip of exp * exp 
  | Unfold of exp 
  | Embed of Camlp4.PreCast.Ast.expr
  | Inject of Camlp4.PreCast.Ast.expr
  | LetGui of pat * exp * exp
  | GuiReturn of exp
(*      
   | Value of exp
   | Annot of exp * tp
   | EmbedF of Camlp4.PreCast.Ast.expr
   | Embed of Camlp4.PreCast.Ast.expr
   | Inject of Camlp4.PreCast.Ast.expr
   | Map of exp
   | Start of exp
   | Stream of exp
   | Cons of exp
   | Fix of exp
   | LetOmega of var * exp * exp
   | Bracket of exp
*)

val loc_exp : exp -> Camlp4.PreCast.Ast.Loc.t
val loc_tp : tp -> Camlp4.PreCast.Ast.Loc.t
val mk_fun : Camlp4.PreCast.Ast.Loc.t -> pat list -> exp -> exp
 
module Vars : Set.S with type elt = Var.t

val freevars : exp -> Vars.t
