# Ucampas template for University of Cambridge 2012 "Project Light" house style
use 5.016;
ucampas->VERSION("1.003"); # check minimally required API version

my %theme =
    (
     blue      => 1,
     turquoise => 2,
     purple    => 3,
     green     => 4,
     orange    => 5,
     red       => 6,    );

# auxiliary function to prepare a
# <li><a href="$cur->rurl($c)">$c->navtitle</a>
# link to node $c
sub linkitem {
    my ($cur, $c) = @_;
    my $title = $c->navtitle;
    $title .= ' ➥' if $c->str_meta eq 'link';
    my $h = text($title);
    if ($cur->nid != $c->nid) {
        my $url = $c->rurl($cur);
        $h = c('*a')
            ->addkey('href', text($url))
            ->append($h) if defined $url;
    }
    $h = c('*li')->append($h);
    return $h;
}

# remove spurious whitespace strings between the
# children of a block-level elements (e.g., <div>)
sub clean_whitespace {
    my ($el) = @_;
    if ($el->tag == META && $el->str =~ /^body|div|ul\z/) {
        for my $c ($el->list) {
            if ($c->tag == TEXT) {
                $c->cut if $c->str =~ /^\s*$/;
            } else {
                clean_whitespace($c);
            }
        }
    }
}

# this file feeds a hash table of parameters associated with the template
{
    'style_url'  => 'https://www.cl.cam.ac.uk/style/ucam2012/',

    # adjust template for this page
    'adjust' => sub {
        my ($t, $out, $cur, $src) = @_;

        # clean up template body
        my $outbody = $out->cd('.l(*html)', '.l(*body)')
            or die('No <body> found in template!\n');
        clean_whitespace($outbody);

	# breadcrumb + section title container
	my $bc = $t->{id}{'breadcrumb'}->up;
	# horizontal breadcrumbs
	my $breadcrumbs =
	    breadcrumbs($cur, ul => 1, firstclass => 'first-child',
			includecur => 1,
			class => 'campl-unstyled-list campl-horizontal-navigation clearfix');
	if ($breadcrumbs && $breadcrumbs->listlen) {
	    # fix-up first and last list item
	    my $li = $breadcrumbs->cl(0);
	    add_class($li->cl(0), 'campl-home', 'ir');
	    my $li = $breadcrumbs->cl($breadcrumbs->listlen-1);
	    my $current = $li->cl(0);
	    $current->setstr('p'); # change <a> to <p>
	    $current->deletekey(text 'href');
	    add_class($current, 'campl-current');

	    $t->{id}{'breadcrumb'}->append($breadcrumbs);
	} else {
	    $t->{id}{'breadcrumb'}->cut();
	}
	# page title
	my $title = $cur->param('organization');
	$bc->append(c('*p(class="campl-page-title campl-sub-section-title")')
		    ->append(text $title));
	# up link for mobile version
	my $up = $cur->up;
	if ($up) {
	    $bc->append(c('*p(class="campl-mobile-parent")')
			->append(c('*a')->setatt(href => $up->rurl($cur))
				 ->append(
				     c('*span(class="campl-back-btn campl-menu-indicator")'),
				     text $up->navtitle)
	));
	}

	# horizontal navigation tabs
        if ($cur->param('menubar') // 1) {
            my $hnav = navbar($cur, undef, domain => 'menu', div => 0,
                              touchtext => 'Overview',
                              topopen => 3, forwardopen => 3, stoplength => 20,
                              class=>"campl-unstyled-list local-dropdown-menu",
                              markonpath =>
                              sub { add_class($_[2], 'campl-selected') },
                              markcurrent =>
                              sub { add_class($_[0], 'campl-active-page') }
                );
            if ($hnav) {
                for my $ul ($hnav->list) {
                    # first level is no local-dropdown-menu
                    $ul->setatt(class => "campl-unstyled-list")
                };
                $t->{id}->{'local-nav'}->append(
                    c('*div(class="campl-local-navigation-container")')
                    ->append($hnav));
            }
        }

        # main columns
	my $content = $t->{id}{'content'};
        my $wrap = $content->up;

        my $main_columns = 9;
        if ($cur->param('navbar')) {
            # left-hand navigation bar (campl-tertiary-navigation-structure)
            my $nav = $wrap->cl(0, 0, 0);
            # vertical breadcrumb
            my @path = $cur->path;
            my $cat = pop @path; # "category page" = non-leaf node
            $cat = pop @path if @path && !$cat->listlen;
            my $bc = c('*ul(class="campl-unstyled-list campl-vertical-breadcrumb")');
            my @bc;
            my $bcind = c('*span(class="campl-vertical-breadcrumb-indicator")');
            for my $c (@path) {
                my $crumb = linkitem($cur, $c);
                $crumb->append($bcind);
                push @bc, $crumb;
            }
            $nav->append($bc->append(@bc)) if @bc;
            # split visible siblings of current "category" node into
            # predecessors and successors
            my @pred;
            my @succ;
            if ($cat->depth) {
                @succ = _visiblelist($cur, $cat->parent);
                while (@succ && $succ[0]->nid != $cat->nid) {
                    push @pred, splice(@succ, 0, 1);
                }
                shift @succ; # remove $cat
            }
            # list predecessors after current "category" node
            # (this reordering of siblings is implemented as a
            # separate step here so we can later skip it as an option)
            unshift @succ, splice(@pred);
            # current "category" node
            my $bcn = c('*ul(class="campl-unstyled-list campl-vertical-breadcrumb-navigation")');
            my $crumb = linkitem($cur, $cat)->setatt(class => 'campl-selected');
            # child nodes
            $crumb->append(
                navbar($cur, $cat, topopen=>1, forwardopen=>1,
                       class => 'campl-unstyled-list campl-vertical-breadcrumb-children',
                       marklink => sub { $_[2]->append(text ' ➥') }
                ));
            $bcn->append($crumb); # append <li> for current "category" node
            $bcn->append(map { linkitem($cur, $_) } @succ); # append <li>s for remaining siblings
            $nav->append($bcn);
        } else {
            # remove left-hand navigation bar
            $wrap->splice(0, 1); # delete <div class="campl-column3">...</div>
            $main_columns += 3;
        }
        $content->setatt(class=>"campl-column$main_columns campl-main-content");

        # source <body>
        my $body = $src->cd('.l(*html)', '.l(*body)')
            or die('No <body> found!\n');
	# merge attributes into destination <body>
        merge_body_attributes($outbody, $body);
	# transfer body content
        my $newbody = $content->append0();
	$newbody->move(c('*div(class="campl-content-container")'));
	$newbody->movelist($body);

        # apply colour theme
        my $theme = $theme{$cur->style_param('colours')};
        add_class($outbody, "campl-theme-$theme") if $theme;

        # sub-title
        my $subtitle_node = $t->{id}{'sub-title'};
        my $subtitle = $cur->param('section') // $cur->title;
        $subtitle_node->append(text $subtitle);
        # adjust column of subtitle
        my $subtitle_column = $subtitle_node->up(2);
        $subtitle_column->setatt('class', "campl-column$main_columns");
        $subtitle_column->prev->cut unless $cur->param('navbar');
        #$subtitle_column->prev->setatt('class', "campl-column" .
        #                               (12-$main_columns) . " campl-spacing-column");

        # remove the first <h1> if it exactly repeats sub-title
        my $h1 = $newbody->lfind(c('*h1'), 0, 1);
        if ($h1 && $h1->listlen <= 1) {
            my $h1_text = $h1->cl(0)->get;
            $h1->cut if ($h1_text eq $subtitle);
        }

        # local and global footers
        my $localfooter = $t->{id}{'local-footer'};
        my $globalfooter = $localfooter->next;
        while ($globalfooter->tag == TEXT) {
            $globalfooter = $globalfooter->next;     # skip space
        }

        # local footer
        my $footer = $cur->paramc('local_footer');
        my $local_footer_logo; # to be removed if we have a global footer

        # prepare and insert standard footnotes at
        # the first <p class="ucampas-footnotes"> found
        sub insert_standard_footnotes {
            my ($cur, $footer) = @_;
            my $p = $footer->lfind(c '*p(class="ucampas-footnotes")', 0);
            return unless $p;
            my @notes = ( page_copyright($cur, "University of Cambridge"),
                          page_contact($cur, "Information provided by "),
                          page_access($cur)
                );
            @notes = interleave(meta 'br', grep { $_ } @notes);
            $p->append(@notes);
            # prepend any provided additional footer HTML
            # to standard footer
            my $footadd = relocate_html($cur->paramc('footadd'), $cur);
            $p->insert($footadd) if $footadd;
            return;
        }

        if ($footer->listlen) {
            insert_standard_footnotes($cur, $footer);
            # format a provided list of columns
            $localfooter->splice(0);
            my $w = $localfooter->append0
                ->move(c('*div(class="campl-wrap clearfix")'));
            my @columns = $footer->list;
            my $allocated_width = 0;
            my $nowidth_cols = 0;
            for my $col (@columns) {
                if ($col->get('width') =~ /^(\d*(?:\.\d*)?)%\z/) {
                    my $width = $1;
                    $width = sprintf("%.0f", 12 * $width / 100);
                    $allocated_width += $width;
                    $col->setatt(class => "campl-column$width");
                    $col->deletekey(text 'width');
                } else {
                    $nowidth_cols++;
                }
            }
            my $columns = $footer->listlen;
            my $default_width =
                sprintf("%.0f", (12-$allocated_width) / $nowidth_cols);
            # a footer is structured into multiple columns,
            # each of which can contain have multiple containers
            # (sections that might start with an <h3>)
            for my $column (@columns) {
                $column->settstr(META, 'div');
                unless ($column->get('class')) {
                    $column->setatt(class => "campl-column$default_width");
                    $allocated_width += $default_width;
                }
                add_class($column, 'campl-footer-navigation');
                for my $container ($column->list) {
                    my @uls = $container->lfind(meta 'ul', 'all', 1);
                    if (@uls) {
                        # assume this is a link list
                        for my $ul (@uls) {
                            $ul->setatt(class => "campl-unstyled-list");
                        }
                        my $linklist =
                            c('*div(class="link-list")')->movelist($container);
                        $container->append($linklist);
                    }
                    $container->settstr(META, 'div');
                    add_class($container, 'campl-content-container'); # 20px padding
                    add_class($container, 'campl-navigation-list');   # except on top
                }
            }
            die("grid with of footer columns ($default_width) is not 12\n")
                unless $allocated_width == 12;
            add_class($columns[$#columns], 'last');
            $w->append(@columns);
            #say $localfooter->print;
        } elsif ($footer->get eq '0') {
            # no local footer
            $localfooter->cut;
        } else {
            # prepare a standard ucampas footer
            my $ucampas_footer = c(<<'EOT');
*div(class='campl-wrap clearfix',
     *div(class='campl-column12',
          *div(class='campl-side-padding',
               *img(alt="University of Cambridge",
                    class="campl-scale-with-grid",
                    style="float: right; padding-left: 30px",
                    height="38", width="178"),
               *p(style="margin:0", class="ucampas-footnotes"),
              ),
         )
    )
EOT

            insert_standard_footnotes($cur, $ucampas_footer);

            # remember University logo in local footer
            $local_footer_logo = $ucampas_footer->cl(0, 0, 0);
            # insert the new local footer into the page template
            $localfooter->splice(0);
            $localfooter->append0->move($ucampas_footer);
        }

        # global footer
        if ($cur->param('global_footer') eq '0') {
            # remove global footer
            $globalfooter->cut;
            # instead keep and configure local-footer logo
            if ($local_footer_logo) {
                $local_footer_logo->
                    setatt('src', prefix_url($t->{images_url},
                                             'img/main-logo-small.svg'));
            }
        } else {
            # remove duplicate logo from local footer
            # (there will be one in the global footer below)
            $local_footer_logo->cut if $local_footer_logo;
            # tweak global footer
            my $copyright = $t->{id}->{'ucam2012-global-copyright'};
            if ($copyright) {
                # remove global copyright
                # (in favour of configurable one in local footer)
                $copyright->cut;
            }
        }
    }
}
