use 5.016;
ucampas->VERSION("1.002"); # check minimally required API version

# this file feeds a hash table of parameters associated with the template
{
    # default URLs for asset directories (override in uconfig.txt)
    'images_url'      => 'https://www.cl.cam.ac.uk/images/',
    'stylesheets_url' => 'https://www.cl.cam.ac.uk/style/',
    'javascript_url'  => 'https://www.cl.cam.ac.uk/js/',

    # adjust template for this page
    'adjust' => sub {
	my ($t, $out, $cur, $src) = @_;

	# colour-map style variants
	my $cc = $cur->style_paramc('colours');
	if (!$cc) {
	    # try old convention before we had style parameters
	    my $style = $cur->paramc('style');
	    $cc = $style->cl(0) if $style;
	}
	if ($cc) {
	    my $colours = $cc->get;
	    if ($colours =~
		/^blue|blue-green|blue-white|green-navy|turq-blue|purple|teal\z/) {
		$t->{'html'}->cd('.l(*html)', '.l(*head)',
				 '.l(*link(media=print))')->insert0(1)->move(
		    c('*link(rel=stylesheet, type="text/css", media=all)')
		    ->setatt('href' => prefix_url($t->{stylesheets_url},
						  "$colours.css")));
	    } elsif ($colours) {
		die($cc->upclass('NavTree')->apath(),
		     ": unknown style colours '$colours'\n");
	    }
	}

	# customize site search
	if (my $search = $cur->paramc('search')) {
	    my $engine=$search->get;
	    my $form=$t->{id}{'site-search'}->lfind(c '*form');
	    my $fieldset=$form->lfind(c '*fieldset');
	    if ($engine eq 'google') {
		$form->setatt('action' => 'https://www.google.co.uk/search');
		$t->{id}{'search-term'}->setatt('name' => 'q');
	    }
	    for my $p ($search->keys) {
		$fieldset->append(c('*input(type=hidden)')
				  ->setatt('name' => $p->get,
					   'value' => $search->get($p)));
	    }
	}

	# add small links (Contact us, A-Z, etc.) to right-hand side of header
	if (my $links = relocate_html($cur->paramc('headlinks'), $cur)) {
	    my @li = map { c('*li')->append($_) } reverse($links->list);
	    add_class($li[0], 'last') if @li;
	    $t->{id}{'site-search'}->append(c('*ul')->append(@li));
	}

	# departmental title
	$t->{id}{'dept-title'}
	->append(c('*h1')->append(c('*a')->setatt('href', $cur->top->rurl($cur))
				  ->append(text($cur->param('organization')))));
	$t->{id}{'dept-title'}
	->append(c('*h2')->append(text($cur->param('organization_subtitle'))))
	    if defined $cur->param('organization_subtitle');

	# fill container element

	my $container = $t->{id}{'container'};
	my $breadcrumbs = breadcrumbs($cur, 'ul' => 1,
				      'id' => 'nav-breadcrumb',
				      'firstclass' => 'first',
				      'includecur' => 1);

	# source body
	my $body = $src->cd('.l(*html)', '.l(*body)')
	    or die('No <body> found!\n');
        # destination body
        my $outbody = $out->cd('.l(*html)', '.l(*body)');
        # merge attributes into destination <body>
        merge_body_attributes($outbody, $body);

	my $primary = $body->lfind('*div(id="content-primary")', 0, 11);

	if (!$primary) {

	    # Algorithm A for regular pages
	    # (source file lacks <div id="content-primary">)
	    my $cols = 1;
	    $container->append($breadcrumbs);
	    if ($cur->param('navbar')) {
		my $navbar =
		    navbar($cur, undef,
			   topopen => 1,
			   forwardopen => 1,
			   maxdepth => 2,
			   maxdepthretry => 1,
			   markcurrent =>
			   sub { $_[1]->parent->setatt(class => 'active') },
			   markswitch  =>
			   sub { $_[1]->cl(0)->append(text ' »') } ,
			   marklink  =>
			   sub { $_[1]->cl(0)->append(text ' →') } );
		if ($navbar) {
		    $navbar->setatt(id => 'nav-primary');
		    $container->append($navbar);
		    $cols++;
		}
	    }

	    # content
	    my $content = $container->append0->move(c('*div(id=content)'));
	    # section header
	    my $section = $cur->param('section');
	    if (defined $section && $section ne '') {
		$content->append(c('*div(id="sub-brand")')
				 ->append(c('*p(class="section")')
					  ->append(text $section)))
	    }

	    my $secondary =
		$body->lfind(c('*div(id="content-secondary")'), 0, 1);
	    if ($secondary) {
		$secondary = $secondary->cut;
		$cols++;
	    }

	    my $primary = $content->append0
		->set(c('*div(id="content-primary")'))->movelist($body);
	    $content->append($secondary);
	    $cols = ('one', 'two', 'three')[$cols-1];
	    add_class($outbody, "$cols-col", "dept");

	} else {

	    # Algorithm B for home-page portals
	    # (source file has <div id="content-primary">)
	    $primary->splice(0, 0, $breadcrumbs) if $breadcrumbs;
	    $container->append(c('*div(id=content)')->movelist($body));

	}

	# site-info footers
	my $siteinfo = $container->append0->move(c('*ul(id="site-info")'));

	my @footer = ( page_copyright($cur, "University of Cambridge"),
		       page_contact($cur, "Information provided by "),
		       page_access($cur)
	    );
	@footer = interleave(meta 'br', grep { $_ } @footer);
	$siteinfo->append(wrap(c('*li(class=copy)'), @footer));

	# add small links (policy, etc.) to right-hand side footer
	if (my $links = relocate_html($cur->paramc('footlinks'), $cur)) {
	    my @li = map {
		c('*li(class="link")')->append($_)
	    } reverse($links->list);
	    add_class($li[0], 'last') if @li;
	    $siteinfo->append(@li);
	}

	# additional footer content
	if (my $footadd = relocate_html($cur->paramc('footadd'), $cur)) {
	    $siteinfo->append(c('*li')->copyfrom_sub($footadd));
	}

    }
}
