use 5.016;
ucampas->VERSION("1.000"); # check minimally required API version

# this file feeds a hash table of parameters associated with the template
{
    # default URLs for asset directories (override in uconfig.txt)
    'images_url'      => 'https://www.cl.cam.ac.uk/style/cscubed2015/',
    'stylesheets_url' => 'https://www.cl.cam.ac.uk/style/',
    'javascript_url'  => 'https://www.cl.cam.ac.uk/js/',

    # adjust template for this page
    'adjust' => sub {
	my ($t, $out, $cur, $src) = @_;

	# insert menu tabs into <div class=menu-holder>
	append_navtabs
	    ($t->{id}{'menu-holder'}, $cur, undef,
	     markcurrent =>
	     sub { $_[1]->parent->setatt(class => 'page_item current_page_item') },
	     markonpath =>
	     sub { $_[1]->parent->setatt(class => 'page_item current_page_parent') });

	# create left-column from advert and available img-*.jpg files
	my $leftcolumn = c('*div(id=left-column)');
	my $advert = $cur->paramc('advert');
	$leftcolumn->append($advert) if $advert and !$advert->isempty;
	my $images =  c('*div(id=images, class=rounded)');
	my $dir = $cur->fdirname;
	for (my $i = 1; 1; $i++) {
	    my $fn = "img-$i.jpg";
	    last unless -r $dir . "img-$i.jpg";
	    $images->append(c('*img(alt="")')->setatt(src => $fn)); # width: 230px
	}
	if ($images->listlen) {
	    $leftcolumn->append($images);
	} else {
	    my $default_image = $cur->paramc('default_image');
	    if ($default_image) {
		my $d = PlexTree::new->copyfrom($default_image);
		for my $img ($d->lfind(c('*img'),'all')) {
		    my $src = $img->cd('src');
		    $src->set(text NavTree::rurl($src->get, $cur))
			if $img->str_meta eq 'img' && $src;
		}
		$images->append($d);
		$leftcolumn->append($images);
	    }
	}
	$t->{id}{'content'}->append($leftcolumn) if $leftcolumn->listlen;

	# transfer <body>
	my $body = $src->cd('.l(*html)', '.l(*body)') or die('No <body> found!\n');
	$t->{id}{'content'}->append(c('*div(id=right-column)')->movelist($body));
	my $outbody = $out->cd('.l(*html)', '.l(*body)');
	# give <body> a default class based on path
	my @path = $cur->path();
	shift @path;
	$outbody->setatt('class', join('-', map {s/\///;$_} map {$_->str} @path));
	# copy over body attributes
	$outbody->copyfrom_dir($body);

	# add footlinks
	if (my $footlinks = $cur->paramc('footlinks')) {
            my @li;
            foreach my $p ($footlinks->list) {
                my $a = c('*a')->copyfrom_sub($p);
                if (my $href = $a->get('href')) {
                    $a->setatt('href', NavTree::rurl($href, $cur));
                }
                push @li, c('*li(class="link")')->append($a);
            }
            if (@li) {
                add_class($li[0], 'last');
                $t->{id}{'footer-holder'}->append(c('*ul( id="sub-menu")')->append(@li));
            }
        }
    }
}
