-------------------------------------------------------------------------------
--
-- SKIPJACK Blockcipher
--
-- Markus G. Kuhn <mkuhn@acm.org>
--
-- $Id: skipjack.ads,v 1.2 1998-06-24 20:43:30+00 mgk25 Rel $
--
-------------------------------------------------------------------------------
--
-- This is an Ada 95 implementation of the SKIPJACK blockcipher algorithm
-- as specified in version 2.0 of NSA's SKIPJACK specification dated
-- 1998-05-29 <http://csrc.nist.gov/encryption/skipjack-kea.htm>.
--
-------------------------------------------------------------------------------

with Interfaces; use Interfaces;

package Skipjack is

   pragma Pure(Skipjack);

   type    Bytes is array (Natural range <>) of Unsigned_8;
   subtype Block is Bytes (0 .. 7);

   -- To conform to the NSA specification, cryptovariable Key should be of
   -- type Bytes (0 .. 9), which is 80 bits long. Other key lengths work as
   -- well here, but if Key'Length /= 10 is used, be aware that this will
   -- not be a conforming SKIPJACK implementation.

   procedure Encrypt (Key : in Bytes; Plaintext  :  in Block;
				      Ciphertext : out Block);

   procedure Decrypt (Key : in Bytes; Ciphertext :  in Block;
				      Plaintext  : out Block);

   procedure Selftest;

   Implementation_Error : exception;  -- raised if Selftest failed

end Skipjack;
