#
#

use IO::Handle;
use Socket;

$osc_debug = 0;
$osc_connected = 0;

sub osc_connect {
	local($arg_hostname, $arg_port, $arg_instr) = @_;
	local($iaddr, $proto, $paddr, $temp);

	if ($osc_connected) {
		$! = "already connected";
		return undef;
	}

	$iaddr = gethostbyname($arg_hostname) || return undef;
	if ($osc_debug) {
		print "connecting to ".inet_ntoa($iaddr).":".$arg_port."\n";
	}
	$proto = getprotobyname('tcp') || return undef;
	$paddr = sockaddr_in($arg_port, $iaddr) || return undef;
	socket(OSC_SOCK, PF_INET, SOCK_STREAM, $proto) || return undef;
	connect(OSC_SOCK, $paddr) || return undef;
	OSC_SOCK->autoflush(1);

	$osc_connected = 1;
	if (!osc_instrument($arg_instr)) {
		close OSC_SOCK;
		$osc_connected = 0;
		return undef;
	}

	return(1);
}

sub osc_disconnect {
	if ($osc_connected) {
		close OSC_SOCK || return undef;
	} else {
		$! = "not connected";
		return undef;
	}
}

sub osc_parse_error {
	local($arg) = @_;
	local($command, $result, $details) = split(/:/, $arg);
	return($result, $details);
}


sub osc_write {
	local($arg) = @_;
	local($line, $local, $details);

	if (!$osc_connected) {
		$! = "not connected";
		return undef;
	}

	# write out the line
	print OSC_SOCK "write ".$arg."\n" || return undef;
	# check for OK
	$line = <OSC_SOCK> || return undef;
	chop($line);
	($result, $details) = osc_parse_error($line);
	if (! $result =~/ok/) {
		$! = $details;
		return(undef);
	}
	return(1);
}

sub osc_instrument {
	local($arg) = @_;
	local($line, $local, $details);

	if (!$osc_connected) {
		$! = "not connected";
		return undef;
	}

	print OSC_SOCK "instrument ".$arg."\n" || return undef;
	# check for OK
	$line = <OSC_SOCK> || return undef;
	chop($line);
	($result, $details) = osc_parse_error($line);
	if (! $result =~/ok/) {
		$! = $details;
		return(undef);
	}
	return(1);
}


sub osc_read {
	local($resp, $line, $bytes, $bytesread, $result, $details, $data);

	if (!$osc_connected) {
		$! = "not connected";
		return undef;
	}

	print OSC_SOCK "read\n" || return(undef);
	$resp = <OSC_SOCK> || return(undef);
	($result, $details) = osc_parse_error($resp);
	if (! $result =~/ok/) {
		$! = $details;
		return(undef);
	}
	$details =~/\s*returned (\d+) bytes/;
	$bytes = $1;
	
	$bytesread = read OSC_SOCK, $data, $bytes || return(undef);
	chop($data);	# remove trailing \n
	$bytesread--;

	return ($bytesread, $data);
}

sub osc_waveform_parse {
	local($arg) = @_;
	local($numdigits, $header, $data);

	$arg =~/#(\d).*/;
	$numdigits = $1;
	$arg =~/#\d(\d{$numdigits})(.*)/;
	$header = $numdigits.$1;
	$data = $2;
	return($header, $data);
}

sub osc_data_to_point {
	local($x, $xinc, $xorig, $xref, $y, $yinc, $yorig, $yref) = @_;

	return ((($x - $xref) * $xinc) + $xorig,
		(($y - $yref) * $yinc) + $yorig);
}

sub osc_parse_preamble {
	local($string) = @_;

	return(split(/,/, $string));
}

sub osc_waveform_to_text {
	local($data, $xinc, $xorig, $xref, $yinc, $yorig, $yref) = @_;
	local(@results, $value, $string, $i, $x, $y);

	@results = unpack("C*", $data);

	$i = 0;
	foreach $value (@results) {
		($x, $y) = osc_data_to_point($i, $xinc, $xorig, $xref,
		    $value, $yinc, $yorig, $yref);

		$string .= "$x, $y\n";
		$i++;
	}

	return($string);
}

return 1;
